/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.support.guice;

import com.google.common.collect.Iterables;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.ovea.tajin.framework.support.guice.Jsr250Destroyer;
import com.ovea.tajin.framework.support.guice.Jsr250Injector;
import com.ovea.tajin.framework.support.guice.Jsr250Module;
import com.ovea.tajin.framework.support.guice.Jsr250PreDestroyHandler;
import com.ovea.tajin.framework.util.Reflect;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.annotation.PreDestroy;

public final class Jsr250 {
    private Jsr250() {
    }

    public static Jsr250Injector createInjector(Module ... modules) {
        return Jsr250.createInjector(Arrays.asList(modules));
    }

    public static Jsr250Injector createInjector(Iterable<? extends Module> modules) {
        return Jsr250.createInjector(Stage.DEVELOPMENT, modules);
    }

    public static Jsr250Injector createInjector(Stage stage, Module ... modules) {
        return Jsr250.createInjector(stage, Arrays.asList(modules));
    }

    public static Jsr250Injector createInjector(Stage stage, Iterable<? extends Module> modules) {
        DestroyModule destroyModule = new DestroyModule();
        modules = Iterables.concat(Arrays.asList(destroyModule), modules);
        try {
            return Guice.createInjector(stage, Iterables.concat(modules, Arrays.asList(new Jsr250Module()))).getInstance(Jsr250Injector.class);
        }
        catch (RuntimeException e) {
            destroyModule.destroy();
            throw e;
        }
    }

    public static Module newJsr250Module() {
        return new Jsr250Module();
    }

    public static boolean hasJSR250Module(Injector injector) {
        return injector.getBindings().containsKey(Key.get(Jsr250Destroyer.class));
    }

    public static <T> void preDestroy(T instance) {
        TypeLiteral<?> type = TypeLiteral.get(Reflect.getTargetClass(instance));
        Jsr250PreDestroyHandler handler = new Jsr250PreDestroyHandler();
        for (Method method : Iterables.filter(Reflect.findMethods(type.getRawType()), Reflect.annotatedBy(PreDestroy.class))) {
            handler.handle(type, instance, method, method.getAnnotation(PreDestroy.class));
        }
    }

    private static class DestroyModule
    implements Module {
        @Inject
        private Jsr250Injector injector;

        private DestroyModule() {
        }

        @Override
        public void configure(Binder binder) {
            binder.requestInjection(this);
        }

        void destroy() {
            if (this.injector != null) {
                this.injector.destroy();
            }
        }
    }
}

