/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.jmx;

import com.ovea.tajin.framework.jmx.Access;
import com.ovea.tajin.framework.jmx.ClassUtils;
import com.ovea.tajin.framework.jmx.JmxAttribute;
import com.ovea.tajin.framework.jmx.JmxUtils;
import java.lang.reflect.Field;
import javax.management.InvalidAttributeValueException;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;

public final class MBeanAttribute<T>
implements JmxAttribute<T> {
    private final Field field;
    private final ModelMBeanAttributeInfo attributeInfo;

    public MBeanAttribute(Field field, String exportName, String description, Access access) {
        this.field = field;
        this.attributeInfo = new ModelMBeanAttributeInfo(exportName, field.getType().getName(), description, access == Access.RO || access == Access.RW, access == Access.WO || access == Access.RW, false);
    }

    @Override
    public String getName() {
        return this.getMetadata().getName();
    }

    @Override
    public ModelMBeanAttributeInfo getMetadata() {
        return this.attributeInfo;
    }

    @Override
    public T get(Object managedResource) throws ReflectionException {
        if (!this.getMetadata().isReadable()) {
            throw new ReflectionException(new IllegalAccessException("Attribute not readable: " + this), "Attribute not readable: " + this);
        }
        if (!this.field.isAccessible()) {
            this.field.setAccessible(true);
        }
        try {
            return (T)this.field.get(managedResource);
        }
        catch (Exception e) {
            throw JmxUtils.rethrow(e);
        }
    }

    @Override
    public void set(Object managedResource, T value) throws InvalidAttributeValueException, ReflectionException {
        if (!this.getMetadata().isWritable()) {
            throw new ReflectionException(new IllegalAccessException("Attribute not writable: " + this), "Attribute not writable: " + this);
        }
        if (!this.field.isAccessible()) {
            this.field.setAccessible(true);
        }
        if (!ClassUtils.isAssignableValue(this.field.getType(), value)) {
            throw new InvalidAttributeValueException("Invalid type specified for attribute " + this + ": " + value);
        }
        try {
            this.field.set(managedResource, value);
        }
        catch (Exception e) {
            throw JmxUtils.rethrow(e);
        }
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MBeanAttribute that = (MBeanAttribute)o;
        return this.field.equals(that.field);
    }

    public int hashCode() {
        return this.field.hashCode();
    }
}

