/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.support.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;

public class RangeFilter
extends Filter<ILoggingEvent> {
    Level min = Level.TRACE;
    Level max = Level.ERROR;

    @Override
    public FilterReply decide(ILoggingEvent event) {
        if (!this.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        if (event.getLevel().isGreaterOrEqual(this.min) && this.max.isGreaterOrEqual(event.getLevel())) {
            return FilterReply.NEUTRAL;
        }
        return FilterReply.DENY;
    }

    public void setMin(String level) {
        this.min = Level.toLevel(level);
    }

    public void setMax(String level) {
        this.max = Level.toLevel(level);
    }

    @Override
    public void start() {
        if (this.min != null) {
            super.start();
        }
    }
}

