/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.io;

import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Utf8LineParser;
import org.eclipse.jetty.websocket.client.ClientUpgradeResponse;

public class HttpResponseHeaderParser {
    private static final Pattern PAT_HEADER = Pattern.compile("([^:]+):\\s*(.*)");
    private static final Pattern PAT_STATUS_LINE = Pattern.compile("^HTTP/1.[01]\\s+(\\d+)\\s+(.*)", 2);
    private ClientUpgradeResponse response;
    private Utf8LineParser lineParser = new Utf8LineParser();
    private State state = State.STATUS_LINE;

    public boolean isDone() {
        return this.state == State.END;
    }

    public ClientUpgradeResponse parse(ByteBuffer buf) throws ParseException {
        while (!this.isDone() && buf.remaining() > 0) {
            String line = this.lineParser.parse(buf);
            if (line == null || !this.parseHeader(line)) continue;
            ByteBuffer copy = ByteBuffer.allocate(buf.remaining());
            BufferUtil.put(buf, copy);
            BufferUtil.flipToFlush(copy, 0);
            this.response.setRemainingBuffer(copy);
            return this.response;
        }
        return null;
    }

    private boolean parseHeader(String line) throws ParseException {
        switch (this.state) {
            case STATUS_LINE: {
                this.response = new ClientUpgradeResponse();
                Matcher mat = PAT_STATUS_LINE.matcher(line);
                if (!mat.matches()) {
                    throw new ParseException("Unexpected HTTP upgrade response status line [" + line + "]");
                }
                try {
                    this.response.setStatusCode(Integer.parseInt(mat.group(1)));
                }
                catch (NumberFormatException e) {
                    throw new ParseException("Unexpected HTTP upgrade response status code", e);
                }
                this.response.setStatusReason(mat.group(2));
                this.state = State.HEADER;
                break;
            }
            case HEADER: {
                if (StringUtil.isBlank(line)) {
                    this.state = State.END;
                    return this.parseHeader(line);
                }
                Matcher header = PAT_HEADER.matcher(line);
                if (!header.matches()) break;
                String headerName = header.group(1);
                String headerValue = header.group(2);
                this.response.addHeader(headerName, headerValue);
                break;
            }
            case END: {
                this.state = State.STATUS_LINE;
                return true;
            }
        }
        return false;
    }

    private static enum State {
        STATUS_LINE,
        HEADER,
        END;

    }

    public static class ParseException
    extends RuntimeException {
        public ParseException(String message) {
            super(message);
        }

        public ParseException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

