/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.api.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;

public class WebSocketBlockingConnection {
    private final RemoteEndpoint remote;

    public WebSocketBlockingConnection(Session session) {
        this.remote = session.getRemote();
    }

    public void write(byte[] data, int offset, int length) throws IOException {
        ByteBuffer buf = ByteBuffer.wrap(data, offset, length);
        this.remote.sendBytes(buf);
    }

    public void write(String message) throws IOException {
        this.remote.sendString(message);
    }
}

