/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.generator;

import java.nio.ByteBuffer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.spdy.frames.ControlFrame;
import org.eclipse.jetty.spdy.frames.RstStreamFrame;
import org.eclipse.jetty.spdy.generator.ControlFrameGenerator;
import org.eclipse.jetty.util.BufferUtil;

public class RstStreamGenerator
extends ControlFrameGenerator {
    public RstStreamGenerator(ByteBufferPool bufferPool) {
        super(bufferPool);
    }

    @Override
    public ByteBuffer generate(ControlFrame frame) {
        RstStreamFrame rstStream = (RstStreamFrame)frame;
        int frameBodyLength = 8;
        int totalLength = 8 + frameBodyLength;
        ByteBuffer buffer = this.getByteBufferPool().acquire(totalLength, true);
        BufferUtil.clearToFill(buffer);
        this.generateControlFrameHeader(rstStream, frameBodyLength, buffer);
        buffer.putInt(rstStream.getStreamId() & Integer.MAX_VALUE);
        buffer.putInt(rstStream.getStatusCode());
        buffer.flip();
        return buffer;
    }
}

