/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.template;

import com.ovea.tajin.framework.template.ResolvedTemplate;
import com.ovea.tajin.framework.template.TemplateResolver;
import com.ovea.tajin.framework.template.TemplateResolverException;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class CachingTemplateResolver
implements TemplateResolver {
    private static final Object NULL = new Object();
    private final ConcurrentMap<String, Object> cache = new ConcurrentHashMap<String, Object>();
    private final TemplateResolver resolver;

    public CachingTemplateResolver(TemplateResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public ResolvedTemplate resolve(String path, Locale locale) throws TemplateResolverException {
        String key = path + locale;
        Object obj = this.cache.get(key);
        if (obj == null) {
            try {
                obj = this.resolver.resolve(path, locale);
            }
            catch (TemplateResolverException e) {
                obj = NULL;
            }
            Object old = this.cache.putIfAbsent(key, obj);
            if (old != null) {
                obj = old;
            }
        }
        if (obj == NULL) {
            throw new TemplateResolverException("Cannot resolve template for path " + path);
        }
        return (ResolvedTemplate)obj;
    }
}

