/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.jmx;

import com.ovea.tajin.framework.jmx.AopUtils;
import com.ovea.tajin.framework.jmx.ContextualDynamicMBean;
import com.ovea.tajin.framework.jmx.DefaultDynamicMBean;
import com.ovea.tajin.framework.jmx.DiscoveringMetadataAssembler;
import com.ovea.tajin.framework.jmx.ExportBehavior;
import com.ovea.tajin.framework.jmx.JmxExportException;
import com.ovea.tajin.framework.jmx.JmxExporter;
import com.ovea.tajin.framework.jmx.JmxMetadata;
import com.ovea.tajin.framework.jmx.JmxMetadataAssembler;
import com.ovea.tajin.framework.jmx.JmxNamingStrategy;
import com.ovea.tajin.framework.jmx.JmxServerFactory;
import com.ovea.tajin.framework.jmx.JmxUtils;
import com.ovea.tajin.framework.jmx.MBeanNamingStrategy;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.StandardMBean;

public class MycilaJmxExporter
implements JmxExporter {
    private final MBeanServer mBeanServer;
    private ExportBehavior exportBehavior = ExportBehavior.FAIL_ON_EXISTING;
    private JmxNamingStrategy namingStrategy = new MBeanNamingStrategy();
    private JmxMetadataAssembler metadataAssembler = new DiscoveringMetadataAssembler();
    private boolean ensureUnique = false;

    public MycilaJmxExporter() {
        this(new JmxServerFactory().locateDefault());
    }

    public MycilaJmxExporter(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    @Override
    public void unregister(ObjectName objectName) {
        if (this.getMBeanServer().isRegistered(objectName)) {
            this.doUnregister(objectName);
        }
    }

    @Override
    public ObjectName register(Object managedResource) throws JmxExportException {
        try {
            ObjectName objectName = this.namingStrategy.getObjectName(managedResource);
            if (this.ensureUnique) {
                objectName = JmxUtils.appendIdentityToObjectName(objectName, managedResource);
            }
            this.register(managedResource, objectName);
            return objectName;
        }
        catch (MalformedObjectNameException e) {
            throw new JmxExportException("Unable to generate ObjectName for MBean [" + managedResource.getClass().getName() + "]", e);
        }
    }

    @Override
    public void register(Object managedResource, ObjectName objectName) throws JmxExportException {
        if (JmxUtils.isMBean(managedResource.getClass())) {
            this.doRegister(managedResource, objectName);
        } else {
            DynamicMBean mbean = this.adaptMBeanIfPossible(managedResource);
            if (mbean == null) {
                mbean = this.createMBean(managedResource);
            }
            this.doRegister(mbean, objectName);
        }
    }

    @Override
    public MBeanServer getMBeanServer() {
        return this.mBeanServer;
    }

    public void setEnsureUnique(boolean ensureUnique) {
        this.ensureUnique = ensureUnique;
    }

    public void setExportBehavior(ExportBehavior exportBehavior) {
        this.exportBehavior = exportBehavior;
    }

    public void setMetadataAssembler(JmxMetadataAssembler metadataAssembler) {
        this.metadataAssembler = metadataAssembler;
    }

    public void setNamingStrategy(JmxNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    protected void doUnregister(ObjectName objectName) {
        try {
            this.getMBeanServer().unregisterMBean(objectName);
        }
        catch (JMException jMException) {
            // empty catch block
        }
    }

    protected void doRegister(Object managedResource, ObjectName objectName) {
        try {
            this.getMBeanServer().registerMBean(managedResource, objectName);
        }
        catch (InstanceAlreadyExistsException e) {
            if (this.exportBehavior == ExportBehavior.REPLACE_EXISTING) {
                this.doUnregister(objectName);
                try {
                    this.getMBeanServer().registerMBean(managedResource, objectName);
                }
                catch (JMException e2) {
                    throw new JmxExportException("Unable to register MBean [" + managedResource.getClass().getName() + "] with object name [" + objectName + "]", e2);
                }
            }
            if (this.exportBehavior == ExportBehavior.FAIL_ON_EXISTING) {
                throw new JmxExportException("Unable to register MBean [" + managedResource.getClass().getName() + "] with object name [" + objectName + "]", e);
            }
        }
        catch (JMException e) {
            throw new JmxExportException("Unable to register MBean [" + managedResource.getClass().getName() + "] with object name [" + objectName + "]", e);
        }
    }

    protected DynamicMBean adaptMBeanIfPossible(Object bean) {
        Class<?> targetClass = AopUtils.getTargetClass(bean);
        if (targetClass != bean.getClass()) {
            Class ifc = JmxUtils.getMXBeanInterface(targetClass);
            if (ifc != null) {
                if (ifc.isInstance(bean)) {
                    return new StandardMBean(bean, ifc, true);
                }
                throw new JmxExportException("Managed bean [" + bean + "] has a target class with an MXBean interface but does not expose it in the proxy");
            }
            ifc = JmxUtils.getMBeanInterface(targetClass);
            if (ifc != null) {
                if (ifc.isInstance(bean)) {
                    return new StandardMBean(bean, ifc, false);
                }
                throw new JmxExportException("Managed bean [" + bean + "] has a target class with an MBean interface but does not expose it in the proxy");
            }
        }
        return null;
    }

    protected DynamicMBean createMBean(Object managedResource) {
        Class<?> targetClass = AopUtils.getTargetClass(managedResource);
        JmxMetadata metadata = this.getJmxMetadata(targetClass);
        return new ContextualDynamicMBean(new DefaultDynamicMBean(managedResource, metadata), managedResource.getClass().getClassLoader());
    }

    protected JmxMetadata getJmxMetadata(Class<?> clazz) {
        return this.metadataAssembler.getMetadata(clazz);
    }
}

