/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.jmx;

import com.ovea.tajin.framework.jmx.BeanProperty;
import com.ovea.tajin.framework.jmx.ClassUtils;
import com.ovea.tajin.framework.jmx.ExceptionUtils;
import com.ovea.tajin.framework.jmx.Role;
import java.lang.reflect.AccessibleObject;
import java.util.Hashtable;
import javax.management.Descriptor;
import javax.management.DynamicMBean;
import javax.management.MXBean;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public final class JmxUtils {
    private static final String MBEAN_SUFFIX = "MBean";
    private static final String MXBEAN_SUFFIX = "MXBean";
    private static final String MXBEAN_ANNOTATION_CLASS_NAME = "javax.management.MXBean";
    private static final boolean mxBeanAnnotationAvailable = ClassUtils.isPresent("javax.management.MXBean", JmxUtils.class.getClassLoader());

    private JmxUtils() {
    }

    public static ReflectionException rethrow(Throwable e) throws ReflectionException {
        throw new ReflectionException(ExceptionUtils.rethrowOrWrap(e), e.getMessage());
    }

    public static ObjectName appendIdentityToObjectName(ObjectName objectName, Object managedResource) throws MalformedObjectNameException {
        Hashtable<String, String> keyProperties = objectName.getKeyPropertyList();
        keyProperties.put("identity", Integer.toHexString(System.identityHashCode(managedResource)));
        return ObjectName.getInstance(objectName.getDomain(), keyProperties);
    }

    public static boolean isMBean(Class beanClass) {
        return beanClass != null && (DynamicMBean.class.isAssignableFrom(beanClass) || JmxUtils.getMBeanInterface(beanClass) != null || JmxUtils.getMXBeanInterface(beanClass) != null);
    }

    public static Class getMBeanInterface(Class clazz) {
        Class<?>[] implementedInterfaces;
        if (clazz.getSuperclass() == null) {
            return null;
        }
        String mbeanInterfaceName = clazz.getName() + MBEAN_SUFFIX;
        for (Class<?> iface : implementedInterfaces = clazz.getInterfaces()) {
            if (!iface.getName().equals(mbeanInterfaceName)) continue;
            return iface;
        }
        return JmxUtils.getMBeanInterface(clazz.getSuperclass());
    }

    public static Class getMXBeanInterface(Class clazz) {
        Class<?>[] implementedInterfaces;
        if (clazz.getSuperclass() == null) {
            return null;
        }
        for (Class<?> iface : implementedInterfaces = clazz.getInterfaces()) {
            Boolean checkResult;
            boolean isMxBean = iface.getName().endsWith(MXBEAN_SUFFIX);
            if (mxBeanAnnotationAvailable && (checkResult = MXBeanChecker.evaluateMXBeanAnnotation(iface)) != null) {
                isMxBean = checkResult;
            }
            if (!isMxBean) continue;
            return iface;
        }
        return JmxUtils.getMXBeanInterface(clazz.getSuperclass());
    }

    public static void populateDeprecation(Descriptor desc, AccessibleObject object) {
        if (object != null && object.isAnnotationPresent(Deprecated.class)) {
            desc.setField("deprecated", "");
        }
    }

    public static void populateDisplayName(Descriptor desc, String name) {
        desc.setField("displayName", name);
    }

    public static void populateEnable(Descriptor desc, boolean enabled) {
        desc.setField("enabled", "" + enabled);
    }

    public static void populateRole(Descriptor desc, Role role) {
        desc.setField("role", role.toString());
    }

    public static void populateVisibility(Descriptor desc, int level) {
        desc.setField("visibility", level);
    }

    public static void populateAccessors(Descriptor desc, BeanProperty property) {
        if (property.isReadable()) {
            desc.setField("getMethod", property.getReadMethod().getName());
        }
        if (property.isWritable()) {
            desc.setField("setMethod", property.getWriteMethod().getName());
        }
    }

    private static class MXBeanChecker {
        private MXBeanChecker() {
        }

        public static Boolean evaluateMXBeanAnnotation(Class<?> iface) {
            MXBean mxBean = iface.getAnnotation(MXBean.class);
            return mxBean != null ? Boolean.valueOf(mxBean.value()) : null;
        }
    }
}

