/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.jmx;

import com.ovea.tajin.framework.jmx.BeanProperty;
import com.ovea.tajin.framework.jmx.ReflectionUtils;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.WeakHashMap;

public final class BeanUtils {
    private static final Map<Class<?>, Reference<Collection<BeanProperty>>> cache = new WeakHashMap();

    private BeanUtils() {
    }

    public static Collection<BeanProperty> getProperties(Class<?> clazz) {
        Collection<BeanProperty> list;
        Reference<Collection<BeanProperty>> ref = cache.get(clazz);
        if (ref != null && (list = ref.get()) != null) {
            return list;
        }
        LinkedHashSet<BeanProperty> properties = new LinkedHashSet<BeanProperty>();
        for (Method method : ReflectionUtils.getDeclaredMethods(clazz)) {
            BeanProperty<?> prop = BeanProperty.findProperty(clazz, method);
            if (prop == null) continue;
            properties.add(prop);
        }
        cache.put(clazz, new WeakReference(properties));
        return properties;
    }
}

