/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExpiredCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.SimpleAccount;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleRole;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAccountRealm
extends AuthorizingRealm {
    protected final Map<String, SimpleAccount> users = new LinkedHashMap<String, SimpleAccount>();
    protected final Map<String, SimpleRole> roles = new LinkedHashMap<String, SimpleRole>();

    public SimpleAccountRealm() {
        this.setCachingEnabled(false);
    }

    public SimpleAccountRealm(String name) {
        this();
        this.setName(name);
    }

    protected SimpleAccount getUser(String username) {
        return this.users.get(username);
    }

    public boolean accountExists(String username) {
        return this.getUser(username) != null;
    }

    public void addAccount(String username, String password) {
        this.addAccount(username, password, null);
    }

    public void addAccount(String username, String password, String ... roles) {
        Set<String> roleNames = CollectionUtils.asSet(roles);
        SimpleAccount account = new SimpleAccount(username, (Object)password, this.getName(), roleNames, null);
        this.add(account);
    }

    protected String getUsername(SimpleAccount account) {
        return this.getUsername(account.getPrincipals());
    }

    protected String getUsername(PrincipalCollection principals) {
        return this.getAvailablePrincipal(principals).toString();
    }

    protected void add(SimpleAccount account) {
        String username = this.getUsername(account);
        this.users.put(username, account);
    }

    protected SimpleRole getRole(String rolename) {
        return this.roles.get(rolename);
    }

    public boolean roleExists(String name) {
        return this.getRole(name) != null;
    }

    public void addRole(String name) {
        this.add(new SimpleRole(name));
    }

    protected void add(SimpleRole role) {
        this.roles.put(role.getName(), role);
    }

    protected static Set<String> toSet(String delimited, String delimiter) {
        String[] rolenamesArray;
        if (delimited == null || delimited.trim().equals("")) {
            return null;
        }
        HashSet<String> values = new HashSet<String>();
        for (String s : rolenamesArray = delimited.split(delimiter)) {
            String trimmed = s.trim();
            if (trimmed.length() <= 0) continue;
            values.add(trimmed);
        }
        return values;
    }

    @Override
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UsernamePasswordToken upToken = (UsernamePasswordToken)token;
        SimpleAccount account = this.getUser(upToken.getUsername());
        if (account != null) {
            if (account.isLocked()) {
                throw new LockedAccountException("Account [" + account + "] is locked.");
            }
            if (account.isCredentialsExpired()) {
                String msg = "The credentials for account [" + account + "] are expired";
                throw new ExpiredCredentialsException(msg);
            }
        }
        return account;
    }

    @Override
    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        return this.users.get(this.getUsername(principals));
    }
}

