/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.template;

import com.ovea.tajin.framework.io.Resource;
import com.ovea.tajin.framework.template.ResolvedTemplate;
import com.ovea.tajin.framework.template.TemplateCompiler;
import com.ovea.tajin.framework.template.TemplateCompilerException;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;

public class GroovyTemplateCompiler
implements TemplateCompiler {
    private final String defaultCharset;

    public GroovyTemplateCompiler() {
        this("UTF-8");
    }

    public GroovyTemplateCompiler(String defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    @Override
    public ResolvedTemplate compile(Resource resource) throws TemplateCompilerException {
        Template tmpl;
        try {
            tmpl = new SimpleTemplateEngine(Thread.currentThread().getContextClassLoader()).createTemplate(resource.getText(this.defaultCharset));
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return new ResolvedTemplate(resource){

            @Override
            public String merge(Object context) {
                try {
                    StringWriter sw = new StringWriter();
                    tmpl.make((Map)context).writeTo(sw);
                    return sw.toString();
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        };
    }
}

