/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.support.guice;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.servlet.RequestParameters;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class HttpContext {
    private static final Logger LOGGER = Logger.getLogger(HttpContext.class.getName());
    private static final ThreadLocal<Deque<HttpContext>> CTX = new ThreadLocal<Deque<HttpContext>>(){

        @Override
        protected Deque<HttpContext> initialValue() {
            return new LinkedList<HttpContext>();
        }
    };
    static final Module MODULE = new Module(){

        @Override
        public void configure(Binder binder) {
        }

        @Provides
        HttpServletRequest provideHttpServletRequest() {
            return HttpContext.getContext().request;
        }

        @Provides
        HttpServletResponse provideHttpServletResponse() {
            return HttpContext.getContext().response;
        }

        @Provides
        HttpSession provideHttpSession() {
            return HttpContext.getContext().request.getSession();
        }

        @Provides
        @RequestParameters
        Map<String, String[]> provideRequestParameters() {
            return HttpContext.getContext().request.getParameterMap();
        }
    };
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    private HttpContext(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public static void start(HttpServletRequest request, HttpServletResponse response) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("[" + request.getRequestURI() + "] Changing HttpContext to request " + request.getClass().getName() + " and response " + response.getClass().getName());
        }
        HttpContext context = new HttpContext(request, response);
        CTX.get().offerFirst(context);
    }

    public static void end() {
        CTX.get().poll();
    }

    public static HttpContext getContext() {
        try {
            return CTX.get().getFirst();
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("No HttpContext bound to local thread ! Surround your code with HttpContext.enter() or HttpContextFilter !");
        }
    }
}

