/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.support.guice;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.util.Modules;
import com.ovea.tajin.framework.support.guice.HttpContext;
import com.ovea.tajin.framework.support.guice.Jsr250;
import com.ovea.tajin.framework.support.guice.Jsr250Injector;
import com.ovea.tajin.framework.support.guice.ServiceModules;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedList;
import javax.servlet.ServletContextEvent;

public class GuiceListener
extends GuiceServletContextListener {
    private final Collection<Module> modules = new LinkedList<Module>();

    public GuiceListener() {
    }

    public GuiceListener(Collection<? extends Module> modules) {
        this.modules.addAll(modules);
    }

    @Override
    protected Injector getInjector() {
        LinkedList<Module> modules = new LinkedList<Module>(this.modules);
        modules.add(ServiceModules.loadFromClasspath(Module.class));
        return Jsr250.createInjector(Stage.PRODUCTION, Modules.override(modules).with(HttpContext.MODULE));
    }

    @Override
    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        Jsr250Injector injector = (Jsr250Injector)servletContextEvent.getServletContext().getAttribute(Injector.class.getName());
        if (injector != null) {
            injector.destroy();
        }
        super.contextDestroyed(servletContextEvent);
        try {
            Class<?> queueHolderClass = Class.forName("com.google.inject.internal.util.$MapMaker$QueueHolder");
            Field queueField = queueHolderClass.getDeclaredField("queue");
            queueField.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(queueField, queueField.getModifiers() & 0xFFFFFFEF);
            queueField.set(null, null);
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            System.gc();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

