/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.tajin.framework.jmx;

import java.lang.reflect.Proxy;

public final class AopUtils {
    private AopUtils() {
    }

    public static Class<?> getTargetClass(Object candidate) {
        for (SupportedProxy supportedProxy : SupportedProxy.values()) {
            Class<?> c;
            if (!supportedProxy.isProxy(candidate) || (c = supportedProxy.getTargetType(candidate)) == null) continue;
            return c;
        }
        return candidate.getClass();
    }

    private static enum SupportedProxy {
        SPRING{

            @Override
            Class<?> getTargetType(Object proxy) {
                try {
                    for (Class<?> itf : proxy.getClass().getInterfaces()) {
                        if (!"org.springframework.aop.TargetClassAware".equals(itf.getName())) continue;
                        return (Class)proxy.getClass().getMethod("getTargetClass", new Class[0]).invoke(proxy, new Object[0]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }

            @Override
            boolean isProxyClass(Class<?> c) {
                for (Class<?> itf : c.getInterfaces()) {
                    if (!"org.springframework.aop.SpringProxy".equals(itf.getName()) && !"org.springframework.aop.TargetClassAware".equals(itf.getName())) continue;
                    return true;
                }
                return false;
            }
        }
        ,
        CGLIB{

            @Override
            Class<?> getTargetType(Object proxy) {
                return proxy.getClass().getSuperclass();
            }

            @Override
            boolean isProxyClass(Class<?> c) {
                if (c.getName().contains("$$")) {
                    return true;
                }
                for (Class<?> itf : c.getInterfaces()) {
                    if (!"net.sf.cglib.proxy.Factory".equals(itf.getName())) continue;
                    return true;
                }
                return false;
            }
        }
        ,
        JDK{

            @Override
            Class<?> getTargetType(Object proxy) {
                return null;
            }

            @Override
            boolean isProxyClass(Class<?> c) {
                return Proxy.isProxyClass(c);
            }
        };


        boolean isProxy(Object o) {
            return this.isProxyClass(o.getClass());
        }

        abstract boolean isProxyClass(Class<?> var1);

        abstract Class<?> getTargetType(Object var1);
    }
}

