/*
 * Decompiled with CFR 0.152.
 */
package com.outbrain.swinfra.config.provider;

import com.outbrain.swinfra.config.provider.ConfigurationProvider;
import java.util.Map;

public class SystemPropertyBasedConfigurationSelector
implements ConfigurationProvider {
    public static final String CONFIGURATION_SELECTION_PROPERTY_KEY = "com.outbrain.swinfra.config.provider.impl.class";
    private final ConfigurationProvider configProvider;

    public SystemPropertyBasedConfigurationSelector() {
        this(CONFIGURATION_SELECTION_PROPERTY_KEY);
    }

    public SystemPropertyBasedConfigurationSelector(String configSelectionPropertyKey) {
        if (null == configSelectionPropertyKey) {
            throw new IllegalArgumentException("configSelectionPropertyKey must not be null");
        }
        String configProviderFactoryClass = System.getProperty(configSelectionPropertyKey);
        if (configProviderFactoryClass == null) {
            throw new IllegalArgumentException("No ConfigurationProviderFactory implementation class was provided under the system property '" + configSelectionPropertyKey + "'");
        }
        try {
            this.configProvider = (ConfigurationProvider)Class.forName(configProviderFactoryClass).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Configuration factory class was not found in classpath - " + configProviderFactoryClass, e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Failed to instantiate configuration factory class - " + configProviderFactoryClass, e);
        }
    }

    @Override
    public Map<Object, Object> getConfiguration() {
        return this.configProvider.getConfiguration();
    }
}

