/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.logger;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;

final class Utils {
    private Utils() {
    }

    static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    static boolean equals(CharSequence a, CharSequence b) {
        int length;
        if (a == b) {
            return true;
        }
        if (a != null && b != null && (length = a.length()) == b.length()) {
            if (a instanceof String && b instanceof String) {
                return a.equals(b);
            }
            for (int i = 0; i < length; ++i) {
                if (a.charAt(i) == b.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    static String logLevel(int value) {
        switch (value) {
            case 2: {
                return "VERBOSE";
            }
            case 3: {
                return "DEBUG";
            }
            case 4: {
                return "INFO";
            }
            case 5: {
                return "WARN";
            }
            case 6: {
                return "ERROR";
            }
            case 7: {
                return "ASSERT";
            }
        }
        return "UNKNOWN";
    }
}

