/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.google.common.collect.ImmutableMap;
import com.orbitz.consul.BaseClient;
import com.orbitz.consul.async.ConsulResponseCallback;
import com.orbitz.consul.config.ClientConfig;
import com.orbitz.consul.model.ConsulResponse;
import com.orbitz.consul.model.State;
import com.orbitz.consul.model.health.HealthCheck;
import com.orbitz.consul.model.health.ServiceHealth;
import com.orbitz.consul.monitoring.ClientEventCallback;
import com.orbitz.consul.option.QueryOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.HeaderMap;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;

public class HealthClient
extends BaseClient {
    private static String CLIENT_NAME = "health";
    private final Api api;

    HealthClient(Retrofit retrofit, ClientConfig config, ClientEventCallback eventCallback) {
        super(CLIENT_NAME, config, eventCallback);
        this.api = (Api)retrofit.create(Api.class);
    }

    public ConsulResponse<List<HealthCheck>> getNodeChecks(String node) {
        return this.getNodeChecks(node, QueryOptions.BLANK);
    }

    public ConsulResponse<List<HealthCheck>> getNodeChecks(String node, QueryOptions queryOptions) {
        return this.http.extractConsulResponse(this.api.getNodeChecks(node, queryOptions.toQuery(), queryOptions.getTag(), queryOptions.getNodeMeta(), queryOptions.toHeaders()), new Integer[0]);
    }

    public ConsulResponse<List<HealthCheck>> getServiceChecks(String service) {
        return this.getServiceChecks(service, QueryOptions.BLANK);
    }

    public ConsulResponse<List<HealthCheck>> getServiceChecks(String service, QueryOptions queryOptions) {
        return this.http.extractConsulResponse(this.api.getServiceChecks(service, queryOptions.toQuery(), queryOptions.getTag(), queryOptions.getNodeMeta(), queryOptions.toHeaders()), new Integer[0]);
    }

    public void getServiceChecks(String service, QueryOptions queryOptions, ConsulResponseCallback<List<HealthCheck>> callback) {
        this.http.extractConsulResponse(this.api.getServiceChecks(service, queryOptions.toQuery(), queryOptions.getTag(), queryOptions.getNodeMeta(), queryOptions.toHeaders()), callback, new Integer[0]);
    }

    public ConsulResponse<List<HealthCheck>> getChecksByState(State state) {
        return this.getChecksByState(state, QueryOptions.BLANK);
    }

    public ConsulResponse<List<HealthCheck>> getChecksByState(State state, QueryOptions queryOptions) {
        return this.http.extractConsulResponse(this.api.getChecksByState(state.getName(), queryOptions.toQuery(), queryOptions.getTag(), queryOptions.getNodeMeta(), queryOptions.toHeaders()), new Integer[0]);
    }

    public void getChecksByState(State state, QueryOptions queryOptions, ConsulResponseCallback<List<HealthCheck>> callback) {
        this.http.extractConsulResponse(this.api.getChecksByState(state.getName(), queryOptions.toQuery(), queryOptions.getTag(), queryOptions.getNodeMeta(), queryOptions.toHeaders()), callback, new Integer[0]);
    }

    public ConsulResponse<List<ServiceHealth>> getHealthyServiceInstances(String service) {
        return this.getHealthyServiceInstances(service, QueryOptions.BLANK);
    }

    public ConsulResponse<List<ServiceHealth>> getHealthyServiceInstances(String service, QueryOptions queryOptions) {
        return this.http.extractConsulResponse(this.api.getServiceInstances(service, HealthClient.optionsFrom(new Map[]{ImmutableMap.of((Object)"passing", (Object)"true"), queryOptions.toQuery()}), queryOptions.getTag(), queryOptions.getNodeMeta(), queryOptions.toHeaders()), new Integer[0]);
    }

    public void getHealthyServiceInstances(String service, QueryOptions queryOptions, ConsulResponseCallback<List<ServiceHealth>> callback) {
        this.http.extractConsulResponse(this.api.getServiceInstances(service, HealthClient.optionsFrom(new Map[]{ImmutableMap.of((Object)"passing", (Object)"true"), queryOptions.toQuery()}), queryOptions.getTag(), queryOptions.getNodeMeta(), queryOptions.toHeaders()), callback, new Integer[0]);
    }

    public ConsulResponse<List<ServiceHealth>> getAllServiceInstances(String service) {
        return this.getAllServiceInstances(service, QueryOptions.BLANK);
    }

    public ConsulResponse<List<ServiceHealth>> getAllServiceInstances(String service, QueryOptions queryOptions) {
        return this.http.extractConsulResponse(this.api.getServiceInstances(service, queryOptions.toQuery(), queryOptions.getTag(), queryOptions.getNodeMeta(), queryOptions.toHeaders()), new Integer[0]);
    }

    public void getAllServiceInstances(String service, QueryOptions queryOptions, ConsulResponseCallback<List<ServiceHealth>> callback) {
        this.http.extractConsulResponse(this.api.getServiceInstances(service, queryOptions.toQuery(), queryOptions.getTag(), queryOptions.getNodeMeta(), queryOptions.toHeaders()), callback, new Integer[0]);
    }

    private static Map<String, Object> optionsFrom(Map<String, ?> ... options) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map<String, ?> option : options) {
            result.putAll(option);
        }
        return result;
    }

    static interface Api {
        @GET(value="health/node/{node}")
        public Call<List<HealthCheck>> getNodeChecks(@Path(value="node") String var1, @QueryMap Map<String, Object> var2, @Query(value="tag") List<String> var3, @Query(value="node-meta") List<String> var4, @HeaderMap Map<String, String> var5);

        @GET(value="health/checks/{service}")
        public Call<List<HealthCheck>> getServiceChecks(@Path(value="service") String var1, @QueryMap Map<String, Object> var2, @Query(value="tag") List<String> var3, @Query(value="node-meta") List<String> var4, @HeaderMap Map<String, String> var5);

        @GET(value="health/state/{state}")
        public Call<List<HealthCheck>> getChecksByState(@Path(value="state") String var1, @QueryMap Map<String, Object> var2, @Query(value="tag") List<String> var3, @Query(value="node-meta") List<String> var4, @HeaderMap Map<String, String> var5);

        @GET(value="health/service/{service}")
        public Call<List<ServiceHealth>> getServiceInstances(@Path(value="service") String var1, @QueryMap Map<String, Object> var2, @Query(value="tag") List<String> var3, @Query(value="node-meta") List<String> var4, @HeaderMap Map<String, String> var5);
    }
}

