/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.option.EventOptions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="EventOptions", generator="Immutables")
@Immutable
public final class ImmutableEventOptions
extends EventOptions {
    @Nullable
    private final String datacenter;
    @Nullable
    private final String nodeFilter;
    @Nullable
    private final String serviceFilter;
    @Nullable
    private final String tagFilter;

    private ImmutableEventOptions(@Nullable String datacenter, @Nullable String nodeFilter, @Nullable String serviceFilter, @Nullable String tagFilter) {
        this.datacenter = datacenter;
        this.nodeFilter = nodeFilter;
        this.serviceFilter = serviceFilter;
        this.tagFilter = tagFilter;
    }

    @Override
    public Optional<String> getDatacenter() {
        return Optional.ofNullable(this.datacenter);
    }

    @Override
    public Optional<String> getNodeFilter() {
        return Optional.ofNullable(this.nodeFilter);
    }

    @Override
    public Optional<String> getServiceFilter() {
        return Optional.ofNullable(this.serviceFilter);
    }

    @Override
    public Optional<String> getTagFilter() {
        return Optional.ofNullable(this.tagFilter);
    }

    public final ImmutableEventOptions withDatacenter(String value) {
        String newValue = Objects.requireNonNull(value, "datacenter");
        if (Objects.equals(this.datacenter, newValue)) {
            return this;
        }
        return new ImmutableEventOptions(newValue, this.nodeFilter, this.serviceFilter, this.tagFilter);
    }

    public final ImmutableEventOptions withDatacenter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.datacenter, value)) {
            return this;
        }
        return new ImmutableEventOptions(value, this.nodeFilter, this.serviceFilter, this.tagFilter);
    }

    public final ImmutableEventOptions withNodeFilter(String value) {
        String newValue = Objects.requireNonNull(value, "nodeFilter");
        if (Objects.equals(this.nodeFilter, newValue)) {
            return this;
        }
        return new ImmutableEventOptions(this.datacenter, newValue, this.serviceFilter, this.tagFilter);
    }

    public final ImmutableEventOptions withNodeFilter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.nodeFilter, value)) {
            return this;
        }
        return new ImmutableEventOptions(this.datacenter, value, this.serviceFilter, this.tagFilter);
    }

    public final ImmutableEventOptions withServiceFilter(String value) {
        String newValue = Objects.requireNonNull(value, "serviceFilter");
        if (Objects.equals(this.serviceFilter, newValue)) {
            return this;
        }
        return new ImmutableEventOptions(this.datacenter, this.nodeFilter, newValue, this.tagFilter);
    }

    public final ImmutableEventOptions withServiceFilter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.serviceFilter, value)) {
            return this;
        }
        return new ImmutableEventOptions(this.datacenter, this.nodeFilter, value, this.tagFilter);
    }

    public final ImmutableEventOptions withTagFilter(String value) {
        String newValue = Objects.requireNonNull(value, "tagFilter");
        if (Objects.equals(this.tagFilter, newValue)) {
            return this;
        }
        return new ImmutableEventOptions(this.datacenter, this.nodeFilter, this.serviceFilter, newValue);
    }

    public final ImmutableEventOptions withTagFilter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.tagFilter, value)) {
            return this;
        }
        return new ImmutableEventOptions(this.datacenter, this.nodeFilter, this.serviceFilter, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEventOptions && this.equalTo((ImmutableEventOptions)another);
    }

    private boolean equalTo(ImmutableEventOptions another) {
        return Objects.equals(this.datacenter, another.datacenter) && Objects.equals(this.nodeFilter, another.nodeFilter) && Objects.equals(this.serviceFilter, another.serviceFilter) && Objects.equals(this.tagFilter, another.tagFilter);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.datacenter);
        h += (h << 5) + Objects.hashCode(this.nodeFilter);
        h += (h << 5) + Objects.hashCode(this.serviceFilter);
        h += (h << 5) + Objects.hashCode(this.tagFilter);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"EventOptions").omitNullValues().add("datacenter", (Object)this.datacenter).add("nodeFilter", (Object)this.nodeFilter).add("serviceFilter", (Object)this.serviceFilter).add("tagFilter", (Object)this.tagFilter).toString();
    }

    public static ImmutableEventOptions copyOf(EventOptions instance) {
        if (instance instanceof ImmutableEventOptions) {
            return (ImmutableEventOptions)instance;
        }
        return ImmutableEventOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="EventOptions", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String datacenter;
        @Nullable
        private String nodeFilter;
        @Nullable
        private String serviceFilter;
        @Nullable
        private String tagFilter;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(EventOptions instance) {
            Optional<String> tagFilterOptional;
            Optional<String> serviceFilterOptional;
            Optional<String> nodeFilterOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> datacenterOptional = instance.getDatacenter();
            if (datacenterOptional.isPresent()) {
                this.datacenter(datacenterOptional);
            }
            if ((nodeFilterOptional = instance.getNodeFilter()).isPresent()) {
                this.nodeFilter(nodeFilterOptional);
            }
            if ((serviceFilterOptional = instance.getServiceFilter()).isPresent()) {
                this.serviceFilter(serviceFilterOptional);
            }
            if ((tagFilterOptional = instance.getTagFilter()).isPresent()) {
                this.tagFilter(tagFilterOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder datacenter(String datacenter) {
            this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder datacenter(Optional<String> datacenter) {
            this.datacenter = datacenter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nodeFilter(String nodeFilter) {
            this.nodeFilter = Objects.requireNonNull(nodeFilter, "nodeFilter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nodeFilter(Optional<String> nodeFilter) {
            this.nodeFilter = nodeFilter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder serviceFilter(String serviceFilter) {
            this.serviceFilter = Objects.requireNonNull(serviceFilter, "serviceFilter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder serviceFilter(Optional<String> serviceFilter) {
            this.serviceFilter = serviceFilter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tagFilter(String tagFilter) {
            this.tagFilter = Objects.requireNonNull(tagFilter, "tagFilter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tagFilter(Optional<String> tagFilter) {
            this.tagFilter = tagFilter.orElse(null);
            return this;
        }

        public ImmutableEventOptions build() {
            return new ImmutableEventOptions(this.datacenter, this.nodeFilter, this.serviceFilter, this.tagFilter);
        }
    }
}

