/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Booleans;
import com.orbitz.consul.option.DeleteOptions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableDeleteOptions
extends DeleteOptions {
    @Nullable
    private final Long cas;
    @Nullable
    private final Boolean recurse;
    @Nullable
    private final String datacenter;
    private final boolean isRecurse;

    private ImmutableDeleteOptions(@Nullable Long cas, @Nullable Boolean recurse, @Nullable String datacenter) {
        this.cas = cas;
        this.recurse = recurse;
        this.datacenter = datacenter;
        this.isRecurse = super.isRecurse();
    }

    @Override
    public Optional<Long> getCas() {
        return Optional.ofNullable(this.cas);
    }

    @Override
    public Optional<Boolean> getRecurse() {
        return Optional.ofNullable(this.recurse);
    }

    @Override
    public Optional<String> getDatacenter() {
        return Optional.ofNullable(this.datacenter);
    }

    @Override
    public boolean isRecurse() {
        return this.isRecurse;
    }

    public final ImmutableDeleteOptions withCas(long value) {
        Long newValue = value;
        if (Objects.equals(this.cas, newValue)) {
            return this;
        }
        return new ImmutableDeleteOptions(newValue, this.recurse, this.datacenter);
    }

    public final ImmutableDeleteOptions withCas(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.cas, value)) {
            return this;
        }
        return new ImmutableDeleteOptions(value, this.recurse, this.datacenter);
    }

    public final ImmutableDeleteOptions withRecurse(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.recurse, newValue)) {
            return this;
        }
        return new ImmutableDeleteOptions(this.cas, newValue, this.datacenter);
    }

    public final ImmutableDeleteOptions withRecurse(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.recurse, value)) {
            return this;
        }
        return new ImmutableDeleteOptions(this.cas, value, this.datacenter);
    }

    public final ImmutableDeleteOptions withDatacenter(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"datacenter");
        if (Objects.equals(this.datacenter, newValue)) {
            return this;
        }
        return new ImmutableDeleteOptions(this.cas, this.recurse, newValue);
    }

    public final ImmutableDeleteOptions withDatacenter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.datacenter, value)) {
            return this;
        }
        return new ImmutableDeleteOptions(this.cas, this.recurse, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeleteOptions && this.equalTo((ImmutableDeleteOptions)another);
    }

    private boolean equalTo(ImmutableDeleteOptions another) {
        return Objects.equals(this.cas, another.cas) && Objects.equals(this.recurse, another.recurse) && Objects.equals(this.datacenter, another.datacenter) && this.isRecurse == another.isRecurse;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.cas});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.recurse});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.datacenter});
        h = h * 17 + Booleans.hashCode((boolean)this.isRecurse);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DeleteOptions").omitNullValues().add("cas", (Object)this.cas).add("recurse", (Object)this.recurse).add("datacenter", (Object)this.datacenter).add("isRecurse", this.isRecurse).toString();
    }

    public static ImmutableDeleteOptions copyOf(DeleteOptions instance) {
        if (instance instanceof ImmutableDeleteOptions) {
            return (ImmutableDeleteOptions)instance;
        }
        return ImmutableDeleteOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Long cas;
        @Nullable
        private Boolean recurse;
        @Nullable
        private String datacenter;

        private Builder() {
        }

        public final Builder from(DeleteOptions instance) {
            Optional<String> datacenterOptional;
            Optional<Boolean> recurseOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<Long> casOptional = instance.getCas();
            if (casOptional.isPresent()) {
                this.cas(casOptional);
            }
            if ((recurseOptional = instance.getRecurse()).isPresent()) {
                this.recurse(recurseOptional);
            }
            if ((datacenterOptional = instance.getDatacenter()).isPresent()) {
                this.datacenter(datacenterOptional);
            }
            return this;
        }

        public final Builder cas(long cas) {
            this.cas = cas;
            return this;
        }

        public final Builder cas(Optional<Long> cas) {
            this.cas = cas.orElse(null);
            return this;
        }

        public final Builder recurse(boolean recurse) {
            this.recurse = recurse;
            return this;
        }

        public final Builder recurse(Optional<Boolean> recurse) {
            this.recurse = recurse.orElse(null);
            return this;
        }

        public final Builder datacenter(String datacenter) {
            this.datacenter = (String)Preconditions.checkNotNull((Object)datacenter, (Object)"datacenter");
            return this;
        }

        public final Builder datacenter(Optional<String> datacenter) {
            this.datacenter = datacenter.orElse(null);
            return this;
        }

        public ImmutableDeleteOptions build() {
            return new ImmutableDeleteOptions(this.cas, this.recurse, this.datacenter);
        }
    }
}

