/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.query.DnsQuery;
import com.orbitz.consul.model.query.PreparedQuery;
import com.orbitz.consul.model.query.ServiceQuery;
import com.orbitz.consul.model.query.Template;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutablePreparedQuery
extends PreparedQuery {
    @Nullable
    private final Template template;
    private final String name;
    @Nullable
    private final String session;
    @Nullable
    private final String token;
    private final ServiceQuery service;
    @Nullable
    private final DnsQuery dns;

    private ImmutablePreparedQuery(@Nullable Template template, String name, @Nullable String session, @Nullable String token, ServiceQuery service, @Nullable DnsQuery dns) {
        this.template = template;
        this.name = name;
        this.session = session;
        this.token = token;
        this.service = service;
        this.dns = dns;
    }

    @Override
    @JsonProperty(value="Template")
    public Optional<Template> getTemplate() {
        return Optional.ofNullable(this.template);
    }

    @Override
    @JsonProperty(value="Name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Session")
    public Optional<String> getSession() {
        return Optional.ofNullable(this.session);
    }

    @Override
    @JsonProperty(value="Token")
    public Optional<String> getToken() {
        return Optional.ofNullable(this.token);
    }

    @Override
    @JsonProperty(value="Service")
    public ServiceQuery getService() {
        return this.service;
    }

    @Override
    @JsonProperty(value="DNS")
    public Optional<DnsQuery> getDns() {
        return Optional.ofNullable(this.dns);
    }

    public final ImmutablePreparedQuery withTemplate(Template value) {
        Template newValue = (Template)Preconditions.checkNotNull((Object)value, (Object)"template");
        if (this.template == newValue) {
            return this;
        }
        return new ImmutablePreparedQuery(newValue, this.name, this.session, this.token, this.service, this.dns);
    }

    public final ImmutablePreparedQuery withTemplate(Optional<Template> optional) {
        Template value = optional.orElse(null);
        if (this.template == value) {
            return this;
        }
        return new ImmutablePreparedQuery(value, this.name, this.session, this.token, this.service, this.dns);
    }

    public final ImmutablePreparedQuery withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        return new ImmutablePreparedQuery(this.template, (String)Preconditions.checkNotNull((Object)value, (Object)"name"), this.session, this.token, this.service, this.dns);
    }

    public final ImmutablePreparedQuery withSession(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"session");
        if (Objects.equals(this.session, newValue)) {
            return this;
        }
        return new ImmutablePreparedQuery(this.template, this.name, newValue, this.token, this.service, this.dns);
    }

    public final ImmutablePreparedQuery withSession(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.session, value)) {
            return this;
        }
        return new ImmutablePreparedQuery(this.template, this.name, value, this.token, this.service, this.dns);
    }

    public final ImmutablePreparedQuery withToken(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"token");
        if (Objects.equals(this.token, newValue)) {
            return this;
        }
        return new ImmutablePreparedQuery(this.template, this.name, this.session, newValue, this.service, this.dns);
    }

    public final ImmutablePreparedQuery withToken(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.token, value)) {
            return this;
        }
        return new ImmutablePreparedQuery(this.template, this.name, this.session, value, this.service, this.dns);
    }

    public final ImmutablePreparedQuery withService(ServiceQuery value) {
        if (this.service == value) {
            return this;
        }
        return new ImmutablePreparedQuery(this.template, this.name, this.session, this.token, (ServiceQuery)Preconditions.checkNotNull((Object)value, (Object)"service"), this.dns);
    }

    public final ImmutablePreparedQuery withDns(DnsQuery value) {
        DnsQuery newValue = (DnsQuery)Preconditions.checkNotNull((Object)value, (Object)"dns");
        if (this.dns == newValue) {
            return this;
        }
        return new ImmutablePreparedQuery(this.template, this.name, this.session, this.token, this.service, newValue);
    }

    public final ImmutablePreparedQuery withDns(Optional<DnsQuery> optional) {
        DnsQuery value = optional.orElse(null);
        if (this.dns == value) {
            return this;
        }
        return new ImmutablePreparedQuery(this.template, this.name, this.session, this.token, this.service, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePreparedQuery && this.equalTo((ImmutablePreparedQuery)another);
    }

    private boolean equalTo(ImmutablePreparedQuery another) {
        return Objects.equals(this.template, another.template) && this.name.equals(another.name) && Objects.equals(this.session, another.session) && Objects.equals(this.token, another.token) && this.service.equals(another.service) && Objects.equals(this.dns, another.dns);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.template});
        h = h * 17 + this.name.hashCode();
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.session});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.token});
        h = h * 17 + this.service.hashCode();
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.dns});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PreparedQuery").omitNullValues().add("template", (Object)this.template).add("name", (Object)this.name).add("session", (Object)this.session).add("token", (Object)this.token).add("service", (Object)this.service).add("dns", (Object)this.dns).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutablePreparedQuery fromJson(Json json) {
        Builder builder = ImmutablePreparedQuery.builder();
        if (json.template != null) {
            builder.template(json.template);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.session != null) {
            builder.session(json.session);
        }
        if (json.token != null) {
            builder.token(json.token);
        }
        if (json.service != null) {
            builder.service(json.service);
        }
        if (json.dns != null) {
            builder.dns(json.dns);
        }
        return builder.build();
    }

    public static ImmutablePreparedQuery copyOf(PreparedQuery instance) {
        if (instance instanceof ImmutablePreparedQuery) {
            return (ImmutablePreparedQuery)instance;
        }
        return ImmutablePreparedQuery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_SERVICE = 2L;
        private long initBits = 3L;
        @Nullable
        private Template template;
        @Nullable
        private String name;
        @Nullable
        private String session;
        @Nullable
        private String token;
        @Nullable
        private ServiceQuery service;
        @Nullable
        private DnsQuery dns;

        private Builder() {
        }

        public final Builder from(PreparedQuery instance) {
            Optional<String> tokenOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<Template> templateOptional = instance.getTemplate();
            if (templateOptional.isPresent()) {
                this.template(templateOptional);
            }
            this.name(instance.getName());
            Optional<String> sessionOptional = instance.getSession();
            if (sessionOptional.isPresent()) {
                this.session(sessionOptional);
            }
            if ((tokenOptional = instance.getToken()).isPresent()) {
                this.token(tokenOptional);
            }
            this.service(instance.getService());
            Optional<DnsQuery> dnsOptional = instance.getDns();
            if (dnsOptional.isPresent()) {
                this.dns(dnsOptional);
            }
            return this;
        }

        public final Builder template(Template template) {
            this.template = (Template)Preconditions.checkNotNull((Object)template, (Object)"template");
            return this;
        }

        public final Builder template(Optional<Template> template) {
            this.template = template.orElse(null);
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder session(String session) {
            this.session = (String)Preconditions.checkNotNull((Object)session, (Object)"session");
            return this;
        }

        public final Builder session(Optional<String> session) {
            this.session = session.orElse(null);
            return this;
        }

        public final Builder token(String token) {
            this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"token");
            return this;
        }

        public final Builder token(Optional<String> token) {
            this.token = token.orElse(null);
            return this;
        }

        public final Builder service(ServiceQuery service) {
            this.service = (ServiceQuery)Preconditions.checkNotNull((Object)service, (Object)"service");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder dns(DnsQuery dns) {
            this.dns = (DnsQuery)Preconditions.checkNotNull((Object)dns, (Object)"dns");
            return this;
        }

        public final Builder dns(Optional<DnsQuery> dns) {
            this.dns = dns.orElse(null);
            return this;
        }

        public ImmutablePreparedQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePreparedQuery(this.template, this.name, this.session, this.token, this.service, this.dns);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("service");
            }
            return "Cannot build PreparedQuery, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends PreparedQuery {
        Optional<Template> template = Optional.empty();
        @Nullable
        String name;
        Optional<String> session = Optional.empty();
        Optional<String> token = Optional.empty();
        @Nullable
        ServiceQuery service;
        Optional<DnsQuery> dns = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Template")
        public void setTemplate(Optional<Template> template) {
            this.template = template;
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Session")
        public void setSession(Optional<String> session) {
            this.session = session;
        }

        @JsonProperty(value="Token")
        public void setToken(Optional<String> token) {
            this.token = token;
        }

        @JsonProperty(value="Service")
        public void setService(ServiceQuery service) {
            this.service = service;
        }

        @JsonProperty(value="DNS")
        public void setDns(Optional<DnsQuery> dns) {
            this.dns = dns;
        }

        @Override
        public Optional<Template> getTemplate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getSession() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ServiceQuery getService() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<DnsQuery> getDns() {
            throw new UnsupportedOperationException();
        }
    }
}

