/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.agent.Check;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableCheck
extends Check {
    private final String id;
    private final String name;
    @Nullable
    private final String notes;
    @Nullable
    private final String output;
    @Nullable
    private final String script;
    @Nullable
    private final String interval;
    @Nullable
    private final String ttl;
    @Nullable
    private final String http;
    @Nullable
    private final String tcp;
    @Nullable
    private final String grpc;
    @Nullable
    private final Boolean grpcUseTls;
    @Nullable
    private final String serviceId;
    private final ImmutableList<String> serviceTags;
    @Nullable
    private final String deregisterCriticalServiceAfter;

    private ImmutableCheck(String id, String name, @Nullable String notes, @Nullable String output, @Nullable String script, @Nullable String interval, @Nullable String ttl, @Nullable String http, @Nullable String tcp, @Nullable String grpc, @Nullable Boolean grpcUseTls, @Nullable String serviceId, ImmutableList<String> serviceTags, @Nullable String deregisterCriticalServiceAfter) {
        this.id = id;
        this.name = name;
        this.notes = notes;
        this.output = output;
        this.script = script;
        this.interval = interval;
        this.ttl = ttl;
        this.http = http;
        this.tcp = tcp;
        this.grpc = grpc;
        this.grpcUseTls = grpcUseTls;
        this.serviceId = serviceId;
        this.serviceTags = serviceTags;
        this.deregisterCriticalServiceAfter = deregisterCriticalServiceAfter;
    }

    @Override
    @JsonProperty(value="ID")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Notes")
    public Optional<String> getNotes() {
        return Optional.ofNullable(this.notes);
    }

    @Override
    @JsonProperty(value="Output")
    public Optional<String> getOutput() {
        return Optional.ofNullable(this.output);
    }

    @Override
    @JsonProperty(value="Script")
    public Optional<String> getScript() {
        return Optional.ofNullable(this.script);
    }

    @Override
    @JsonProperty(value="Interval")
    public Optional<String> getInterval() {
        return Optional.ofNullable(this.interval);
    }

    @Override
    @JsonProperty(value="TTL")
    public Optional<String> getTtl() {
        return Optional.ofNullable(this.ttl);
    }

    @Override
    @JsonProperty(value="HTTP")
    public Optional<String> getHttp() {
        return Optional.ofNullable(this.http);
    }

    @Override
    @JsonProperty(value="TCP")
    public Optional<String> getTcp() {
        return Optional.ofNullable(this.tcp);
    }

    @Override
    @JsonProperty(value="GRPC")
    public Optional<String> getGrpc() {
        return Optional.ofNullable(this.grpc);
    }

    @Override
    @JsonProperty(value="GRPCUseTLS")
    public Optional<Boolean> getGrpcUseTls() {
        return Optional.ofNullable(this.grpcUseTls);
    }

    @Override
    @JsonProperty(value="ServiceID")
    public Optional<String> getServiceId() {
        return Optional.ofNullable(this.serviceId);
    }

    @JsonProperty(value="ServiceTags")
    @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
    public ImmutableList<String> getServiceTags() {
        return this.serviceTags;
    }

    @Override
    @JsonProperty(value="DeregisterCriticalServiceAfter")
    public Optional<String> getDeregisterCriticalServiceAfter() {
        return Optional.ofNullable(this.deregisterCriticalServiceAfter);
    }

    public final ImmutableCheck withId(String value) {
        if (this.id.equals(value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck((String)Preconditions.checkNotNull((Object)value, (Object)"id"), this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, (String)Preconditions.checkNotNull((Object)value, (Object)"name"), this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withNotes(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"notes");
        if (Objects.equals(this.notes, newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, newValue, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withNotes(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.notes, value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, value, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withOutput(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"output");
        if (Objects.equals(this.output, newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, newValue, this.script, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withOutput(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.output, value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, value, this.script, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withScript(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"script");
        if (Objects.equals(this.script, newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, newValue, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withScript(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.script, value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, value, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withInterval(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"interval");
        if (Objects.equals(this.interval, newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, newValue, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withInterval(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.interval, value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, value, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withTtl(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"ttl");
        if (Objects.equals(this.ttl, newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, newValue, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withTtl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.ttl, value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, value, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withHttp(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"http");
        if (Objects.equals(this.http, newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, newValue, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withHttp(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.http, value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, value, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withTcp(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"tcp");
        if (Objects.equals(this.tcp, newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, newValue, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withTcp(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.tcp, value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, value, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withGrpc(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"grpc");
        if (Objects.equals(this.grpc, newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, newValue, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withGrpc(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.grpc, value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, value, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withGrpcUseTls(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.grpcUseTls, newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.grpc, newValue, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withGrpcUseTls(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.grpcUseTls, value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.grpc, value, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withServiceId(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"serviceId");
        if (Objects.equals(this.serviceId, newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, newValue, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withServiceId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.serviceId, value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, value, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withServiceTags(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, (ImmutableList<String>)newValue, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withServiceTags(Iterable<String> elements) {
        if (this.serviceTags == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, (ImmutableList<String>)newValue, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withDeregisterCriticalServiceAfter(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"deregisterCriticalServiceAfter");
        if (Objects.equals(this.deregisterCriticalServiceAfter, newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, newValue));
    }

    public final ImmutableCheck withDeregisterCriticalServiceAfter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.deregisterCriticalServiceAfter, value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheck && this.equalTo((ImmutableCheck)another);
    }

    private boolean equalTo(ImmutableCheck another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && Objects.equals(this.notes, another.notes) && Objects.equals(this.output, another.output) && Objects.equals(this.script, another.script) && Objects.equals(this.interval, another.interval) && Objects.equals(this.ttl, another.ttl) && Objects.equals(this.http, another.http) && Objects.equals(this.tcp, another.tcp) && Objects.equals(this.grpc, another.grpc) && Objects.equals(this.grpcUseTls, another.grpcUseTls) && Objects.equals(this.serviceId, another.serviceId) && this.serviceTags.equals(another.serviceTags) && Objects.equals(this.deregisterCriticalServiceAfter, another.deregisterCriticalServiceAfter);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.notes});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.output});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.script});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.interval});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.ttl});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.http});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.tcp});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.grpc});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.grpcUseTls});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.serviceId});
        h = h * 17 + this.serviceTags.hashCode();
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.deregisterCriticalServiceAfter});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Check").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("notes", (Object)this.notes).add("output", (Object)this.output).add("script", (Object)this.script).add("interval", (Object)this.interval).add("ttl", (Object)this.ttl).add("http", (Object)this.http).add("tcp", (Object)this.tcp).add("grpc", (Object)this.grpc).add("grpcUseTls", (Object)this.grpcUseTls).add("serviceId", (Object)this.serviceId).add("serviceTags", this.serviceTags).add("deregisterCriticalServiceAfter", (Object)this.deregisterCriticalServiceAfter).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableCheck fromJson(Json json) {
        Builder builder = ImmutableCheck.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.notes != null) {
            builder.notes(json.notes);
        }
        if (json.output != null) {
            builder.output(json.output);
        }
        if (json.script != null) {
            builder.script(json.script);
        }
        if (json.interval != null) {
            builder.interval(json.interval);
        }
        if (json.ttl != null) {
            builder.ttl(json.ttl);
        }
        if (json.http != null) {
            builder.http(json.http);
        }
        if (json.tcp != null) {
            builder.tcp(json.tcp);
        }
        if (json.grpc != null) {
            builder.grpc(json.grpc);
        }
        if (json.grpcUseTls != null) {
            builder.grpcUseTls(json.grpcUseTls);
        }
        if (json.serviceId != null) {
            builder.serviceId(json.serviceId);
        }
        if (json.serviceTags != null) {
            builder.addAllServiceTags(json.serviceTags);
        }
        if (json.deregisterCriticalServiceAfter != null) {
            builder.deregisterCriticalServiceAfter(json.deregisterCriticalServiceAfter);
        }
        return builder.build();
    }

    private static ImmutableCheck validate(ImmutableCheck instance) {
        instance.validate();
        return instance;
    }

    public static ImmutableCheck copyOf(Check instance) {
        if (instance instanceof ImmutableCheck) {
            return (ImmutableCheck)instance;
        }
        return ImmutableCheck.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private String notes;
        @Nullable
        private String output;
        @Nullable
        private String script;
        @Nullable
        private String interval;
        @Nullable
        private String ttl;
        @Nullable
        private String http;
        @Nullable
        private String tcp;
        @Nullable
        private String grpc;
        @Nullable
        private Boolean grpcUseTls;
        @Nullable
        private String serviceId;
        private ImmutableList.Builder<String> serviceTagsBuilder = ImmutableList.builder();
        @Nullable
        private String deregisterCriticalServiceAfter;

        private Builder() {
        }

        public final Builder from(Check instance) {
            Optional<String> serviceIdOptional;
            Optional<Boolean> grpcUseTlsOptional;
            Optional<String> grpcOptional;
            Optional<String> tcpOptional;
            Optional<String> httpOptional;
            Optional<String> ttlOptional;
            Optional<String> intervalOptional;
            Optional<String> scriptOptional;
            Optional<String> outputOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.id(instance.getId());
            this.name(instance.getName());
            Optional<String> notesOptional = instance.getNotes();
            if (notesOptional.isPresent()) {
                this.notes(notesOptional);
            }
            if ((outputOptional = instance.getOutput()).isPresent()) {
                this.output(outputOptional);
            }
            if ((scriptOptional = instance.getScript()).isPresent()) {
                this.script(scriptOptional);
            }
            if ((intervalOptional = instance.getInterval()).isPresent()) {
                this.interval(intervalOptional);
            }
            if ((ttlOptional = instance.getTtl()).isPresent()) {
                this.ttl(ttlOptional);
            }
            if ((httpOptional = instance.getHttp()).isPresent()) {
                this.http(httpOptional);
            }
            if ((tcpOptional = instance.getTcp()).isPresent()) {
                this.tcp(tcpOptional);
            }
            if ((grpcOptional = instance.getGrpc()).isPresent()) {
                this.grpc(grpcOptional);
            }
            if ((grpcUseTlsOptional = instance.getGrpcUseTls()).isPresent()) {
                this.grpcUseTls(grpcUseTlsOptional);
            }
            if ((serviceIdOptional = instance.getServiceId()).isPresent()) {
                this.serviceId(serviceIdOptional);
            }
            this.addAllServiceTags(instance.getServiceTags());
            Optional<String> deregisterCriticalServiceAfterOptional = instance.getDeregisterCriticalServiceAfter();
            if (deregisterCriticalServiceAfterOptional.isPresent()) {
                this.deregisterCriticalServiceAfter(deregisterCriticalServiceAfterOptional);
            }
            return this;
        }

        public final Builder id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder notes(String notes) {
            this.notes = (String)Preconditions.checkNotNull((Object)notes, (Object)"notes");
            return this;
        }

        public final Builder notes(Optional<String> notes) {
            this.notes = notes.orElse(null);
            return this;
        }

        public final Builder output(String output) {
            this.output = (String)Preconditions.checkNotNull((Object)output, (Object)"output");
            return this;
        }

        public final Builder output(Optional<String> output) {
            this.output = output.orElse(null);
            return this;
        }

        public final Builder script(String script) {
            this.script = (String)Preconditions.checkNotNull((Object)script, (Object)"script");
            return this;
        }

        public final Builder script(Optional<String> script) {
            this.script = script.orElse(null);
            return this;
        }

        public final Builder interval(String interval) {
            this.interval = (String)Preconditions.checkNotNull((Object)interval, (Object)"interval");
            return this;
        }

        public final Builder interval(Optional<String> interval) {
            this.interval = interval.orElse(null);
            return this;
        }

        public final Builder ttl(String ttl) {
            this.ttl = (String)Preconditions.checkNotNull((Object)ttl, (Object)"ttl");
            return this;
        }

        public final Builder ttl(Optional<String> ttl) {
            this.ttl = ttl.orElse(null);
            return this;
        }

        public final Builder http(String http) {
            this.http = (String)Preconditions.checkNotNull((Object)http, (Object)"http");
            return this;
        }

        public final Builder http(Optional<String> http) {
            this.http = http.orElse(null);
            return this;
        }

        public final Builder tcp(String tcp) {
            this.tcp = (String)Preconditions.checkNotNull((Object)tcp, (Object)"tcp");
            return this;
        }

        public final Builder tcp(Optional<String> tcp) {
            this.tcp = tcp.orElse(null);
            return this;
        }

        public final Builder grpc(String grpc) {
            this.grpc = (String)Preconditions.checkNotNull((Object)grpc, (Object)"grpc");
            return this;
        }

        public final Builder grpc(Optional<String> grpc) {
            this.grpc = grpc.orElse(null);
            return this;
        }

        public final Builder grpcUseTls(boolean grpcUseTls) {
            this.grpcUseTls = grpcUseTls;
            return this;
        }

        public final Builder grpcUseTls(Optional<Boolean> grpcUseTls) {
            this.grpcUseTls = grpcUseTls.orElse(null);
            return this;
        }

        public final Builder serviceId(String serviceId) {
            this.serviceId = (String)Preconditions.checkNotNull((Object)serviceId, (Object)"serviceId");
            return this;
        }

        public final Builder serviceId(Optional<String> serviceId) {
            this.serviceId = serviceId.orElse(null);
            return this;
        }

        public final Builder addServiceTags(String element) {
            this.serviceTagsBuilder.add((Object)element);
            return this;
        }

        public final Builder addServiceTags(String ... elements) {
            this.serviceTagsBuilder.add((Object[])elements);
            return this;
        }

        public final Builder serviceTags(Iterable<String> elements) {
            this.serviceTagsBuilder = ImmutableList.builder();
            return this.addAllServiceTags(elements);
        }

        public final Builder addAllServiceTags(Iterable<String> elements) {
            this.serviceTagsBuilder.addAll(elements);
            return this;
        }

        public final Builder deregisterCriticalServiceAfter(String deregisterCriticalServiceAfter) {
            this.deregisterCriticalServiceAfter = (String)Preconditions.checkNotNull((Object)deregisterCriticalServiceAfter, (Object)"deregisterCriticalServiceAfter");
            return this;
        }

        public final Builder deregisterCriticalServiceAfter(Optional<String> deregisterCriticalServiceAfter) {
            this.deregisterCriticalServiceAfter = deregisterCriticalServiceAfter.orElse(null);
            return this;
        }

        public ImmutableCheck build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.script, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTagsBuilder.build(), this.deregisterCriticalServiceAfter));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Check, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Check {
        @Nullable
        String id;
        @Nullable
        String name;
        Optional<String> notes = Optional.empty();
        Optional<String> output = Optional.empty();
        Optional<String> script = Optional.empty();
        Optional<String> interval = Optional.empty();
        Optional<String> ttl = Optional.empty();
        Optional<String> http = Optional.empty();
        Optional<String> tcp = Optional.empty();
        Optional<String> grpc = Optional.empty();
        Optional<Boolean> grpcUseTls = Optional.empty();
        Optional<String> serviceId = Optional.empty();
        List<String> serviceTags = ImmutableList.of();
        Optional<String> deregisterCriticalServiceAfter = Optional.empty();

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Notes")
        public void setNotes(Optional<String> notes) {
            this.notes = notes;
        }

        @JsonProperty(value="Output")
        public void setOutput(Optional<String> output) {
            this.output = output;
        }

        @JsonProperty(value="Script")
        public void setScript(Optional<String> script) {
            this.script = script;
        }

        @JsonProperty(value="Interval")
        public void setInterval(Optional<String> interval) {
            this.interval = interval;
        }

        @JsonProperty(value="TTL")
        public void setTtl(Optional<String> ttl) {
            this.ttl = ttl;
        }

        @JsonProperty(value="HTTP")
        public void setHttp(Optional<String> http) {
            this.http = http;
        }

        @JsonProperty(value="TCP")
        public void setTcp(Optional<String> tcp) {
            this.tcp = tcp;
        }

        @JsonProperty(value="GRPC")
        public void setGrpc(Optional<String> grpc) {
            this.grpc = grpc;
        }

        @JsonProperty(value="GRPCUseTLS")
        public void setGrpcUseTls(Optional<Boolean> grpcUseTls) {
            this.grpcUseTls = grpcUseTls;
        }

        @JsonProperty(value="ServiceID")
        public void setServiceId(Optional<String> serviceId) {
            this.serviceId = serviceId;
        }

        @JsonProperty(value="ServiceTags")
        @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
        public void setServiceTags(List<String> serviceTags) {
            this.serviceTags = serviceTags;
        }

        @JsonProperty(value="DeregisterCriticalServiceAfter")
        public void setDeregisterCriticalServiceAfter(Optional<String> deregisterCriticalServiceAfter) {
            this.deregisterCriticalServiceAfter = deregisterCriticalServiceAfter;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getNotes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getOutput() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getScript() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getInterval() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTtl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getHttp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTcp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getGrpc() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getGrpcUseTls() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getServiceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getServiceTags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDeregisterCriticalServiceAfter() {
            throw new UnsupportedOperationException();
        }
    }
}

