/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.session;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.orbitz.consul.model.session.SessionInfo;
import com.orbitz.consul.util.SecondsDeserializer;
import com.orbitz.consul.util.SecondsSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableSessionInfo
extends SessionInfo {
    private final long createIndex;
    private final Long lockDelay;
    @Nullable
    private final String name;
    private final String node;
    private final ImmutableList<String> checks;
    private final String behavior;
    @Nullable
    private final String ttl;
    private final String id;

    private ImmutableSessionInfo(long createIndex, Long lockDelay, @Nullable String name, String node, ImmutableList<String> checks, String behavior, @Nullable String ttl, String id) {
        this.createIndex = createIndex;
        this.lockDelay = lockDelay;
        this.name = name;
        this.node = node;
        this.checks = checks;
        this.behavior = behavior;
        this.ttl = ttl;
        this.id = id;
    }

    @Override
    @JsonProperty(value="CreateIndex")
    public long getCreateIndex() {
        return this.createIndex;
    }

    @Override
    @JsonProperty(value="LockDelay")
    @JsonSerialize(using=SecondsSerializer.class)
    @JsonDeserialize(using=SecondsDeserializer.class)
    public Long getLockDelay() {
        return this.lockDelay;
    }

    @Override
    @JsonProperty(value="Name")
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    @JsonProperty(value="Node")
    public String getNode() {
        return this.node;
    }

    @JsonProperty(value="Checks")
    public ImmutableList<String> getChecks() {
        return this.checks;
    }

    @Override
    @JsonProperty(value="Behavior")
    public String getBehavior() {
        return this.behavior;
    }

    @Override
    @JsonProperty(value="TTL")
    public Optional<String> getTtl() {
        return Optional.ofNullable(this.ttl);
    }

    @Override
    @JsonProperty(value="ID")
    public String getId() {
        return this.id;
    }

    public final ImmutableSessionInfo withCreateIndex(long value) {
        if (this.createIndex == value) {
            return this;
        }
        return new ImmutableSessionInfo(value, this.lockDelay, this.name, this.node, this.checks, this.behavior, this.ttl, this.id);
    }

    public final ImmutableSessionInfo withLockDelay(Long value) {
        if (this.lockDelay.equals(value)) {
            return this;
        }
        return new ImmutableSessionInfo(this.createIndex, (Long)Preconditions.checkNotNull((Object)value, (Object)"lockDelay"), this.name, this.node, this.checks, this.behavior, this.ttl, this.id);
    }

    public final ImmutableSessionInfo withName(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
        if (Objects.equals(this.name, newValue)) {
            return this;
        }
        return new ImmutableSessionInfo(this.createIndex, this.lockDelay, newValue, this.node, this.checks, this.behavior, this.ttl, this.id);
    }

    public final ImmutableSessionInfo withName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableSessionInfo(this.createIndex, this.lockDelay, value, this.node, this.checks, this.behavior, this.ttl, this.id);
    }

    public final ImmutableSessionInfo withNode(String value) {
        if (this.node.equals(value)) {
            return this;
        }
        return new ImmutableSessionInfo(this.createIndex, this.lockDelay, this.name, (String)Preconditions.checkNotNull((Object)value, (Object)"node"), this.checks, this.behavior, this.ttl, this.id);
    }

    public final ImmutableSessionInfo withChecks(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableSessionInfo(this.createIndex, this.lockDelay, this.name, this.node, (ImmutableList<String>)newValue, this.behavior, this.ttl, this.id);
    }

    public final ImmutableSessionInfo withChecks(Iterable<String> elements) {
        if (this.checks == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSessionInfo(this.createIndex, this.lockDelay, this.name, this.node, (ImmutableList<String>)newValue, this.behavior, this.ttl, this.id);
    }

    public final ImmutableSessionInfo withBehavior(String value) {
        if (this.behavior.equals(value)) {
            return this;
        }
        return new ImmutableSessionInfo(this.createIndex, this.lockDelay, this.name, this.node, this.checks, (String)Preconditions.checkNotNull((Object)value, (Object)"behavior"), this.ttl, this.id);
    }

    public final ImmutableSessionInfo withTtl(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"ttl");
        if (Objects.equals(this.ttl, newValue)) {
            return this;
        }
        return new ImmutableSessionInfo(this.createIndex, this.lockDelay, this.name, this.node, this.checks, this.behavior, newValue, this.id);
    }

    public final ImmutableSessionInfo withTtl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.ttl, value)) {
            return this;
        }
        return new ImmutableSessionInfo(this.createIndex, this.lockDelay, this.name, this.node, this.checks, this.behavior, value, this.id);
    }

    public final ImmutableSessionInfo withId(String value) {
        if (this.id.equals(value)) {
            return this;
        }
        return new ImmutableSessionInfo(this.createIndex, this.lockDelay, this.name, this.node, this.checks, this.behavior, this.ttl, (String)Preconditions.checkNotNull((Object)value, (Object)"id"));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSessionInfo && this.equalTo((ImmutableSessionInfo)another);
    }

    private boolean equalTo(ImmutableSessionInfo another) {
        return this.createIndex == another.createIndex && this.lockDelay.equals(another.lockDelay) && Objects.equals(this.name, another.name) && this.node.equals(another.node) && this.checks.equals(another.checks) && this.behavior.equals(another.behavior) && Objects.equals(this.ttl, another.ttl) && this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode((long)this.createIndex);
        h = h * 17 + this.lockDelay.hashCode();
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.name});
        h = h * 17 + this.node.hashCode();
        h = h * 17 + this.checks.hashCode();
        h = h * 17 + this.behavior.hashCode();
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.ttl});
        h = h * 17 + this.id.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SessionInfo").omitNullValues().add("createIndex", this.createIndex).add("lockDelay", (Object)this.lockDelay).add("name", (Object)this.name).add("node", (Object)this.node).add("checks", this.checks).add("behavior", (Object)this.behavior).add("ttl", (Object)this.ttl).add("id", (Object)this.id).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableSessionInfo fromJson(Json json) {
        Builder builder = ImmutableSessionInfo.builder();
        if (json.createIndex != null) {
            builder.createIndex(json.createIndex);
        }
        if (json.lockDelay != null) {
            builder.lockDelay(json.lockDelay);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.node != null) {
            builder.node(json.node);
        }
        if (json.checks != null) {
            builder.addAllChecks(json.checks);
        }
        if (json.behavior != null) {
            builder.behavior(json.behavior);
        }
        if (json.ttl != null) {
            builder.ttl(json.ttl);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        return builder.build();
    }

    public static ImmutableSessionInfo copyOf(SessionInfo instance) {
        if (instance instanceof ImmutableSessionInfo) {
            return (ImmutableSessionInfo)instance;
        }
        return ImmutableSessionInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CREATE_INDEX = 1L;
        private static final long INIT_BIT_LOCK_DELAY = 2L;
        private static final long INIT_BIT_NODE = 4L;
        private static final long INIT_BIT_BEHAVIOR = 8L;
        private static final long INIT_BIT_ID = 16L;
        private long initBits = 31L;
        private long createIndex;
        @Nullable
        private Long lockDelay;
        @Nullable
        private String name;
        @Nullable
        private String node;
        private ImmutableList.Builder<String> checksBuilder = ImmutableList.builder();
        @Nullable
        private String behavior;
        @Nullable
        private String ttl;
        @Nullable
        private String id;

        private Builder() {
        }

        public final Builder from(SessionInfo instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.createIndex(instance.getCreateIndex());
            this.lockDelay(instance.getLockDelay());
            Optional<String> nameOptional = instance.getName();
            if (nameOptional.isPresent()) {
                this.name(nameOptional);
            }
            this.node(instance.getNode());
            this.addAllChecks(instance.getChecks());
            this.behavior(instance.getBehavior());
            Optional<String> ttlOptional = instance.getTtl();
            if (ttlOptional.isPresent()) {
                this.ttl(ttlOptional);
            }
            this.id(instance.getId());
            return this;
        }

        public final Builder createIndex(long createIndex) {
            this.createIndex = createIndex;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder lockDelay(Long lockDelay) {
            this.lockDelay = (Long)Preconditions.checkNotNull((Object)lockDelay, (Object)"lockDelay");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            return this;
        }

        public final Builder name(Optional<String> name) {
            this.name = name.orElse(null);
            return this;
        }

        public final Builder node(String node) {
            this.node = (String)Preconditions.checkNotNull((Object)node, (Object)"node");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addChecks(String element) {
            this.checksBuilder.add((Object)element);
            return this;
        }

        public final Builder addChecks(String ... elements) {
            this.checksBuilder.add((Object[])elements);
            return this;
        }

        public final Builder checks(Iterable<String> elements) {
            this.checksBuilder = ImmutableList.builder();
            return this.addAllChecks(elements);
        }

        public final Builder addAllChecks(Iterable<String> elements) {
            this.checksBuilder.addAll(elements);
            return this;
        }

        public final Builder behavior(String behavior) {
            this.behavior = (String)Preconditions.checkNotNull((Object)behavior, (Object)"behavior");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder ttl(String ttl) {
            this.ttl = (String)Preconditions.checkNotNull((Object)ttl, (Object)"ttl");
            return this;
        }

        public final Builder ttl(Optional<String> ttl) {
            this.ttl = ttl.orElse(null);
            return this;
        }

        public final Builder id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableSessionInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSessionInfo(this.createIndex, this.lockDelay, this.name, this.node, this.checksBuilder.build(), this.behavior, this.ttl, this.id);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("createIndex");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("lockDelay");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("behavior");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build SessionInfo, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends SessionInfo {
        @Nullable
        Long createIndex;
        @Nullable
        Long lockDelay;
        Optional<String> name = Optional.empty();
        @Nullable
        String node;
        List<String> checks = ImmutableList.of();
        @Nullable
        String behavior;
        Optional<String> ttl = Optional.empty();
        @Nullable
        String id;

        Json() {
        }

        @JsonProperty(value="CreateIndex")
        public void setCreateIndex(long createIndex) {
            this.createIndex = createIndex;
        }

        @JsonProperty(value="LockDelay")
        @JsonSerialize(using=SecondsSerializer.class)
        @JsonDeserialize(using=SecondsDeserializer.class)
        public void setLockDelay(Long lockDelay) {
            this.lockDelay = lockDelay;
        }

        @JsonProperty(value="Name")
        public void setName(Optional<String> name) {
            this.name = name;
        }

        @JsonProperty(value="Node")
        public void setNode(String node) {
            this.node = node;
        }

        @JsonProperty(value="Checks")
        public void setChecks(List<String> checks) {
            this.checks = checks;
        }

        @JsonProperty(value="Behavior")
        public void setBehavior(String behavior) {
            this.behavior = behavior;
        }

        @JsonProperty(value="TTL")
        public void setTtl(Optional<String> ttl) {
            this.ttl = ttl;
        }

        @JsonProperty(value="ID")
        public void setId(String id) {
            this.id = id;
        }

        @Override
        public long getCreateIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getLockDelay() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getChecks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBehavior() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTtl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }
    }
}

