/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.orbitz.consul.model.query.Failover;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableFailover
extends Failover {
    @Nullable
    private final Integer nearestN;
    @Nullable
    private final String datacenters;

    private ImmutableFailover(@Nullable Integer nearestN, @Nullable String datacenters) {
        this.nearestN = nearestN;
        this.datacenters = datacenters;
    }

    @Override
    @JsonProperty(value="NearestN")
    public Optional<Integer> getNearestN() {
        return Optional.ofNullable(this.nearestN);
    }

    @Override
    @JsonProperty(value="Datacenters")
    public Optional<String> datacenters() {
        return Optional.ofNullable(this.datacenters);
    }

    public final ImmutableFailover withNearestN(int value) {
        Integer newValue = value;
        if (Objects.equals(this.nearestN, newValue)) {
            return this;
        }
        return new ImmutableFailover(newValue, this.datacenters);
    }

    public final ImmutableFailover withNearestN(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.nearestN, value)) {
            return this;
        }
        return new ImmutableFailover(value, this.datacenters);
    }

    public final ImmutableFailover withDatacenters(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"datacenters");
        if (Objects.equals(this.datacenters, newValue)) {
            return this;
        }
        return new ImmutableFailover(this.nearestN, newValue);
    }

    public final ImmutableFailover withDatacenters(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.datacenters, value)) {
            return this;
        }
        return new ImmutableFailover(this.nearestN, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFailover && this.equalTo((ImmutableFailover)another);
    }

    private boolean equalTo(ImmutableFailover another) {
        return Objects.equals(this.nearestN, another.nearestN) && Objects.equals(this.datacenters, another.datacenters);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.nearestN});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.datacenters});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Failover").omitNullValues().add("nearestN", (Object)this.nearestN).add("datacenters", (Object)this.datacenters).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableFailover fromJson(Json json) {
        Builder builder = ImmutableFailover.builder();
        if (json.nearestN != null) {
            builder.nearestN(json.nearestN);
        }
        if (json.datacenters != null) {
            builder.datacenters(json.datacenters);
        }
        return builder.build();
    }

    public static ImmutableFailover copyOf(Failover instance) {
        if (instance instanceof ImmutableFailover) {
            return (ImmutableFailover)instance;
        }
        return ImmutableFailover.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Integer nearestN;
        @Nullable
        private String datacenters;

        private Builder() {
        }

        public final Builder from(Failover instance) {
            Optional<String> datacentersOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<Integer> nearestNOptional = instance.getNearestN();
            if (nearestNOptional.isPresent()) {
                this.nearestN(nearestNOptional);
            }
            if ((datacentersOptional = instance.datacenters()).isPresent()) {
                this.datacenters(datacentersOptional);
            }
            return this;
        }

        public final Builder nearestN(int nearestN) {
            this.nearestN = nearestN;
            return this;
        }

        public final Builder nearestN(Optional<Integer> nearestN) {
            this.nearestN = nearestN.orElse(null);
            return this;
        }

        public final Builder datacenters(String datacenters) {
            this.datacenters = (String)Preconditions.checkNotNull((Object)datacenters, (Object)"datacenters");
            return this;
        }

        public final Builder datacenters(Optional<String> datacenters) {
            this.datacenters = datacenters.orElse(null);
            return this;
        }

        public ImmutableFailover build() {
            return new ImmutableFailover(this.nearestN, this.datacenters);
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Failover {
        Optional<Integer> nearestN = Optional.empty();
        Optional<String> datacenters = Optional.empty();

        Json() {
        }

        @JsonProperty(value="NearestN")
        public void setNearestN(Optional<Integer> nearestN) {
            this.nearestN = nearestN;
        }

        @JsonProperty(value="Datacenters")
        public void setDatacenters(Optional<String> datacenters) {
            this.datacenters = datacenters;
        }

        @Override
        public Optional<Integer> getNearestN() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> datacenters() {
            throw new UnsupportedOperationException();
        }
    }
}

