/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.orbitz.consul.model.acl.AclToken;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableAclToken
extends AclToken {
    @Nullable
    private final String id;
    @Nullable
    private final String name;
    @Nullable
    private final String type;
    @Nullable
    private final String rules;

    private ImmutableAclToken(@Nullable String id, @Nullable String name, @Nullable String type, @Nullable String rules) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.rules = rules;
    }

    @Override
    @JsonProperty(value="ID")
    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    @Override
    @JsonProperty(value="Name")
    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    @Override
    @JsonProperty(value="Type")
    public Optional<String> type() {
        return Optional.ofNullable(this.type);
    }

    @Override
    @JsonProperty(value="Rules")
    public Optional<String> rules() {
        return Optional.ofNullable(this.rules);
    }

    public final ImmutableAclToken withId(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"id");
        if (Objects.equals(this.id, newValue)) {
            return this;
        }
        return new ImmutableAclToken(newValue, this.name, this.type, this.rules);
    }

    public final ImmutableAclToken withId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableAclToken(value, this.name, this.type, this.rules);
    }

    public final ImmutableAclToken withName(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
        if (Objects.equals(this.name, newValue)) {
            return this;
        }
        return new ImmutableAclToken(this.id, newValue, this.type, this.rules);
    }

    public final ImmutableAclToken withName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableAclToken(this.id, value, this.type, this.rules);
    }

    public final ImmutableAclToken withType(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"type");
        if (Objects.equals(this.type, newValue)) {
            return this;
        }
        return new ImmutableAclToken(this.id, this.name, newValue, this.rules);
    }

    public final ImmutableAclToken withType(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return new ImmutableAclToken(this.id, this.name, value, this.rules);
    }

    public final ImmutableAclToken withRules(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"rules");
        if (Objects.equals(this.rules, newValue)) {
            return this;
        }
        return new ImmutableAclToken(this.id, this.name, this.type, newValue);
    }

    public final ImmutableAclToken withRules(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.rules, value)) {
            return this;
        }
        return new ImmutableAclToken(this.id, this.name, this.type, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAclToken && this.equalTo((ImmutableAclToken)another);
    }

    private boolean equalTo(ImmutableAclToken another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.name, another.name) && Objects.equals(this.type, another.type) && Objects.equals(this.rules, another.rules);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.id});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.name});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.type});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.rules});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AclToken").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("type", (Object)this.type).add("rules", (Object)this.rules).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableAclToken fromJson(Json json) {
        Builder builder = ImmutableAclToken.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.rules != null) {
            builder.rules(json.rules);
        }
        return builder.build();
    }

    public static ImmutableAclToken copyOf(AclToken instance) {
        if (instance instanceof ImmutableAclToken) {
            return (ImmutableAclToken)instance;
        }
        return ImmutableAclToken.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private String type;
        @Nullable
        private String rules;

        private Builder() {
        }

        public final Builder from(AclToken instance) {
            Optional<String> rulesOptional;
            Optional<String> typeOptional;
            Optional<String> nameOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<String> idOptional = instance.id();
            if (idOptional.isPresent()) {
                this.id(idOptional);
            }
            if ((nameOptional = instance.name()).isPresent()) {
                this.name(nameOptional);
            }
            if ((typeOptional = instance.type()).isPresent()) {
                this.type(typeOptional);
            }
            if ((rulesOptional = instance.rules()).isPresent()) {
                this.rules(rulesOptional);
            }
            return this;
        }

        public final Builder id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            return this;
        }

        public final Builder id(Optional<String> id) {
            this.id = id.orElse(null);
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            return this;
        }

        public final Builder name(Optional<String> name) {
            this.name = name.orElse(null);
            return this;
        }

        public final Builder type(String type) {
            this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
            return this;
        }

        public final Builder type(Optional<String> type) {
            this.type = type.orElse(null);
            return this;
        }

        public final Builder rules(String rules) {
            this.rules = (String)Preconditions.checkNotNull((Object)rules, (Object)"rules");
            return this;
        }

        public final Builder rules(Optional<String> rules) {
            this.rules = rules.orElse(null);
            return this;
        }

        public ImmutableAclToken build() {
            return new ImmutableAclToken(this.id, this.name, this.type, this.rules);
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends AclToken {
        Optional<String> id = Optional.empty();
        Optional<String> name = Optional.empty();
        Optional<String> type = Optional.empty();
        Optional<String> rules = Optional.empty();

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(Optional<String> id) {
            this.id = id;
        }

        @JsonProperty(value="Name")
        public void setName(Optional<String> name) {
            this.name = name;
        }

        @JsonProperty(value="Type")
        public void setType(Optional<String> type) {
            this.type = type;
        }

        @JsonProperty(value="Rules")
        public void setRules(Optional<String> rules) {
            this.rules = rules;
        }

        @Override
        public Optional<String> id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> rules() {
            throw new UnsupportedOperationException();
        }
    }
}

