/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.time.Duration;

public class CacheConfig {
    @VisibleForTesting
    static final Duration DEFAULT_WATCH_DURATION = Duration.ofSeconds(10L);
    @VisibleForTesting
    static final Duration DEFAULT_BACKOFF_DELAY = Duration.ofSeconds(10L);
    @VisibleForTesting
    static final Duration DEFAULT_MIN_DELAY_BETWEEN_REQUESTS = Duration.ZERO;
    @VisibleForTesting
    static final boolean DEFAULT_TIMEOUT_AUTO_ADJUSTMENT_ENABLED = true;
    @VisibleForTesting
    static final Duration DEFAULT_TIMEOUT_AUTO_ADJUSTMENT_MARGIN = Duration.ofSeconds(2L);
    @VisibleForTesting
    static final boolean DEFAULT_REFRESH_ERROR_LOGGED_AS_WARNING = false;
    private final Duration backOffDelay;
    private final Duration minDelayBetweenRequests;
    private final Duration timeoutAutoAdjustmentMargin;
    private final boolean timeoutAutoAdjustmentEnabled;
    private final boolean refreshErrorLoggedAsWarning;

    private CacheConfig(Duration backOffDelay, Duration minDelayBetweenRequests, boolean timeoutAutoAdjustmentEnabled, Duration timeoutAutoAdjustmentMargin, boolean refreshErrorLoggedAsWarning) {
        this.backOffDelay = backOffDelay;
        this.minDelayBetweenRequests = minDelayBetweenRequests;
        this.timeoutAutoAdjustmentEnabled = timeoutAutoAdjustmentEnabled;
        this.timeoutAutoAdjustmentMargin = timeoutAutoAdjustmentMargin;
        this.refreshErrorLoggedAsWarning = refreshErrorLoggedAsWarning;
    }

    public Duration getWatchDuration() {
        return DEFAULT_WATCH_DURATION;
    }

    public Duration getBackOffDelay() {
        return this.backOffDelay;
    }

    public boolean isTimeoutAutoAdjustmentEnabled() {
        return this.timeoutAutoAdjustmentEnabled;
    }

    public Duration getTimeoutAutoAdjustmentMargin() {
        return this.timeoutAutoAdjustmentMargin;
    }

    public Duration getMinimumDurationBetweenRequests() {
        return this.minDelayBetweenRequests;
    }

    public boolean isRefreshErrorLoggedAsWarning() {
        return this.refreshErrorLoggedAsWarning;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Duration backOffDelay = DEFAULT_BACKOFF_DELAY;
        private Duration minDelayBetweenRequests = DEFAULT_MIN_DELAY_BETWEEN_REQUESTS;
        private Duration timeoutAutoAdjustmentMargin = DEFAULT_TIMEOUT_AUTO_ADJUSTMENT_MARGIN;
        private boolean timeoutAutoAdjustmentEnabled = true;
        private boolean refreshErrorLoggedAsWarning = false;

        private Builder() {
        }

        public Builder withBackOffDelay(Duration delay) {
            this.backOffDelay = (Duration)Preconditions.checkNotNull((Object)delay, (Object)"Delay cannot be null");
            return this;
        }

        public Builder withMinDelayBetweenRequests(Duration delay) {
            this.minDelayBetweenRequests = (Duration)Preconditions.checkNotNull((Object)delay, (Object)"Delay cannot be null");
            return this;
        }

        public Builder withTimeoutAutoAdjustmentEnabled(boolean enabled) {
            this.timeoutAutoAdjustmentEnabled = enabled;
            return this;
        }

        public Builder withTimeoutAutoAdjustmentMargin(Duration margin) {
            this.timeoutAutoAdjustmentMargin = (Duration)Preconditions.checkNotNull((Object)margin, (Object)"Margin cannot be null");
            return this;
        }

        public Builder withRefreshErrorLoggedAsWarning() {
            this.refreshErrorLoggedAsWarning = true;
            return this;
        }

        public Builder withRefreshErrorLoggedAsError() {
            this.refreshErrorLoggedAsWarning = false;
            return this;
        }

        public CacheConfig build() {
            return new CacheConfig(this.backOffDelay, this.minDelayBetweenRequests, this.timeoutAutoAdjustmentEnabled, this.timeoutAutoAdjustmentMargin, this.refreshErrorLoggedAsWarning);
        }
    }
}

