/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.monitoring;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.orbitz.consul.monitoring.ClientEventCallback;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import okhttp3.Request;

public class ClientEventHandler {
    private static final ScheduledExecutorService EVENT_EXECUTOR = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("event-executor-%s").setDaemon(true).build());
    private final String clientName;
    private final ClientEventCallback callback;

    public ClientEventHandler(String clientName, ClientEventCallback callback) {
        this.clientName = clientName;
        this.callback = callback;
    }

    public void httpRequestSuccess(Request request) {
        EVENT_EXECUTOR.submit(() -> this.callback.onHttpRequestSuccess(this.clientName, request.method(), request.url().query()));
    }

    public void httpRequestInvalid(Request request, Throwable throwable) {
        EVENT_EXECUTOR.submit(() -> this.callback.onHttpRequestInvalid(this.clientName, request.method(), request.url().query(), throwable));
    }

    public void httpRequestFailure(Request request, Throwable throwable) {
        EVENT_EXECUTOR.submit(() -> this.callback.onHttpRequestFailure(this.clientName, request.method(), request.url().query(), throwable));
    }

    public void cacheStart() {
        EVENT_EXECUTOR.submit(() -> this.callback.onCacheStart(this.clientName));
    }

    public void cacheStop() {
        EVENT_EXECUTOR.submit(() -> this.callback.onCacheStop(this.clientName));
    }

    public void cachePollingError(Throwable throwable) {
        EVENT_EXECUTOR.submit(() -> this.callback.onCachePollingError(this.clientName, throwable));
    }

    public void cachePollingSuccess(boolean withNotification, Duration duration) {
        EVENT_EXECUTOR.submit(() -> this.callback.onCachePollingSuccess(this.clientName, withNotification, duration));
    }
}

