/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.query.Template;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableTemplate
extends Template {
    private final String type;
    @Nullable
    private final String regExp;

    private ImmutableTemplate(String type, @Nullable String regExp) {
        this.type = type;
        this.regExp = regExp;
    }

    @Override
    @JsonProperty(value="Type")
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="RegExp")
    public Optional<String> getRegExp() {
        return Optional.ofNullable(this.regExp);
    }

    public final ImmutableTemplate withType(String value) {
        if (this.type.equals(value)) {
            return this;
        }
        return new ImmutableTemplate((String)Preconditions.checkNotNull((Object)value, (Object)"type"), this.regExp);
    }

    public final ImmutableTemplate withRegExp(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"regExp");
        if (Objects.equals(this.regExp, newValue)) {
            return this;
        }
        return new ImmutableTemplate(this.type, newValue);
    }

    public final ImmutableTemplate withRegExp(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.regExp, value)) {
            return this;
        }
        return new ImmutableTemplate(this.type, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTemplate && this.equalTo((ImmutableTemplate)another);
    }

    private boolean equalTo(ImmutableTemplate another) {
        return this.type.equals(another.type) && Objects.equals(this.regExp, another.regExp);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.regExp});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Template").omitNullValues().add("type", (Object)this.type).add("regExp", (Object)this.regExp).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableTemplate fromJson(Json json) {
        Builder builder = ImmutableTemplate.builder();
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.regExp != null) {
            builder.regExp(json.regExp);
        }
        return builder.build();
    }

    public static ImmutableTemplate copyOf(Template instance) {
        if (instance instanceof ImmutableTemplate) {
            return (ImmutableTemplate)instance;
        }
        return ImmutableTemplate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private String type;
        @Nullable
        private String regExp;

        private Builder() {
        }

        public final Builder from(Template instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.type(instance.getType());
            Optional<String> regExpOptional = instance.getRegExp();
            if (regExpOptional.isPresent()) {
                this.regExp(regExpOptional);
            }
            return this;
        }

        public final Builder type(String type) {
            this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder regExp(String regExp) {
            this.regExp = (String)Preconditions.checkNotNull((Object)regExp, (Object)"regExp");
            return this;
        }

        public final Builder regExp(Optional<String> regExp) {
            this.regExp = regExp.orElse(null);
            return this;
        }

        public ImmutableTemplate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTemplate(this.type, this.regExp);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build Template, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Template {
        @Nullable
        String type;
        Optional<String> regExp = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Type")
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="RegExp")
        public void setRegExp(Optional<String> regExp) {
            this.regExp = regExp;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getRegExp() {
            throw new UnsupportedOperationException();
        }
    }
}

