/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.cache.ConsulCache;
import com.orbitz.consul.config.CacheConfig;
import com.orbitz.consul.model.kv.Value;
import com.orbitz.consul.option.QueryOptions;
import java.util.function.Function;

public class KVCache
extends ConsulCache<String, Value> {
    private KVCache(Function<Value, String> keyConversion, ConsulCache.CallbackConsumer<Value> callbackConsumer, CacheConfig cacheConfig) {
        super(keyConversion, callbackConsumer, cacheConfig);
    }

    @VisibleForTesting
    static Function<Value, String> getKeyExtractorFunction(String rootPath) {
        return input -> {
            Preconditions.checkNotNull((Object)input, (Object)"Input to key extractor is null");
            Preconditions.checkNotNull((Object)input.getKey(), (Object)"Input to key extractor has no key");
            if (rootPath.equals(input.getKey())) {
                return "";
            }
            int lastSlashIndex = rootPath.lastIndexOf("/");
            if (lastSlashIndex >= 0) {
                return input.getKey().substring(lastSlashIndex + 1);
            }
            return input.getKey();
        };
    }

    public static KVCache newCache(KeyValueClient kvClient, String rootPath, int watchSeconds, QueryOptions queryOptions) {
        String keyPath = KVCache.prepareRootPath(rootPath);
        Function<Value, String> keyExtractor = KVCache.getKeyExtractorFunction(keyPath);
        ConsulCache.CallbackConsumer<Value> callbackConsumer = (index, callback) -> {
            QueryOptions params = KVCache.watchParams(index, watchSeconds, queryOptions);
            kvClient.getValues(keyPath, params, callback);
        };
        return new KVCache(keyExtractor, callbackConsumer, kvClient.getConfig().getCacheConfig());
    }

    @VisibleForTesting
    static String prepareRootPath(String rootPath) {
        return rootPath.startsWith("/") ? rootPath.substring(1) : rootPath;
    }

    public static KVCache newCache(KeyValueClient kvClient, String rootPath, int watchSeconds) {
        return KVCache.newCache(kvClient, rootPath, watchSeconds, QueryOptions.BLANK);
    }

    public static KVCache newCache(KeyValueClient kvClient, String rootPath) {
        CacheConfig cacheConfig = kvClient.getConfig().getCacheConfig();
        int watchSeconds = Ints.checkedCast((long)cacheConfig.getWatchDuration().getSeconds());
        return KVCache.newCache(kvClient, rootPath, watchSeconds);
    }
}

