/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.google.common.collect.ImmutableMap;
import com.orbitz.consul.model.session.Session;
import com.orbitz.consul.model.session.SessionCreatedResponse;
import com.orbitz.consul.model.session.SessionInfo;
import com.orbitz.consul.util.Http;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public class SessionClient {
    private final Api api;

    SessionClient(Retrofit retrofit) {
        this.api = (Api)retrofit.create(Api.class);
    }

    public SessionCreatedResponse createSession(Session value) {
        return this.createSession(value, null);
    }

    public SessionCreatedResponse createSession(Session value, String dc) {
        return Http.extract(this.api.createSession(value, this.dcQuery(dc)), new Integer[0]);
    }

    private Map<String, String> dcQuery(String dc) {
        ImmutableMap query = Collections.emptyMap();
        if (dc != null) {
            query = ImmutableMap.of((Object)"dc", (Object)dc);
        }
        return query;
    }

    public Optional<SessionInfo> renewSession(String sessionId) {
        return this.renewSession(null, sessionId);
    }

    public Optional<SessionInfo> renewSession(String dc, String sessionId) {
        List<SessionInfo> sessionInfo = Http.extract(this.api.renewSession(sessionId, (Map<String, String>)ImmutableMap.of(), this.dcQuery(dc)), new Integer[0]);
        return sessionInfo != null && sessionInfo.isEmpty() ? Optional.empty() : Optional.of(sessionInfo.get(0));
    }

    public void destroySession(String sessionId) {
        this.destroySession(sessionId, null);
    }

    public void destroySession(String sessionId, String dc) {
        Http.handle(this.api.destroySession(sessionId, this.dcQuery(dc)), new Integer[0]);
    }

    public Optional<SessionInfo> getSessionInfo(String sessionId) {
        return this.getSessionInfo(sessionId, null);
    }

    public Optional<SessionInfo> getSessionInfo(String sessionId, String dc) {
        List<SessionInfo> sessionInfo = Http.extract(this.api.getSessionInfo(sessionId, this.dcQuery(dc)), new Integer[0]);
        return sessionInfo != null && sessionInfo.isEmpty() ? Optional.empty() : Optional.of(sessionInfo.get(0));
    }

    public List<SessionInfo> listSessions(String dc) {
        return Http.extract(this.api.listSessions(this.dcQuery(dc)), new Integer[0]);
    }

    public List<SessionInfo> listSessions() {
        return this.listSessions(null);
    }

    static interface Api {
        @PUT(value="session/create")
        public Call<SessionCreatedResponse> createSession(@Body Session var1, @QueryMap Map<String, String> var2);

        @PUT(value="session/renew/{sessionId}")
        public Call<List<SessionInfo>> renewSession(@Path(value="sessionId") String var1, @Body Map<String, String> var2, @QueryMap Map<String, String> var3);

        @PUT(value="session/destroy/{sessionId}")
        public Call<Void> destroySession(@Path(value="sessionId") String var1, @QueryMap Map<String, String> var2);

        @GET(value="session/info/{sessionId}")
        public Call<List<SessionInfo>> getSessionInfo(@Path(value="sessionId") String var1, @QueryMap Map<String, String> var2);

        @GET(value="session/list")
        public Call<List<SessionInfo>> listSessions(@QueryMap Map<String, String> var1);
    }
}

