package com.orbitz.consul.model.health;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link HealthCheck}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableHealthCheck.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "HealthCheck"})
public final class ImmutableHealthCheck extends HealthCheck {
  private final String node;
  private final String checkId;
  private final String name;
  private final String status;
  private final Optional<String> notes;
  private final Optional<String> output;
  private final Optional<String> serviceId;
  private final Optional<String> serviceName;

  private ImmutableHealthCheck(
      String node,
      String checkId,
      String name,
      String status,
      Optional<String> notes,
      Optional<String> output,
      Optional<String> serviceId,
      Optional<String> serviceName) {
    this.node = node;
    this.checkId = checkId;
    this.name = name;
    this.status = status;
    this.notes = notes;
    this.output = output;
    this.serviceId = serviceId;
    this.serviceName = serviceName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code node} attribute
   */
  @JsonProperty("Node")
  @Override
  public String getNode() {
    return node;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code checkId} attribute
   */
  @JsonProperty("CheckID")
  @Override
  public String getCheckId() {
    return checkId;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public String getName() {
    return name;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code status} attribute
   */
  @JsonProperty("Status")
  @Override
  public String getStatus() {
    return status;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code notes} attribute
   */
  @JsonProperty("Notes")
  @Override
  public Optional<String> getNotes() {
    return notes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code output} attribute
   */
  @JsonProperty("Output")
  @Override
  public Optional<String> getOutput() {
    return output;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code serviceId} attribute
   */
  @JsonProperty("ServiceID")
  @Override
  public Optional<String> getServiceId() {
    return serviceId;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code serviceName} attribute
   */
  @JsonProperty("ServiceName")
  @Override
  public Optional<String> getServiceName() {
    return serviceName;
  }
  
  /**
   * Copy current immutable object by setting value for {@link HealthCheck#getNode() node}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for node
   * @return modified copy of the {@code this} object
   */
  public final ImmutableHealthCheck withNode(String value) {
    if (this.node == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableHealthCheck(
        newValue,
        this.checkId,
        this.name,
        this.status,
        this.notes,
        this.output,
        this.serviceId,
        this.serviceName);
  }
  
  /**
   * Copy current immutable object by setting value for {@link HealthCheck#getCheckId() checkId}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for checkId
   * @return modified copy of the {@code this} object
   */
  public final ImmutableHealthCheck withCheckId(String value) {
    if (this.checkId == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableHealthCheck(
        this.node,
        newValue,
        this.name,
        this.status,
        this.notes,
        this.output,
        this.serviceId,
        this.serviceName);
  }
  
  /**
   * Copy current immutable object by setting value for {@link HealthCheck#getName() name}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for name
   * @return modified copy of the {@code this} object
   */
  public final ImmutableHealthCheck withName(String value) {
    if (this.name == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        newValue,
        this.status,
        this.notes,
        this.output,
        this.serviceId,
        this.serviceName);
  }
  
  /**
   * Copy current immutable object by setting value for {@link HealthCheck#getStatus() status}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for status
   * @return modified copy of the {@code this} object
   */
  public final ImmutableHealthCheck withStatus(String value) {
    if (this.status == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        newValue,
        this.notes,
        this.output,
        this.serviceId,
        this.serviceName);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link HealthCheck#getNotes() notes}.
   * @param value value for notes
   * @return modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withNotes(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        this.status,
        newValue,
        this.output,
        this.serviceId,
        this.serviceName);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link HealthCheck#getNotes() notes}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for notes
   * @return modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withNotes(Optional<String> optional) {
    if (this.notes == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        this.status,
        newValue,
        this.output,
        this.serviceId,
        this.serviceName);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link HealthCheck#getOutput() output}.
   * @param value value for output
   * @return modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withOutput(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        this.status,
        this.notes,
        newValue,
        this.serviceId,
        this.serviceName);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link HealthCheck#getOutput() output}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for output
   * @return modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withOutput(Optional<String> optional) {
    if (this.output == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        this.status,
        this.notes,
        newValue,
        this.serviceId,
        this.serviceName);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link HealthCheck#getServiceId() serviceId}.
   * @param value value for serviceId
   * @return modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withServiceId(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        this.status,
        this.notes,
        this.output,
        newValue,
        this.serviceName);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link HealthCheck#getServiceId() serviceId}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for serviceId
   * @return modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withServiceId(Optional<String> optional) {
    if (this.serviceId == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        this.status,
        this.notes,
        this.output,
        newValue,
        this.serviceName);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link HealthCheck#getServiceName() serviceName}.
   * @param value value for serviceName
   * @return modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withServiceName(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, this.output, this.serviceId, newValue);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link HealthCheck#getServiceName() serviceName}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for serviceName
   * @return modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withServiceName(Optional<String> optional) {
    if (this.serviceName == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, this.output, this.serviceId, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ImmutableHealthCheck} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    return this == another
        || (another instanceof ImmutableHealthCheck && equalTo((ImmutableHealthCheck) another));
  }
  
  private boolean equalTo(ImmutableHealthCheck another) {
    return node.equals(another.node)
        && checkId.equals(another.checkId)
        && name.equals(another.name)
        && status.equals(another.status)
        && notes.equals(another.notes)
        && output.equals(another.output)
        && serviceId.equals(another.serviceId)
        && serviceName.equals(another.serviceName);
  }
  
  /**
   * Computes hash code from attributes: {@code node}, {@code checkId}, {@code name}, {@code status}, {@code notes}, {@code output}, {@code serviceId}, {@code serviceName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + node.hashCode();
    h = h * 17 + checkId.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + status.hashCode();
    h = h * 17 + notes.hashCode();
    h = h * 17 + output.hashCode();
    h = h * 17 + serviceId.hashCode();
    h = h * 17 + serviceName.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code HealthCheck{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("HealthCheck")
        .add("node", node)
        .add("checkId", checkId)
        .add("name", name)
        .add("status", status)
        .add("notes", notes)
        .add("output", output)
        .add("serviceId", serviceId)
        .add("serviceName", serviceName)
        .toString();
  }
  
  @JsonCreator
  public static ImmutableHealthCheck fromAllAttributes(
      @JsonProperty("Node") String node,
      @JsonProperty("CheckID") String checkId,
      @JsonProperty("Name") String name,
      @JsonProperty("Status") String status,
      @JsonProperty("Notes") Optional<String> notes,
      @JsonProperty("Output") Optional<String> output,
      @JsonProperty("ServiceID") Optional<String> serviceId,
      @JsonProperty("ServiceName") Optional<String> serviceName) {
    ImmutableHealthCheck.Builder builder = ImmutableHealthCheck.builder();
    if (node != null) {
      builder.node(node);
    }
    if (checkId != null) {
      builder.checkId(checkId);
    }
    if (name != null) {
      builder.name(name);
    }
    if (status != null) {
      builder.status(status);
    }
    if (notes != null) {
      builder.notes(notes);
    }
    if (output != null) {
      builder.output(output);
    }
    if (serviceId != null) {
      builder.serviceId(serviceId);
    }
    if (serviceName != null) {
      builder.serviceName(serviceName);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link HealthCheck}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable HealthCheck instance
   */
  public static ImmutableHealthCheck copyOf(HealthCheck instance) {
    if (instance instanceof ImmutableHealthCheck) {
      return (ImmutableHealthCheck) instance;
    }
    return ImmutableHealthCheck.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link com.orbitz.consul.model.health.ImmutableHealthCheck}.
   * @return new ImmutableHealthCheck builder
   */
  public static ImmutableHealthCheck.Builder builder() {
    return new ImmutableHealthCheck.Builder();
  }
  
  /**
   * Builds instances of {@link com.orbitz.consul.model.health.ImmutableHealthCheck}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0xf;
    private static final long INITIALIZED_BIT_NODE = 0x1L;
    private static final long INITIALIZED_BIT_CHECK_ID = 0x2L;
    private static final long INITIALIZED_BIT_NAME = 0x4L;
    private static final long INITIALIZED_BIT_STATUS = 0x8L;
    private long initializedBitset;
  
    private String node;
    private String checkId;
    private String name;
    private String status;
    private Optional<String> notes = Optional.absent();
    private Optional<String> output = Optional.absent();
    private Optional<String> serviceId = Optional.absent();
    private Optional<String> serviceName = Optional.absent();
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link HealthCheck} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(HealthCheck instance) {
      Preconditions.checkNotNull(instance);
      node(instance.getNode());
      checkId(instance.getCheckId());
      name(instance.getName());
      status(instance.getStatus());
      Optional<String> notesOptional = instance.getNotes();
      if (notesOptional.isPresent()) {
        notes(notesOptional);
      }
      Optional<String> outputOptional = instance.getOutput();
      if (outputOptional.isPresent()) {
        output(outputOptional);
      }
      Optional<String> serviceIdOptional = instance.getServiceId();
      if (serviceIdOptional.isPresent()) {
        serviceId(serviceIdOptional);
      }
      Optional<String> serviceNameOptional = instance.getServiceName();
      if (serviceNameOptional.isPresent()) {
        serviceName(serviceNameOptional);
      }
      return this;
    }
  
    /**
     * Initializes value for {@link HealthCheck#getNode() node}.
     * @param node value for node
     * @return {@code this} builder for chained invocation
     */
    public final Builder node(String node) {
      this.node = Preconditions.checkNotNull(node);
      initializedBitset |= INITIALIZED_BIT_NODE;
      return this;
    }
  
    /**
     * Initializes value for {@link HealthCheck#getCheckId() checkId}.
     * @param checkId value for checkId
     * @return {@code this} builder for chained invocation
     */
    public final Builder checkId(String checkId) {
      this.checkId = Preconditions.checkNotNull(checkId);
      initializedBitset |= INITIALIZED_BIT_CHECK_ID;
      return this;
    }
  
    /**
     * Initializes value for {@link HealthCheck#getName() name}.
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name);
      initializedBitset |= INITIALIZED_BIT_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link HealthCheck#getStatus() status}.
     * @param status value for status
     * @return {@code this} builder for chained invocation
     */
    public final Builder status(String status) {
      this.status = Preconditions.checkNotNull(status);
      initializedBitset |= INITIALIZED_BIT_STATUS;
      return this;
    }
  
    /**
     * Initializes present value for optional {@link HealthCheck#getNotes() notes}.
     * @param notes value for notes
     * @return {@code this} builder for chained invocation
     */
    public final Builder notes(String notes) {
      this.notes = Optional.of(notes);
      return this;
    }
  
    /**
     * Initializes optional value for {@link HealthCheck#getNotes() notes}.
     * @param notes value for notes
     * @return {@code this} builder for chained invocation
     */
    public final Builder notes(Optional<String> notes) {
      this.notes = Preconditions.checkNotNull(notes);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link HealthCheck#getOutput() output}.
     * @param output value for output
     * @return {@code this} builder for chained invocation
     */
    public final Builder output(String output) {
      this.output = Optional.of(output);
      return this;
    }
  
    /**
     * Initializes optional value for {@link HealthCheck#getOutput() output}.
     * @param output value for output
     * @return {@code this} builder for chained invocation
     */
    public final Builder output(Optional<String> output) {
      this.output = Preconditions.checkNotNull(output);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link HealthCheck#getServiceId() serviceId}.
     * @param serviceId value for serviceId
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceId(String serviceId) {
      this.serviceId = Optional.of(serviceId);
      return this;
    }
  
    /**
     * Initializes optional value for {@link HealthCheck#getServiceId() serviceId}.
     * @param serviceId value for serviceId
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceId(Optional<String> serviceId) {
      this.serviceId = Preconditions.checkNotNull(serviceId);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link HealthCheck#getServiceName() serviceName}.
     * @param serviceName value for serviceName
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceName(String serviceName) {
      this.serviceName = Optional.of(serviceName);
      return this;
    }
  
    /**
     * Initializes optional value for {@link HealthCheck#getServiceName() serviceName}.
     * @param serviceName value for serviceName
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceName(Optional<String> serviceName) {
      this.serviceName = Preconditions.checkNotNull(serviceName);
      return this;
    }
  
    /**
     * Builds new {@link com.orbitz.consul.model.health.ImmutableHealthCheck}.
     * @return immutable instance of HealthCheck
     */
    public ImmutableHealthCheck build() {
      checkRequiredAttributes();
      return new ImmutableHealthCheck(node, checkId, name, status, notes, output, serviceId, serviceName);
    }
  
    private boolean nodeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NODE) != 0;
    }
  
    private boolean checkIdIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CHECK_ID) != 0;
    }
  
    private boolean nameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NAME) != 0;
    }
  
    private boolean statusIsSet() {
      return (initializedBitset & INITIALIZED_BIT_STATUS) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!nodeIsSet()) {
        attributes.add("node");
      }
      if (!checkIdIsSet()) {
        attributes.add("checkId");
      }
      if (!nameIsSet()) {
        attributes.add("name");
      }
      if (!statusIsSet()) {
        attributes.add("status");
      }
      return "Cannot build HealthCheck, some of required attributes are not set " + attributes;
    }
  }
}
