package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link Ports}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutablePorts.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "Ports"})
public final class ImmutablePorts extends Ports {
  private final int dns;
  private final int http;
  private final int rpc;
  private final int serfLan;
  private final int serfWan;
  private final int server;

  private ImmutablePorts(int dns, int http, int rpc, int serfLan, int serfWan, int server) {
    this.dns = dns;
    this.http = http;
    this.rpc = rpc;
    this.serfLan = serfLan;
    this.serfWan = serfWan;
    this.server = server;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code dns} attribute
   */
  @JsonProperty("DNS")
  @Override
  public int getDns() {
    return dns;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code http} attribute
   */
  @JsonProperty("HTTP")
  @Override
  public int getHttp() {
    return http;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code rpc} attribute
   */
  @JsonProperty("RPC")
  @Override
  public int getRpc() {
    return rpc;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code serfLan} attribute
   */
  @JsonProperty("SerfLan")
  @Override
  public int getSerfLan() {
    return serfLan;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code serfWan} attribute
   */
  @JsonProperty("SerfWan")
  @Override
  public int getSerfWan() {
    return serfWan;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code server} attribute
   */
  @JsonProperty("Server")
  @Override
  public int getServer() {
    return server;
  }
  
  /**
   * Copy current immutable object by setting value for {@link Ports#getDns() dns}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for dns
   * @return modified copy of the {@code this} object
   */
  public final ImmutablePorts withDns(int value) {
    if (this.dns == value) {
      return this;
    }
    int newValue = value;
    return new ImmutablePorts(newValue, this.http, this.rpc, this.serfLan, this.serfWan, this.server);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Ports#getHttp() http}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for http
   * @return modified copy of the {@code this} object
   */
  public final ImmutablePorts withHttp(int value) {
    if (this.http == value) {
      return this;
    }
    int newValue = value;
    return new ImmutablePorts(this.dns, newValue, this.rpc, this.serfLan, this.serfWan, this.server);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Ports#getRpc() rpc}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for rpc
   * @return modified copy of the {@code this} object
   */
  public final ImmutablePorts withRpc(int value) {
    if (this.rpc == value) {
      return this;
    }
    int newValue = value;
    return new ImmutablePorts(this.dns, this.http, newValue, this.serfLan, this.serfWan, this.server);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Ports#getSerfLan() serfLan}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for serfLan
   * @return modified copy of the {@code this} object
   */
  public final ImmutablePorts withSerfLan(int value) {
    if (this.serfLan == value) {
      return this;
    }
    int newValue = value;
    return new ImmutablePorts(this.dns, this.http, this.rpc, newValue, this.serfWan, this.server);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Ports#getSerfWan() serfWan}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for serfWan
   * @return modified copy of the {@code this} object
   */
  public final ImmutablePorts withSerfWan(int value) {
    if (this.serfWan == value) {
      return this;
    }
    int newValue = value;
    return new ImmutablePorts(this.dns, this.http, this.rpc, this.serfLan, newValue, this.server);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Ports#getServer() server}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for server
   * @return modified copy of the {@code this} object
   */
  public final ImmutablePorts withServer(int value) {
    if (this.server == value) {
      return this;
    }
    int newValue = value;
    return new ImmutablePorts(this.dns, this.http, this.rpc, this.serfLan, this.serfWan, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ImmutablePorts} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    return this == another
        || (another instanceof ImmutablePorts && equalTo((ImmutablePorts) another));
  }
  
  private boolean equalTo(ImmutablePorts another) {
    return dns == another.dns
        && http == another.http
        && rpc == another.rpc
        && serfLan == another.serfLan
        && serfWan == another.serfWan
        && server == another.server;
  }
  
  /**
   * Computes hash code from attributes: {@code dns}, {@code http}, {@code rpc}, {@code serfLan}, {@code serfWan}, {@code server}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + dns;
    h = h * 17 + http;
    h = h * 17 + rpc;
    h = h * 17 + serfLan;
    h = h * 17 + serfWan;
    h = h * 17 + server;
    return h;
  }
  
  /**
   * Prints immutable value {@code Ports{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Ports")
        .add("dns", dns)
        .add("http", http)
        .add("rpc", rpc)
        .add("serfLan", serfLan)
        .add("serfWan", serfWan)
        .add("server", server)
        .toString();
  }
  
  @JsonCreator
  public static ImmutablePorts fromAllAttributes(
      @JsonProperty("DNS") Integer dns,
      @JsonProperty("HTTP") Integer http,
      @JsonProperty("RPC") Integer rpc,
      @JsonProperty("SerfLan") Integer serfLan,
      @JsonProperty("SerfWan") Integer serfWan,
      @JsonProperty("Server") Integer server) {
    ImmutablePorts.Builder builder = ImmutablePorts.builder();
    if (dns != null) {
      builder.dns(dns);
    }
    if (http != null) {
      builder.http(http);
    }
    if (rpc != null) {
      builder.rpc(rpc);
    }
    if (serfLan != null) {
      builder.serfLan(serfLan);
    }
    if (serfWan != null) {
      builder.serfWan(serfWan);
    }
    if (server != null) {
      builder.server(server);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link Ports}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable Ports instance
   */
  public static ImmutablePorts copyOf(Ports instance) {
    if (instance instanceof ImmutablePorts) {
      return (ImmutablePorts) instance;
    }
    return ImmutablePorts.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link com.orbitz.consul.model.agent.ImmutablePorts}.
   * @return new ImmutablePorts builder
   */
  public static ImmutablePorts.Builder builder() {
    return new ImmutablePorts.Builder();
  }
  
  /**
   * Builds instances of {@link com.orbitz.consul.model.agent.ImmutablePorts}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3f;
    private static final long INITIALIZED_BIT_DNS = 0x1L;
    private static final long INITIALIZED_BIT_HTTP = 0x2L;
    private static final long INITIALIZED_BIT_RPC = 0x4L;
    private static final long INITIALIZED_BIT_SERF_LAN = 0x8L;
    private static final long INITIALIZED_BIT_SERF_WAN = 0x10L;
    private static final long INITIALIZED_BIT_SERVER = 0x20L;
    private long initializedBitset;
  
    private int dns;
    private int http;
    private int rpc;
    private int serfLan;
    private int serfWan;
    private int server;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link Ports} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(Ports instance) {
      Preconditions.checkNotNull(instance);
      dns(instance.getDns());
      http(instance.getHttp());
      rpc(instance.getRpc());
      serfLan(instance.getSerfLan());
      serfWan(instance.getSerfWan());
      server(instance.getServer());
      return this;
    }
  
    /**
     * Initializes value for {@link Ports#getDns() dns}.
     * @param dns value for dns
     * @return {@code this} builder for chained invocation
     */
    public final Builder dns(int dns) {
      this.dns = dns;
      initializedBitset |= INITIALIZED_BIT_DNS;
      return this;
    }
  
    /**
     * Initializes value for {@link Ports#getHttp() http}.
     * @param http value for http
     * @return {@code this} builder for chained invocation
     */
    public final Builder http(int http) {
      this.http = http;
      initializedBitset |= INITIALIZED_BIT_HTTP;
      return this;
    }
  
    /**
     * Initializes value for {@link Ports#getRpc() rpc}.
     * @param rpc value for rpc
     * @return {@code this} builder for chained invocation
     */
    public final Builder rpc(int rpc) {
      this.rpc = rpc;
      initializedBitset |= INITIALIZED_BIT_RPC;
      return this;
    }
  
    /**
     * Initializes value for {@link Ports#getSerfLan() serfLan}.
     * @param serfLan value for serfLan
     * @return {@code this} builder for chained invocation
     */
    public final Builder serfLan(int serfLan) {
      this.serfLan = serfLan;
      initializedBitset |= INITIALIZED_BIT_SERF_LAN;
      return this;
    }
  
    /**
     * Initializes value for {@link Ports#getSerfWan() serfWan}.
     * @param serfWan value for serfWan
     * @return {@code this} builder for chained invocation
     */
    public final Builder serfWan(int serfWan) {
      this.serfWan = serfWan;
      initializedBitset |= INITIALIZED_BIT_SERF_WAN;
      return this;
    }
  
    /**
     * Initializes value for {@link Ports#getServer() server}.
     * @param server value for server
     * @return {@code this} builder for chained invocation
     */
    public final Builder server(int server) {
      this.server = server;
      initializedBitset |= INITIALIZED_BIT_SERVER;
      return this;
    }
  
    /**
     * Builds new {@link com.orbitz.consul.model.agent.ImmutablePorts}.
     * @return immutable instance of Ports
     */
    public ImmutablePorts build() {
      checkRequiredAttributes();
      return new ImmutablePorts(dns, http, rpc, serfLan, serfWan, server);
    }
  
    private boolean dnsIsSet() {
      return (initializedBitset & INITIALIZED_BIT_DNS) != 0;
    }
  
    private boolean httpIsSet() {
      return (initializedBitset & INITIALIZED_BIT_HTTP) != 0;
    }
  
    private boolean rpcIsSet() {
      return (initializedBitset & INITIALIZED_BIT_RPC) != 0;
    }
  
    private boolean serfLanIsSet() {
      return (initializedBitset & INITIALIZED_BIT_SERF_LAN) != 0;
    }
  
    private boolean serfWanIsSet() {
      return (initializedBitset & INITIALIZED_BIT_SERF_WAN) != 0;
    }
  
    private boolean serverIsSet() {
      return (initializedBitset & INITIALIZED_BIT_SERVER) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!dnsIsSet()) {
        attributes.add("dns");
      }
      if (!httpIsSet()) {
        attributes.add("http");
      }
      if (!rpcIsSet()) {
        attributes.add("rpc");
      }
      if (!serfLanIsSet()) {
        attributes.add("serfLan");
      }
      if (!serfWanIsSet()) {
        attributes.add("serfWan");
      }
      if (!serverIsSet()) {
        attributes.add("server");
      }
      return "Cannot build Ports, some of required attributes are not set " + attributes;
    }
  }
}
