package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link Check}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableCheck.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "Check"})
public final class ImmutableCheck extends Check {
  private final String id;
  private final String name;
  private final Optional<String> notes;
  private final Optional<String> script;
  private final Optional<String> interval;
  private final Optional<String> ttl;
  private final Optional<String> http;
  private final Optional<String> serviceId;

  private ImmutableCheck(
      String id,
      String name,
      Optional<String> notes,
      Optional<String> script,
      Optional<String> interval,
      Optional<String> ttl,
      Optional<String> http,
      Optional<String> serviceId) {
    this.id = id;
    this.name = name;
    this.notes = notes;
    this.script = script;
    this.interval = interval;
    this.ttl = ttl;
    this.http = http;
    this.serviceId = serviceId;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code id} attribute
   */
  @JsonProperty("ID")
  @Override
  public String getId() {
    return id;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public String getName() {
    return name;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code notes} attribute
   */
  @JsonProperty("Notes")
  @Override
  public Optional<String> getNotes() {
    return notes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code script} attribute
   */
  @JsonProperty("Script")
  @Override
  public Optional<String> getScript() {
    return script;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code interval} attribute
   */
  @JsonProperty("Interval")
  @Override
  public Optional<String> getInterval() {
    return interval;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code ttl} attribute
   */
  @JsonProperty("TTL")
  @Override
  public Optional<String> getTtl() {
    return ttl;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code http} attribute
   */
  @JsonProperty("HTTP")
  @Override
  public Optional<String> getHttp() {
    return http;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code serviceId} attribute
   */
  @JsonProperty("ServiceID")
  @Override
  public Optional<String> getServiceId() {
    return serviceId;
  }
  
  /**
   * Copy current immutable object by setting value for {@link Check#getId() id}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for id
   * @return modified copy of the {@code this} object
   */
  public final ImmutableCheck withId(String value) {
    if (this.id == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return validate(new ImmutableCheck(newValue, this.name, this.notes, this.script, this.interval, this.ttl, this.http, this.serviceId));
  }
  
  /**
   * Copy current immutable object by setting value for {@link Check#getName() name}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for name
   * @return modified copy of the {@code this} object
   */
  public final ImmutableCheck withName(String value) {
    if (this.name == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return validate(new ImmutableCheck(this.id, newValue, this.notes, this.script, this.interval, this.ttl, this.http, this.serviceId));
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link Check#getNotes() notes}.
   * @param value value for notes
   * @return modified copy of {@code this} object
   */
  public final ImmutableCheck withNotes(String value) {
    Optional<String> newValue = Optional.of(value);
    return validate(new ImmutableCheck(this.id, this.name, newValue, this.script, this.interval, this.ttl, this.http, this.serviceId));
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link Check#getNotes() notes}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for notes
   * @return modified copy of {@code this} object
   */
  public final ImmutableCheck withNotes(Optional<String> optional) {
    if (this.notes == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return validate(new ImmutableCheck(this.id, this.name, newValue, this.script, this.interval, this.ttl, this.http, this.serviceId));
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link Check#getScript() script}.
   * @param value value for script
   * @return modified copy of {@code this} object
   */
  public final ImmutableCheck withScript(String value) {
    Optional<String> newValue = Optional.of(value);
    return validate(new ImmutableCheck(this.id, this.name, this.notes, newValue, this.interval, this.ttl, this.http, this.serviceId));
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link Check#getScript() script}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for script
   * @return modified copy of {@code this} object
   */
  public final ImmutableCheck withScript(Optional<String> optional) {
    if (this.script == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return validate(new ImmutableCheck(this.id, this.name, this.notes, newValue, this.interval, this.ttl, this.http, this.serviceId));
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link Check#getInterval() interval}.
   * @param value value for interval
   * @return modified copy of {@code this} object
   */
  public final ImmutableCheck withInterval(String value) {
    Optional<String> newValue = Optional.of(value);
    return validate(new ImmutableCheck(this.id, this.name, this.notes, this.script, newValue, this.ttl, this.http, this.serviceId));
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link Check#getInterval() interval}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for interval
   * @return modified copy of {@code this} object
   */
  public final ImmutableCheck withInterval(Optional<String> optional) {
    if (this.interval == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return validate(new ImmutableCheck(this.id, this.name, this.notes, this.script, newValue, this.ttl, this.http, this.serviceId));
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link Check#getTtl() ttl}.
   * @param value value for ttl
   * @return modified copy of {@code this} object
   */
  public final ImmutableCheck withTtl(String value) {
    Optional<String> newValue = Optional.of(value);
    return validate(new ImmutableCheck(this.id, this.name, this.notes, this.script, this.interval, newValue, this.http, this.serviceId));
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link Check#getTtl() ttl}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for ttl
   * @return modified copy of {@code this} object
   */
  public final ImmutableCheck withTtl(Optional<String> optional) {
    if (this.ttl == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return validate(new ImmutableCheck(this.id, this.name, this.notes, this.script, this.interval, newValue, this.http, this.serviceId));
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link Check#getHttp() http}.
   * @param value value for http
   * @return modified copy of {@code this} object
   */
  public final ImmutableCheck withHttp(String value) {
    Optional<String> newValue = Optional.of(value);
    return validate(new ImmutableCheck(this.id, this.name, this.notes, this.script, this.interval, this.ttl, newValue, this.serviceId));
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link Check#getHttp() http}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for http
   * @return modified copy of {@code this} object
   */
  public final ImmutableCheck withHttp(Optional<String> optional) {
    if (this.http == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return validate(new ImmutableCheck(this.id, this.name, this.notes, this.script, this.interval, this.ttl, newValue, this.serviceId));
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link Check#getServiceId() serviceId}.
   * @param value value for serviceId
   * @return modified copy of {@code this} object
   */
  public final ImmutableCheck withServiceId(String value) {
    Optional<String> newValue = Optional.of(value);
    return validate(new ImmutableCheck(this.id, this.name, this.notes, this.script, this.interval, this.ttl, this.http, newValue));
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link Check#getServiceId() serviceId}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for serviceId
   * @return modified copy of {@code this} object
   */
  public final ImmutableCheck withServiceId(Optional<String> optional) {
    if (this.serviceId == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return validate(new ImmutableCheck(this.id, this.name, this.notes, this.script, this.interval, this.ttl, this.http, newValue));
  }
  
  /**
   * This instance is equal to instances of {@code ImmutableCheck} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    return this == another
        || (another instanceof ImmutableCheck && equalTo((ImmutableCheck) another));
  }
  
  private boolean equalTo(ImmutableCheck another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && notes.equals(another.notes)
        && script.equals(another.script)
        && interval.equals(another.interval)
        && ttl.equals(another.ttl)
        && http.equals(another.http)
        && serviceId.equals(another.serviceId);
  }
  
  /**
   * Computes hash code from attributes: {@code id}, {@code name}, {@code notes}, {@code script}, {@code interval}, {@code ttl}, {@code http}, {@code serviceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + id.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + notes.hashCode();
    h = h * 17 + script.hashCode();
    h = h * 17 + interval.hashCode();
    h = h * 17 + ttl.hashCode();
    h = h * 17 + http.hashCode();
    h = h * 17 + serviceId.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code Check{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Check")
        .add("id", id)
        .add("name", name)
        .add("notes", notes)
        .add("script", script)
        .add("interval", interval)
        .add("ttl", ttl)
        .add("http", http)
        .add("serviceId", serviceId)
        .toString();
  }
  
  @JsonCreator
  public static ImmutableCheck fromAllAttributes(
      @JsonProperty("ID") String id,
      @JsonProperty("Name") String name,
      @JsonProperty("Notes") Optional<String> notes,
      @JsonProperty("Script") Optional<String> script,
      @JsonProperty("Interval") Optional<String> interval,
      @JsonProperty("TTL") Optional<String> ttl,
      @JsonProperty("HTTP") Optional<String> http,
      @JsonProperty("ServiceID") Optional<String> serviceId) {
    ImmutableCheck.Builder builder = ImmutableCheck.builder();
    if (id != null) {
      builder.id(id);
    }
    if (name != null) {
      builder.name(name);
    }
    if (notes != null) {
      builder.notes(notes);
    }
    if (script != null) {
      builder.script(script);
    }
    if (interval != null) {
      builder.interval(interval);
    }
    if (ttl != null) {
      builder.ttl(ttl);
    }
    if (http != null) {
      builder.http(http);
    }
    if (serviceId != null) {
      builder.serviceId(serviceId);
    }
    return builder.build();
  }

  private static ImmutableCheck validate(ImmutableCheck instance) {
    instance.validate();
    return instance;
  }
  
  /**
   * Creates immutable copy of {@link Check}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable Check instance
   */
  public static ImmutableCheck copyOf(Check instance) {
    if (instance instanceof ImmutableCheck) {
      return (ImmutableCheck) instance;
    }
    return ImmutableCheck.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link com.orbitz.consul.model.agent.ImmutableCheck}.
   * @return new ImmutableCheck builder
   */
  public static ImmutableCheck.Builder builder() {
    return new ImmutableCheck.Builder();
  }
  
  /**
   * Builds instances of {@link com.orbitz.consul.model.agent.ImmutableCheck}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_ID = 0x1L;
    private static final long INITIALIZED_BIT_NAME = 0x2L;
    private long initializedBitset;
  
    private String id;
    private String name;
    private Optional<String> notes = Optional.absent();
    private Optional<String> script = Optional.absent();
    private Optional<String> interval = Optional.absent();
    private Optional<String> ttl = Optional.absent();
    private Optional<String> http = Optional.absent();
    private Optional<String> serviceId = Optional.absent();
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link Check} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(Check instance) {
      Preconditions.checkNotNull(instance);
      id(instance.getId());
      name(instance.getName());
      Optional<String> notesOptional = instance.getNotes();
      if (notesOptional.isPresent()) {
        notes(notesOptional);
      }
      Optional<String> scriptOptional = instance.getScript();
      if (scriptOptional.isPresent()) {
        script(scriptOptional);
      }
      Optional<String> intervalOptional = instance.getInterval();
      if (intervalOptional.isPresent()) {
        interval(intervalOptional);
      }
      Optional<String> ttlOptional = instance.getTtl();
      if (ttlOptional.isPresent()) {
        ttl(ttlOptional);
      }
      Optional<String> httpOptional = instance.getHttp();
      if (httpOptional.isPresent()) {
        http(httpOptional);
      }
      Optional<String> serviceIdOptional = instance.getServiceId();
      if (serviceIdOptional.isPresent()) {
        serviceId(serviceIdOptional);
      }
      return this;
    }
  
    /**
     * Initializes value for {@link Check#getId() id}.
     * @param id value for id
     * @return {@code this} builder for chained invocation
     */
    public final Builder id(String id) {
      this.id = Preconditions.checkNotNull(id);
      initializedBitset |= INITIALIZED_BIT_ID;
      return this;
    }
  
    /**
     * Initializes value for {@link Check#getName() name}.
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name);
      initializedBitset |= INITIALIZED_BIT_NAME;
      return this;
    }
  
    /**
     * Initializes present value for optional {@link Check#getNotes() notes}.
     * @param notes value for notes
     * @return {@code this} builder for chained invocation
     */
    public final Builder notes(String notes) {
      this.notes = Optional.of(notes);
      return this;
    }
  
    /**
     * Initializes optional value for {@link Check#getNotes() notes}.
     * @param notes value for notes
     * @return {@code this} builder for chained invocation
     */
    public final Builder notes(Optional<String> notes) {
      this.notes = Preconditions.checkNotNull(notes);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link Check#getScript() script}.
     * @param script value for script
     * @return {@code this} builder for chained invocation
     */
    public final Builder script(String script) {
      this.script = Optional.of(script);
      return this;
    }
  
    /**
     * Initializes optional value for {@link Check#getScript() script}.
     * @param script value for script
     * @return {@code this} builder for chained invocation
     */
    public final Builder script(Optional<String> script) {
      this.script = Preconditions.checkNotNull(script);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link Check#getInterval() interval}.
     * @param interval value for interval
     * @return {@code this} builder for chained invocation
     */
    public final Builder interval(String interval) {
      this.interval = Optional.of(interval);
      return this;
    }
  
    /**
     * Initializes optional value for {@link Check#getInterval() interval}.
     * @param interval value for interval
     * @return {@code this} builder for chained invocation
     */
    public final Builder interval(Optional<String> interval) {
      this.interval = Preconditions.checkNotNull(interval);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link Check#getTtl() ttl}.
     * @param ttl value for ttl
     * @return {@code this} builder for chained invocation
     */
    public final Builder ttl(String ttl) {
      this.ttl = Optional.of(ttl);
      return this;
    }
  
    /**
     * Initializes optional value for {@link Check#getTtl() ttl}.
     * @param ttl value for ttl
     * @return {@code this} builder for chained invocation
     */
    public final Builder ttl(Optional<String> ttl) {
      this.ttl = Preconditions.checkNotNull(ttl);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link Check#getHttp() http}.
     * @param http value for http
     * @return {@code this} builder for chained invocation
     */
    public final Builder http(String http) {
      this.http = Optional.of(http);
      return this;
    }
  
    /**
     * Initializes optional value for {@link Check#getHttp() http}.
     * @param http value for http
     * @return {@code this} builder for chained invocation
     */
    public final Builder http(Optional<String> http) {
      this.http = Preconditions.checkNotNull(http);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link Check#getServiceId() serviceId}.
     * @param serviceId value for serviceId
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceId(String serviceId) {
      this.serviceId = Optional.of(serviceId);
      return this;
    }
  
    /**
     * Initializes optional value for {@link Check#getServiceId() serviceId}.
     * @param serviceId value for serviceId
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceId(Optional<String> serviceId) {
      this.serviceId = Preconditions.checkNotNull(serviceId);
      return this;
    }
  
    /**
     * Builds new {@link com.orbitz.consul.model.agent.ImmutableCheck}.
     * @return immutable instance of Check
     */
    public ImmutableCheck build() {
      checkRequiredAttributes();
      return ImmutableCheck.validate(new ImmutableCheck(id, name, notes, script, interval, ttl, http, serviceId));
    }
  
    private boolean idIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ID) != 0;
    }
  
    private boolean nameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NAME) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!idIsSet()) {
        attributes.add("id");
      }
      if (!nameIsSet()) {
        attributes.add("name");
      }
      return "Cannot build Check, some of required attributes are not set " + attributes;
    }
  }
}
