/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.google.common.base.Optional;
import com.orbitz.consul.model.session.SessionInfo;
import com.orbitz.consul.option.QueryOptions;
import com.orbitz.consul.util.ClientUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class SessionClient {
    private WebTarget webTarget;

    SessionClient(WebTarget webTarget) {
        this.webTarget = webTarget;
    }

    public String getLeader() {
        return ((String)this.webTarget.path("leader").request().get(String.class)).replace("\"", "").trim();
    }

    public Optional<String> createSession(String value) {
        return this.createSession(value, null);
    }

    public Optional<String> createSession(String value, String dc) {
        Map session = null;
        WebTarget target = this.webTarget;
        if (dc != null) {
            target = this.webTarget.queryParam("dc", new Object[]{dc});
        }
        return (session = (Map)target.path("create").request().put(Entity.entity((Object)value, (MediaType)MediaType.APPLICATION_JSON_TYPE), (GenericType)new GenericType<Map<String, String>>(){})) != null ? Optional.of(session.get("ID")) : Optional.absent();
    }

    public boolean renewSession(String sessionId) {
        return this.renewSession(null, sessionId);
    }

    public boolean renewSession(String dc, String sessionId) {
        WebTarget target = this.webTarget;
        if (dc != null) {
            target = this.webTarget.queryParam("dc", new Object[]{dc});
        }
        Response session = target.path("renew").path(sessionId).request().put(Entity.entity((Object)"{}", (MediaType)MediaType.APPLICATION_JSON_TYPE));
        return session.hasEntity();
    }

    public boolean destroySession(String sessionId) {
        return this.destroySession(sessionId, null);
    }

    public boolean destroySession(String sessionId, String dc) {
        WebTarget target = this.webTarget;
        if (dc != null) {
            target = this.webTarget.queryParam("dc", new Object[]{dc});
        }
        return (Boolean)target.path("destroy").path(sessionId).request().put(Entity.entity((Object)"", (MediaType)MediaType.TEXT_PLAIN_TYPE), Boolean.class);
    }

    public Optional<SessionInfo> getSessionInfo(String sessionId) {
        return this.getSessionInfo(sessionId, null);
    }

    public Optional<SessionInfo> getSessionInfo(String sessionId, String dc) {
        WebTarget target = this.webTarget;
        if (dc != null) {
            target = this.webTarget.queryParam("dc", new Object[]{dc});
        }
        target = ClientUtil.queryConfig(target.path("info").path(sessionId), QueryOptions.BLANK);
        List<Object> sessionInfo = Arrays.asList((Object[])target.request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(SessionInfo[].class));
        return sessionInfo != null && sessionInfo.size() != 0 ? Optional.of((Object)sessionInfo.get(0)) : Optional.absent();
    }
}

