/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.orbitz.consul.async.EventResponseCallback;
import com.orbitz.consul.model.EventResponse;
import com.orbitz.consul.model.event.Event;
import com.orbitz.consul.option.EventOptions;
import com.orbitz.consul.option.QueryOptions;
import com.orbitz.consul.util.ClientUtil;
import java.math.BigInteger;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public class EventClient {
    private WebTarget webTarget;

    EventClient(WebTarget webTarget) {
        this.webTarget = webTarget;
    }

    public Event fireEvent(String name, EventOptions eventOptions, String payload) {
        WebTarget target = this.webTarget.path("fire").path(name);
        target = ClientUtil.eventConfig(target, eventOptions);
        return (Event)target.request().put(Entity.entity((Object)(StringUtils.isEmpty((CharSequence)payload) ? "" : payload), (MediaType)MediaType.WILDCARD_TYPE), (GenericType)new GenericType<Event>(){});
    }

    public Event fireEvent(String name) {
        return this.fireEvent(name, EventOptions.BLANK, null);
    }

    public Event fireEvent(String name, EventOptions eventOptions) {
        return this.fireEvent(name, eventOptions, null);
    }

    public Event fireEvent(String name, String payload) {
        return this.fireEvent(name, EventOptions.BLANK, payload);
    }

    public EventResponse listEvents(String name, QueryOptions queryOptions) {
        WebTarget target = this.webTarget.path("list");
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            target.queryParam("name", new Object[]{name});
        }
        return EventClient.response(target, queryOptions);
    }

    public EventResponse listEvents(String name) {
        return this.listEvents(name, QueryOptions.BLANK);
    }

    public EventResponse listEvents(QueryOptions queryOptions) {
        return this.listEvents(null, queryOptions);
    }

    public EventResponse listEvents() {
        return this.listEvents(null, QueryOptions.BLANK);
    }

    public void listEvents(String name, QueryOptions queryOptions, EventResponseCallback callback) {
        WebTarget target = this.webTarget.path("list");
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            target.queryParam("name", new Object[]{name});
        }
        EventClient.response(target, queryOptions, callback);
    }

    public void listEvents(QueryOptions queryOptions, EventResponseCallback callback) {
        this.listEvents(null, queryOptions, callback);
    }

    public void listEvents(EventResponseCallback callback) {
        this.listEvents(null, QueryOptions.BLANK, callback);
    }

    private static void response(WebTarget target, QueryOptions queryOptions, final EventResponseCallback callback) {
        target = ClientUtil.queryConfig(target, queryOptions);
        target.request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).async().get((InvocationCallback)new InvocationCallback<Response>(){

            public void completed(Response response) {
                try {
                    callback.onComplete(EventClient.eventResponse(response));
                }
                catch (Exception ex) {
                    callback.onFailure(ex);
                }
            }

            public void failed(Throwable throwable) {
                callback.onFailure(throwable);
            }
        });
    }

    private static EventResponse response(WebTarget target, QueryOptions queryOptions) {
        target = ClientUtil.queryConfig(target, queryOptions);
        return EventClient.eventResponse(target.request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get());
    }

    private static EventResponse eventResponse(Response response) {
        ClientUtil.handleErrors(response);
        String indexHeaderValue = response.getHeaderString("X-Consul-Index");
        BigInteger index = new BigInteger(indexHeaderValue);
        EventResponse eventResponse = new EventResponse((List)response.readEntity((GenericType)new GenericType<List<Event>>(){}), index);
        response.close();
        return eventResponse;
    }
}

