package com.orbitz.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link CatalogService}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableCatalogService.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "CatalogService"})
public final class ImmutableCatalogService extends CatalogService {
  private final String node;
  private final String address;
  private final String serviceName;
  private final String serviceId;
  private final String serviceAddress;
  private final int servicePort;
  private final ImmutableList<String> serviceTags;

  private ImmutableCatalogService(
      String node,
      String address,
      String serviceName,
      String serviceId,
      String serviceAddress,
      int servicePort,
      ImmutableList<String> serviceTags) {
    this.node = node;
    this.address = address;
    this.serviceName = serviceName;
    this.serviceId = serviceId;
    this.serviceAddress = serviceAddress;
    this.servicePort = servicePort;
    this.serviceTags = serviceTags;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code node} attribute
   */
  @JsonProperty("Node")
  @Override
  public String getNode() {
    return node;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code address} attribute
   */
  @JsonProperty("Address")
  @Override
  public String getAddress() {
    return address;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code serviceName} attribute
   */
  @JsonProperty("ServiceName")
  @Override
  public String getServiceName() {
    return serviceName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code serviceId} attribute
   */
  @JsonProperty("ServiceID")
  @Override
  public String getServiceId() {
    return serviceId;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code serviceAddress} attribute
   */
  @JsonProperty("ServiceAddress")
  @Override
  public String getServiceAddress() {
    return serviceAddress;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code servicePort} attribute
   */
  @JsonProperty("ServicePort")
  @Override
  public int getServicePort() {
    return servicePort;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code serviceTags} attribute
   */
  @JsonProperty("ServiceTags")
  @Override
  public ImmutableList<String> getServiceTags() {
    return serviceTags;
  }
  
  /**
   * Copy current immutable object by setting value for {@link CatalogService#getNode() node}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for node
   * @return modified copy of the {@code this} object
   */
  public final ImmutableCatalogService withNode(String value) {
    if (this.node == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableCatalogService(
        newValue,
        this.address,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.servicePort,
        this.serviceTags);
  }
  
  /**
   * Copy current immutable object by setting value for {@link CatalogService#getAddress() address}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for address
   * @return modified copy of the {@code this} object
   */
  public final ImmutableCatalogService withAddress(String value) {
    if (this.address == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableCatalogService(
        this.node,
        newValue,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.servicePort,
        this.serviceTags);
  }
  
  /**
   * Copy current immutable object by setting value for {@link CatalogService#getServiceName() serviceName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for serviceName
   * @return modified copy of the {@code this} object
   */
  public final ImmutableCatalogService withServiceName(String value) {
    if (this.serviceName == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableCatalogService(
        this.node,
        this.address,
        newValue,
        this.serviceId,
        this.serviceAddress,
        this.servicePort,
        this.serviceTags);
  }
  
  /**
   * Copy current immutable object by setting value for {@link CatalogService#getServiceId() serviceId}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for serviceId
   * @return modified copy of the {@code this} object
   */
  public final ImmutableCatalogService withServiceId(String value) {
    if (this.serviceId == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.serviceName,
        newValue,
        this.serviceAddress,
        this.servicePort,
        this.serviceTags);
  }
  
  /**
   * Copy current immutable object by setting value for {@link CatalogService#getServiceAddress() serviceAddress}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for serviceAddress
   * @return modified copy of the {@code this} object
   */
  public final ImmutableCatalogService withServiceAddress(String value) {
    if (this.serviceAddress == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.serviceName,
        this.serviceId,
        newValue,
        this.servicePort,
        this.serviceTags);
  }
  
  /**
   * Copy current immutable object by setting value for {@link CatalogService#getServicePort() servicePort}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for servicePort
   * @return modified copy of the {@code this} object
   */
  public final ImmutableCatalogService withServicePort(int value) {
    if (this.servicePort == value) {
      return this;
    }
    int newValue = value;
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        newValue,
        this.serviceTags);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link CatalogService#getServiceTags() serviceTags}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final ImmutableCatalogService withServiceTags(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.servicePort,
        newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link CatalogService#getServiceTags() serviceTags}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of serviceTags elements to set
   * @return modified copy of {@code this} object
   */
  public final ImmutableCatalogService withServiceTags(Iterable<String> elements) {
    if (this.serviceTags == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.servicePort,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ImmutableCatalogService} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    return this == another
        || (another instanceof ImmutableCatalogService && equalTo((ImmutableCatalogService) another));
  }
  
  private boolean equalTo(ImmutableCatalogService another) {
    return node.equals(another.node)
        && address.equals(another.address)
        && serviceName.equals(another.serviceName)
        && serviceId.equals(another.serviceId)
        && serviceAddress.equals(another.serviceAddress)
        && servicePort == another.servicePort
        && serviceTags.equals(another.serviceTags);
  }
  
  /**
   * Computes hash code from attributes: {@code node}, {@code address}, {@code serviceName}, {@code serviceId}, {@code serviceAddress}, {@code servicePort}, {@code serviceTags}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + node.hashCode();
    h = h * 17 + address.hashCode();
    h = h * 17 + serviceName.hashCode();
    h = h * 17 + serviceId.hashCode();
    h = h * 17 + serviceAddress.hashCode();
    h = h * 17 + servicePort;
    h = h * 17 + serviceTags.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code CatalogService{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CatalogService")
        .add("node", node)
        .add("address", address)
        .add("serviceName", serviceName)
        .add("serviceId", serviceId)
        .add("serviceAddress", serviceAddress)
        .add("servicePort", servicePort)
        .add("serviceTags", serviceTags)
        .toString();
  }
  
  @JsonCreator
  public static ImmutableCatalogService fromAllAttributes(
      @JsonProperty("Node") String node,
      @JsonProperty("Address") String address,
      @JsonProperty("ServiceName") String serviceName,
      @JsonProperty("ServiceID") String serviceId,
      @JsonProperty("ServiceAddress") String serviceAddress,
      @JsonProperty("ServicePort") Integer servicePort,
      @JsonProperty("ServiceTags") List<String> serviceTags) {
    ImmutableCatalogService.Builder builder = ImmutableCatalogService.builder();
    if (node != null) {
      builder.node(node);
    }
    if (address != null) {
      builder.address(address);
    }
    if (serviceName != null) {
      builder.serviceName(serviceName);
    }
    if (serviceId != null) {
      builder.serviceId(serviceId);
    }
    if (serviceAddress != null) {
      builder.serviceAddress(serviceAddress);
    }
    if (servicePort != null) {
      builder.servicePort(servicePort);
    }
    if (serviceTags != null) {
      builder.addAllServiceTags(serviceTags);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link CatalogService}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable CatalogService instance
   */
  public static ImmutableCatalogService copyOf(CatalogService instance) {
    if (instance instanceof ImmutableCatalogService) {
      return (ImmutableCatalogService) instance;
    }
    return ImmutableCatalogService.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link com.orbitz.consul.model.catalog.ImmutableCatalogService}.
   * @return new ImmutableCatalogService builder
   */
  public static ImmutableCatalogService.Builder builder() {
    return new ImmutableCatalogService.Builder();
  }
  
  /**
   * Builds instances of {@link com.orbitz.consul.model.catalog.ImmutableCatalogService}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3f;
    private static final long INITIALIZED_BIT_NODE = 0x1L;
    private static final long INITIALIZED_BIT_ADDRESS = 0x2L;
    private static final long INITIALIZED_BIT_SERVICE_NAME = 0x4L;
    private static final long INITIALIZED_BIT_SERVICE_ID = 0x8L;
    private static final long INITIALIZED_BIT_SERVICE_ADDRESS = 0x10L;
    private static final long INITIALIZED_BIT_SERVICE_PORT = 0x20L;
    private long initializedBitset;
  
    private String node;
    private String address;
    private String serviceName;
    private String serviceId;
    private String serviceAddress;
    private int servicePort;
    private ImmutableList.Builder<String> serviceTagsBuilder = ImmutableList.builder();
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link CatalogService} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(CatalogService instance) {
      Preconditions.checkNotNull(instance);
      node(instance.getNode());
      address(instance.getAddress());
      serviceName(instance.getServiceName());
      serviceId(instance.getServiceId());
      serviceAddress(instance.getServiceAddress());
      servicePort(instance.getServicePort());
      addAllServiceTags(instance.getServiceTags());
      return this;
    }
  
    /**
     * Initializes value for {@link CatalogService#getNode() node}.
     * @param node value for node
     * @return {@code this} builder for chained invocation
     */
    public final Builder node(String node) {
      this.node = Preconditions.checkNotNull(node);
      initializedBitset |= INITIALIZED_BIT_NODE;
      return this;
    }
  
    /**
     * Initializes value for {@link CatalogService#getAddress() address}.
     * @param address value for address
     * @return {@code this} builder for chained invocation
     */
    public final Builder address(String address) {
      this.address = Preconditions.checkNotNull(address);
      initializedBitset |= INITIALIZED_BIT_ADDRESS;
      return this;
    }
  
    /**
     * Initializes value for {@link CatalogService#getServiceName() serviceName}.
     * @param serviceName value for serviceName
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceName(String serviceName) {
      this.serviceName = Preconditions.checkNotNull(serviceName);
      initializedBitset |= INITIALIZED_BIT_SERVICE_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link CatalogService#getServiceId() serviceId}.
     * @param serviceId value for serviceId
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceId(String serviceId) {
      this.serviceId = Preconditions.checkNotNull(serviceId);
      initializedBitset |= INITIALIZED_BIT_SERVICE_ID;
      return this;
    }
  
    /**
     * Initializes value for {@link CatalogService#getServiceAddress() serviceAddress}.
     * @param serviceAddress value for serviceAddress
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceAddress(String serviceAddress) {
      this.serviceAddress = Preconditions.checkNotNull(serviceAddress);
      initializedBitset |= INITIALIZED_BIT_SERVICE_ADDRESS;
      return this;
    }
  
    /**
     * Initializes value for {@link CatalogService#getServicePort() servicePort}.
     * @param servicePort value for servicePort
     * @return {@code this} builder for chained invocation
     */
    public final Builder servicePort(int servicePort) {
      this.servicePort = servicePort;
      initializedBitset |= INITIALIZED_BIT_SERVICE_PORT;
      return this;
    }
  
    /**
     * Adds one element to {@link CatalogService#getServiceTags() serviceTags} list.
     * @param element serviceTags element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addServiceTags(String element) {
      serviceTagsBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link CatalogService#getServiceTags() serviceTags} list.
     * @param elements array of serviceTags elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addServiceTags(String... elements) {
      serviceTagsBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link CatalogService#getServiceTags() serviceTags} list.
     * @param elements iterable of serviceTags elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceTags(Iterable<String> elements) {
      serviceTagsBuilder = ImmutableList.builder();
      return addAllServiceTags(elements);
    }
  
    /**
     * Adds elements to {@link CatalogService#getServiceTags() serviceTags} list.
     * @param elements iterable of serviceTags elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllServiceTags(Iterable<String> elements) {
      serviceTagsBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link com.orbitz.consul.model.catalog.ImmutableCatalogService}.
     * @return immutable instance of CatalogService
     */
    public ImmutableCatalogService build() {
      checkRequiredAttributes();
      return new ImmutableCatalogService(node, address, serviceName, serviceId, serviceAddress, servicePort, serviceTagsBuilder.build());
    }
  
    private boolean nodeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NODE) != 0;
    }
  
    private boolean addressIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ADDRESS) != 0;
    }
  
    private boolean serviceNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_SERVICE_NAME) != 0;
    }
  
    private boolean serviceIdIsSet() {
      return (initializedBitset & INITIALIZED_BIT_SERVICE_ID) != 0;
    }
  
    private boolean serviceAddressIsSet() {
      return (initializedBitset & INITIALIZED_BIT_SERVICE_ADDRESS) != 0;
    }
  
    private boolean servicePortIsSet() {
      return (initializedBitset & INITIALIZED_BIT_SERVICE_PORT) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!nodeIsSet()) {
        attributes.add("node");
      }
      if (!addressIsSet()) {
        attributes.add("address");
      }
      if (!serviceNameIsSet()) {
        attributes.add("serviceName");
      }
      if (!serviceIdIsSet()) {
        attributes.add("serviceId");
      }
      if (!serviceAddressIsSet()) {
        attributes.add("serviceAddress");
      }
      if (!servicePortIsSet()) {
        attributes.add("servicePort");
      }
      return "Cannot build CatalogService, some of required attributes are not set " + attributes;
    }
  }
}
