package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link Member}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableMember.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "Member"})
public final class ImmutableMember extends Member {
  private final String name;
  private final String address;
  private final int port;
  private final ImmutableMap<String, String> tags;
  private final int status;
  private final int protocolMin;
  private final int protocolMax;
  private final int protocolCur;
  private final int delegateMin;
  private final int delegateMax;
  private final int delegateCur;

  private ImmutableMember(
      String name,
      String address,
      int port,
      ImmutableMap<String, String> tags,
      int status,
      int protocolMin,
      int protocolMax,
      int protocolCur,
      int delegateMin,
      int delegateMax,
      int delegateCur) {
    this.name = name;
    this.address = address;
    this.port = port;
    this.tags = tags;
    this.status = status;
    this.protocolMin = protocolMin;
    this.protocolMax = protocolMax;
    this.protocolCur = protocolCur;
    this.delegateMin = delegateMin;
    this.delegateMax = delegateMax;
    this.delegateCur = delegateCur;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public String getName() {
    return name;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code address} attribute
   */
  @JsonProperty("Addr")
  @Override
  public String getAddress() {
    return address;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code port} attribute
   */
  @JsonProperty("Port")
  @Override
  public int getPort() {
    return port;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code tags} attribute
   */
  @JsonDeserialize(as = ImmutableMap.class, keyAs = String.class, contentAs = String.class)
  @JsonProperty("Tags")
  @Override
  public ImmutableMap<String, String> getTags() {
    return tags;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code status} attribute
   */
  @JsonProperty("Status")
  @Override
  public int getStatus() {
    return status;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code protocolMin} attribute
   */
  @JsonProperty("ProtocolMin")
  @Override
  public int getProtocolMin() {
    return protocolMin;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code protocolMax} attribute
   */
  @JsonProperty("ProtocolMax")
  @Override
  public int getProtocolMax() {
    return protocolMax;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code protocolCur} attribute
   */
  @JsonProperty("ProtocolCur")
  @Override
  public int getProtocolCur() {
    return protocolCur;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code delegateMin} attribute
   */
  @JsonProperty("DelegateMin")
  @Override
  public int getDelegateMin() {
    return delegateMin;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code delegateMax} attribute
   */
  @JsonProperty("DelegateMax")
  @Override
  public int getDelegateMax() {
    return delegateMax;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code delegateCur} attribute
   */
  @JsonProperty("DelegateCur")
  @Override
  public int getDelegateCur() {
    return delegateCur;
  }
  
  /**
   * Copy current immutable object by setting value for {@link Member#getName() name}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for name
   * @return modified copy of the {@code this} object
   */
  public final ImmutableMember withName(String value) {
    if (this.name == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableMember(
        newValue,
        this.address,
        this.port,
        this.tags,
        this.status,
        this.protocolMin,
        this.protocolMax,
        this.protocolCur,
        this.delegateMin,
        this.delegateMax,
        this.delegateCur);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Member#getAddress() address}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for address
   * @return modified copy of the {@code this} object
   */
  public final ImmutableMember withAddress(String value) {
    if (this.address == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableMember(
        this.name,
        newValue,
        this.port,
        this.tags,
        this.status,
        this.protocolMin,
        this.protocolMax,
        this.protocolCur,
        this.delegateMin,
        this.delegateMax,
        this.delegateCur);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Member#getPort() port}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for port
   * @return modified copy of the {@code this} object
   */
  public final ImmutableMember withPort(int value) {
    if (this.port == value) {
      return this;
    }
    int newValue = value;
    return new ImmutableMember(
        this.name,
        this.address,
        newValue,
        this.tags,
        this.status,
        this.protocolMin,
        this.protocolMax,
        this.protocolCur,
        this.delegateMin,
        this.delegateMax,
        this.delegateCur);
  }
  
  /**
   * Copy current immutable object by replacing {@link Member#getTags() tags} map with specified map.
   * Nulls are not permitted as keys or values.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries to be added to tags map
   * @return modified copy of {@code this} object
   */
  public final ImmutableMember withTags(Map<String, ? extends String> entries) {
    if (this.tags == entries) {
      return this;
    }
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableMember(
        this.name,
        this.address,
        this.port,
        newValue,
        this.status,
        this.protocolMin,
        this.protocolMax,
        this.protocolCur,
        this.delegateMin,
        this.delegateMax,
        this.delegateCur);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Member#getStatus() status}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for status
   * @return modified copy of the {@code this} object
   */
  public final ImmutableMember withStatus(int value) {
    if (this.status == value) {
      return this;
    }
    int newValue = value;
    return new ImmutableMember(
        this.name,
        this.address,
        this.port,
        this.tags,
        newValue,
        this.protocolMin,
        this.protocolMax,
        this.protocolCur,
        this.delegateMin,
        this.delegateMax,
        this.delegateCur);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Member#getProtocolMin() protocolMin}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for protocolMin
   * @return modified copy of the {@code this} object
   */
  public final ImmutableMember withProtocolMin(int value) {
    if (this.protocolMin == value) {
      return this;
    }
    int newValue = value;
    return new ImmutableMember(
        this.name,
        this.address,
        this.port,
        this.tags,
        this.status,
        newValue,
        this.protocolMax,
        this.protocolCur,
        this.delegateMin,
        this.delegateMax,
        this.delegateCur);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Member#getProtocolMax() protocolMax}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for protocolMax
   * @return modified copy of the {@code this} object
   */
  public final ImmutableMember withProtocolMax(int value) {
    if (this.protocolMax == value) {
      return this;
    }
    int newValue = value;
    return new ImmutableMember(
        this.name,
        this.address,
        this.port,
        this.tags,
        this.status,
        this.protocolMin,
        newValue,
        this.protocolCur,
        this.delegateMin,
        this.delegateMax,
        this.delegateCur);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Member#getProtocolCur() protocolCur}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for protocolCur
   * @return modified copy of the {@code this} object
   */
  public final ImmutableMember withProtocolCur(int value) {
    if (this.protocolCur == value) {
      return this;
    }
    int newValue = value;
    return new ImmutableMember(
        this.name,
        this.address,
        this.port,
        this.tags,
        this.status,
        this.protocolMin,
        this.protocolMax,
        newValue,
        this.delegateMin,
        this.delegateMax,
        this.delegateCur);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Member#getDelegateMin() delegateMin}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for delegateMin
   * @return modified copy of the {@code this} object
   */
  public final ImmutableMember withDelegateMin(int value) {
    if (this.delegateMin == value) {
      return this;
    }
    int newValue = value;
    return new ImmutableMember(
        this.name,
        this.address,
        this.port,
        this.tags,
        this.status,
        this.protocolMin,
        this.protocolMax,
        this.protocolCur,
        newValue,
        this.delegateMax,
        this.delegateCur);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Member#getDelegateMax() delegateMax}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for delegateMax
   * @return modified copy of the {@code this} object
   */
  public final ImmutableMember withDelegateMax(int value) {
    if (this.delegateMax == value) {
      return this;
    }
    int newValue = value;
    return new ImmutableMember(
        this.name,
        this.address,
        this.port,
        this.tags,
        this.status,
        this.protocolMin,
        this.protocolMax,
        this.protocolCur,
        this.delegateMin,
        newValue,
        this.delegateCur);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Member#getDelegateCur() delegateCur}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for delegateCur
   * @return modified copy of the {@code this} object
   */
  public final ImmutableMember withDelegateCur(int value) {
    if (this.delegateCur == value) {
      return this;
    }
    int newValue = value;
    return new ImmutableMember(
        this.name,
        this.address,
        this.port,
        this.tags,
        this.status,
        this.protocolMin,
        this.protocolMax,
        this.protocolCur,
        this.delegateMin,
        this.delegateMax,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ImmutableMember} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    return this == another
        || (another instanceof ImmutableMember && equalTo((ImmutableMember) another));
  }
  
  private boolean equalTo(ImmutableMember another) {
    return name.equals(another.name)
        && address.equals(another.address)
        && port == another.port
        && tags.equals(another.tags)
        && status == another.status
        && protocolMin == another.protocolMin
        && protocolMax == another.protocolMax
        && protocolCur == another.protocolCur
        && delegateMin == another.delegateMin
        && delegateMax == another.delegateMax
        && delegateCur == another.delegateCur;
  }
  
  /**
   * Computes hash code from attributes: {@code name}, {@code address}, {@code port}, {@code tags}, {@code status}, {@code protocolMin}, {@code protocolMax}, {@code protocolCur}, {@code delegateMin}, {@code delegateMax}, {@code delegateCur}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + address.hashCode();
    h = h * 17 + port;
    h = h * 17 + tags.hashCode();
    h = h * 17 + status;
    h = h * 17 + protocolMin;
    h = h * 17 + protocolMax;
    h = h * 17 + protocolCur;
    h = h * 17 + delegateMin;
    h = h * 17 + delegateMax;
    h = h * 17 + delegateCur;
    return h;
  }
  
  /**
   * Prints immutable value {@code Member{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Member")
        .add("name", name)
        .add("address", address)
        .add("port", port)
        .add("tags", tags)
        .add("status", status)
        .add("protocolMin", protocolMin)
        .add("protocolMax", protocolMax)
        .add("protocolCur", protocolCur)
        .add("delegateMin", delegateMin)
        .add("delegateMax", delegateMax)
        .add("delegateCur", delegateCur)
        .toString();
  }
  
  @JsonCreator
  public static ImmutableMember fromAllAttributes(
      @JsonProperty("Name") String name,
      @JsonProperty("Addr") String address,
      @JsonProperty("Port") Integer port,
      @JsonDeserialize(as = ImmutableMap.class, keyAs = String.class, contentAs = String.class)
      @JsonProperty("Tags") Map<String, String> tags,
      @JsonProperty("Status") Integer status,
      @JsonProperty("ProtocolMin") Integer protocolMin,
      @JsonProperty("ProtocolMax") Integer protocolMax,
      @JsonProperty("ProtocolCur") Integer protocolCur,
      @JsonProperty("DelegateMin") Integer delegateMin,
      @JsonProperty("DelegateMax") Integer delegateMax,
      @JsonProperty("DelegateCur") Integer delegateCur) {
    ImmutableMember.Builder builder = ImmutableMember.builder();
    if (name != null) {
      builder.name(name);
    }
    if (address != null) {
      builder.address(address);
    }
    if (port != null) {
      builder.port(port);
    }
    if (tags != null) {
      builder.putAllTags(tags);
    }
    if (status != null) {
      builder.status(status);
    }
    if (protocolMin != null) {
      builder.protocolMin(protocolMin);
    }
    if (protocolMax != null) {
      builder.protocolMax(protocolMax);
    }
    if (protocolCur != null) {
      builder.protocolCur(protocolCur);
    }
    if (delegateMin != null) {
      builder.delegateMin(delegateMin);
    }
    if (delegateMax != null) {
      builder.delegateMax(delegateMax);
    }
    if (delegateCur != null) {
      builder.delegateCur(delegateCur);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link Member}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable Member instance
   */
  public static ImmutableMember copyOf(Member instance) {
    if (instance instanceof ImmutableMember) {
      return (ImmutableMember) instance;
    }
    return ImmutableMember.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link com.orbitz.consul.model.agent.ImmutableMember}.
   * @return new ImmutableMember builder
   */
  public static ImmutableMember.Builder builder() {
    return new ImmutableMember.Builder();
  }
  
  /**
   * Builds instances of {@link com.orbitz.consul.model.agent.ImmutableMember}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3ff;
    private static final long INITIALIZED_BIT_NAME = 0x1L;
    private static final long INITIALIZED_BIT_ADDRESS = 0x2L;
    private static final long INITIALIZED_BIT_PORT = 0x4L;
    private static final long INITIALIZED_BIT_STATUS = 0x8L;
    private static final long INITIALIZED_BIT_PROTOCOL_MIN = 0x10L;
    private static final long INITIALIZED_BIT_PROTOCOL_MAX = 0x20L;
    private static final long INITIALIZED_BIT_PROTOCOL_CUR = 0x40L;
    private static final long INITIALIZED_BIT_DELEGATE_MIN = 0x80L;
    private static final long INITIALIZED_BIT_DELEGATE_MAX = 0x100L;
    private static final long INITIALIZED_BIT_DELEGATE_CUR = 0x200L;
    private long initializedBitset;
  
    private String name;
    private String address;
    private int port;
    private ImmutableMap.Builder<String, String> tagsBuilder = ImmutableMap.builder();
    private int status;
    private int protocolMin;
    private int protocolMax;
    private int protocolCur;
    private int delegateMin;
    private int delegateMax;
    private int delegateCur;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link Member} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(Member instance) {
      Preconditions.checkNotNull(instance);
      name(instance.getName());
      address(instance.getAddress());
      port(instance.getPort());
      putAllTags(instance.getTags());
      status(instance.getStatus());
      protocolMin(instance.getProtocolMin());
      protocolMax(instance.getProtocolMax());
      protocolCur(instance.getProtocolCur());
      delegateMin(instance.getDelegateMin());
      delegateMax(instance.getDelegateMax());
      delegateCur(instance.getDelegateCur());
      return this;
    }
  
    /**
     * Initializes value for {@link Member#getName() name}.
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name);
      initializedBitset |= INITIALIZED_BIT_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link Member#getAddress() address}.
     * @param address value for address
     * @return {@code this} builder for chained invocation
     */
    public final Builder address(String address) {
      this.address = Preconditions.checkNotNull(address);
      initializedBitset |= INITIALIZED_BIT_ADDRESS;
      return this;
    }
  
    /**
     * Initializes value for {@link Member#getPort() port}.
     * @param port value for port
     * @return {@code this} builder for chained invocation
     */
    public final Builder port(int port) {
      this.port = port;
      initializedBitset |= INITIALIZED_BIT_PORT;
      return this;
    }
  
    /**
     * Put one entry to {@link Member#getTags() tags} map.
     * @param key the key in tags map
     * @param value the associated value in tags map
     * @return {@code this} builder for chained invocation
     */
    public final Builder putTags(String key, String value) {
      tagsBuilder.put(key, value);
      return this;
    }
  
    /**
     * Put one entry to {@link Member#getTags() tags} map. Nulls are not permitted
     * @param entry the key and value entry
     * @return {@code this} builder for chained invocation
     */
    public final Builder putTags(Map.Entry<String, ? extends String> entry) {
      tagsBuilder.put(entry);
      return this;
    }
  
    /**
     * Sets or replaces all mappings from specified map as entries for {@link Member#getTags() tags} map. Nulls are not permitted
     * @param entries to be added to tags map
     * @return {@code this} builder for chained invocation
     */
    public final Builder tags(Map<String, ? extends String> entries) {
      tagsBuilder = ImmutableMap.builder();
      return putAllTags(entries);
    }
  
    /**
     * Put all mappings from specified map as entries to {@link Member#getTags() tags} map. Nulls are not permitted
     * @param entries to be added to tags map
     * @return {@code this} builder for chained invocation
     */
    public final Builder putAllTags(Map<String, ? extends String> entries) {
      tagsBuilder.putAll(entries);
      return this;
    }
  
    /**
     * Initializes value for {@link Member#getStatus() status}.
     * @param status value for status
     * @return {@code this} builder for chained invocation
     */
    public final Builder status(int status) {
      this.status = status;
      initializedBitset |= INITIALIZED_BIT_STATUS;
      return this;
    }
  
    /**
     * Initializes value for {@link Member#getProtocolMin() protocolMin}.
     * @param protocolMin value for protocolMin
     * @return {@code this} builder for chained invocation
     */
    public final Builder protocolMin(int protocolMin) {
      this.protocolMin = protocolMin;
      initializedBitset |= INITIALIZED_BIT_PROTOCOL_MIN;
      return this;
    }
  
    /**
     * Initializes value for {@link Member#getProtocolMax() protocolMax}.
     * @param protocolMax value for protocolMax
     * @return {@code this} builder for chained invocation
     */
    public final Builder protocolMax(int protocolMax) {
      this.protocolMax = protocolMax;
      initializedBitset |= INITIALIZED_BIT_PROTOCOL_MAX;
      return this;
    }
  
    /**
     * Initializes value for {@link Member#getProtocolCur() protocolCur}.
     * @param protocolCur value for protocolCur
     * @return {@code this} builder for chained invocation
     */
    public final Builder protocolCur(int protocolCur) {
      this.protocolCur = protocolCur;
      initializedBitset |= INITIALIZED_BIT_PROTOCOL_CUR;
      return this;
    }
  
    /**
     * Initializes value for {@link Member#getDelegateMin() delegateMin}.
     * @param delegateMin value for delegateMin
     * @return {@code this} builder for chained invocation
     */
    public final Builder delegateMin(int delegateMin) {
      this.delegateMin = delegateMin;
      initializedBitset |= INITIALIZED_BIT_DELEGATE_MIN;
      return this;
    }
  
    /**
     * Initializes value for {@link Member#getDelegateMax() delegateMax}.
     * @param delegateMax value for delegateMax
     * @return {@code this} builder for chained invocation
     */
    public final Builder delegateMax(int delegateMax) {
      this.delegateMax = delegateMax;
      initializedBitset |= INITIALIZED_BIT_DELEGATE_MAX;
      return this;
    }
  
    /**
     * Initializes value for {@link Member#getDelegateCur() delegateCur}.
     * @param delegateCur value for delegateCur
     * @return {@code this} builder for chained invocation
     */
    public final Builder delegateCur(int delegateCur) {
      this.delegateCur = delegateCur;
      initializedBitset |= INITIALIZED_BIT_DELEGATE_CUR;
      return this;
    }
  
    /**
     * Builds new {@link com.orbitz.consul.model.agent.ImmutableMember}.
     * @return immutable instance of Member
     */
    public ImmutableMember build() {
      checkRequiredAttributes();
      return new ImmutableMember(
        name,
        address,
        port,
        tagsBuilder.build(),
        status,
        protocolMin,
        protocolMax,
        protocolCur,
        delegateMin,
        delegateMax,
        delegateCur);
    }
  
    private boolean nameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NAME) != 0;
    }
  
    private boolean addressIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ADDRESS) != 0;
    }
  
    private boolean portIsSet() {
      return (initializedBitset & INITIALIZED_BIT_PORT) != 0;
    }
  
    private boolean statusIsSet() {
      return (initializedBitset & INITIALIZED_BIT_STATUS) != 0;
    }
  
    private boolean protocolMinIsSet() {
      return (initializedBitset & INITIALIZED_BIT_PROTOCOL_MIN) != 0;
    }
  
    private boolean protocolMaxIsSet() {
      return (initializedBitset & INITIALIZED_BIT_PROTOCOL_MAX) != 0;
    }
  
    private boolean protocolCurIsSet() {
      return (initializedBitset & INITIALIZED_BIT_PROTOCOL_CUR) != 0;
    }
  
    private boolean delegateMinIsSet() {
      return (initializedBitset & INITIALIZED_BIT_DELEGATE_MIN) != 0;
    }
  
    private boolean delegateMaxIsSet() {
      return (initializedBitset & INITIALIZED_BIT_DELEGATE_MAX) != 0;
    }
  
    private boolean delegateCurIsSet() {
      return (initializedBitset & INITIALIZED_BIT_DELEGATE_CUR) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!nameIsSet()) {
        attributes.add("name");
      }
      if (!addressIsSet()) {
        attributes.add("address");
      }
      if (!portIsSet()) {
        attributes.add("port");
      }
      if (!statusIsSet()) {
        attributes.add("status");
      }
      if (!protocolMinIsSet()) {
        attributes.add("protocolMin");
      }
      if (!protocolMaxIsSet()) {
        attributes.add("protocolMax");
      }
      if (!protocolCurIsSet()) {
        attributes.add("protocolCur");
      }
      if (!delegateMinIsSet()) {
        attributes.add("delegateMin");
      }
      if (!delegateMaxIsSet()) {
        attributes.add("delegateMax");
      }
      if (!delegateCurIsSet()) {
        attributes.add("delegateCur");
      }
      return "Cannot build Member, some of required attributes are not set " + attributes;
    }
  }
}
