package com.orbitz.consul.model.health;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link Service}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableService.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "Service"})
public final class ImmutableService extends Service {
  private final String id;
  private final String service;
  private final ImmutableList<String> tags;
  private final String address;
  private final int port;

  private ImmutableService(
      String id,
      String service,
      ImmutableList<String> tags,
      String address,
      int port) {
    this.id = id;
    this.service = service;
    this.tags = tags;
    this.address = address;
    this.port = port;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code id} attribute
   */
  @JsonProperty("ID")
  @Override
  public String getId() {
    return id;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code service} attribute
   */
  @JsonProperty("Service")
  @Override
  public String getService() {
    return service;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code tags} attribute
   */
  @JsonDeserialize(as = ImmutableList.class, contentAs = String.class)
  @JsonProperty("Tags")
  @Override
  public ImmutableList<String> getTags() {
    return tags;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code address} attribute
   */
  @JsonProperty("Address")
  @Override
  public String getAddress() {
    return address;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code port} attribute
   */
  @JsonProperty("Port")
  @Override
  public int getPort() {
    return port;
  }
  
  /**
   * Copy current immutable object by setting value for {@link Service#getId() id}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for id
   * @return modified copy of the {@code this} object
   */
  public final ImmutableService withId(String value) {
    if (this.id == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableService(newValue, this.service, this.tags, this.address, this.port);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Service#getService() service}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for service
   * @return modified copy of the {@code this} object
   */
  public final ImmutableService withService(String value) {
    if (this.service == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableService(this.id, newValue, this.tags, this.address, this.port);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link Service#getTags() tags}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final ImmutableService withTags(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableService(this.id, this.service, newValue, this.address, this.port);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link Service#getTags() tags}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of tags elements to set
   * @return modified copy of {@code this} object
   */
  public final ImmutableService withTags(Iterable<String> elements) {
    if (this.tags == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableService(this.id, this.service, newValue, this.address, this.port);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Service#getAddress() address}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for address
   * @return modified copy of the {@code this} object
   */
  public final ImmutableService withAddress(String value) {
    if (this.address == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableService(this.id, this.service, this.tags, newValue, this.port);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Service#getPort() port}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for port
   * @return modified copy of the {@code this} object
   */
  public final ImmutableService withPort(int value) {
    if (this.port == value) {
      return this;
    }
    int newValue = value;
    return new ImmutableService(this.id, this.service, this.tags, this.address, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ImmutableService} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    return this == another
        || (another instanceof ImmutableService && equalTo((ImmutableService) another));
  }
  
  private boolean equalTo(ImmutableService another) {
    return id.equals(another.id)
        && service.equals(another.service)
        && tags.equals(another.tags)
        && address.equals(another.address)
        && port == another.port;
  }
  
  /**
   * Computes hash code from attributes: {@code id}, {@code service}, {@code tags}, {@code address}, {@code port}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + id.hashCode();
    h = h * 17 + service.hashCode();
    h = h * 17 + tags.hashCode();
    h = h * 17 + address.hashCode();
    h = h * 17 + port;
    return h;
  }
  
  /**
   * Prints immutable value {@code Service{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Service")
        .add("id", id)
        .add("service", service)
        .add("tags", tags)
        .add("address", address)
        .add("port", port)
        .toString();
  }
  
  @JsonCreator
  public static ImmutableService fromAllAttributes(
      @JsonProperty("ID") String id,
      @JsonProperty("Service") String service,
      @JsonDeserialize(as = ImmutableList.class, contentAs = String.class)
      @JsonProperty("Tags") List<String> tags,
      @JsonProperty("Address") String address,
      @JsonProperty("Port") Integer port) {
    ImmutableService.Builder builder = ImmutableService.builder();
    if (id != null) {
      builder.id(id);
    }
    if (service != null) {
      builder.service(service);
    }
    if (tags != null) {
      builder.addAllTags(tags);
    }
    if (address != null) {
      builder.address(address);
    }
    if (port != null) {
      builder.port(port);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link Service}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable Service instance
   */
  public static ImmutableService copyOf(Service instance) {
    if (instance instanceof ImmutableService) {
      return (ImmutableService) instance;
    }
    return ImmutableService.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link com.orbitz.consul.model.health.ImmutableService}.
   * @return new ImmutableService builder
   */
  public static ImmutableService.Builder builder() {
    return new ImmutableService.Builder();
  }
  
  /**
   * Builds instances of {@link com.orbitz.consul.model.health.ImmutableService}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0xf;
    private static final long INITIALIZED_BIT_ID = 0x1L;
    private static final long INITIALIZED_BIT_SERVICE = 0x2L;
    private static final long INITIALIZED_BIT_ADDRESS = 0x4L;
    private static final long INITIALIZED_BIT_PORT = 0x8L;
    private long initializedBitset;
  
    private String id;
    private String service;
    private ImmutableList.Builder<String> tagsBuilder = ImmutableList.builder();
    private String address;
    private int port;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link Service} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(Service instance) {
      Preconditions.checkNotNull(instance);
      id(instance.getId());
      service(instance.getService());
      addAllTags(instance.getTags());
      address(instance.getAddress());
      port(instance.getPort());
      return this;
    }
  
    /**
     * Initializes value for {@link Service#getId() id}.
     * @param id value for id
     * @return {@code this} builder for chained invocation
     */
    public final Builder id(String id) {
      this.id = Preconditions.checkNotNull(id);
      initializedBitset |= INITIALIZED_BIT_ID;
      return this;
    }
  
    /**
     * Initializes value for {@link Service#getService() service}.
     * @param service value for service
     * @return {@code this} builder for chained invocation
     */
    public final Builder service(String service) {
      this.service = Preconditions.checkNotNull(service);
      initializedBitset |= INITIALIZED_BIT_SERVICE;
      return this;
    }
  
    /**
     * Adds one element to {@link Service#getTags() tags} list.
     * @param element tags element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addTags(String element) {
      tagsBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link Service#getTags() tags} list.
     * @param elements array of tags elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addTags(String... elements) {
      tagsBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link Service#getTags() tags} list.
     * @param elements iterable of tags elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder tags(Iterable<String> elements) {
      tagsBuilder = ImmutableList.builder();
      return addAllTags(elements);
    }
  
    /**
     * Adds elements to {@link Service#getTags() tags} list.
     * @param elements iterable of tags elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllTags(Iterable<String> elements) {
      tagsBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link Service#getAddress() address}.
     * @param address value for address
     * @return {@code this} builder for chained invocation
     */
    public final Builder address(String address) {
      this.address = Preconditions.checkNotNull(address);
      initializedBitset |= INITIALIZED_BIT_ADDRESS;
      return this;
    }
  
    /**
     * Initializes value for {@link Service#getPort() port}.
     * @param port value for port
     * @return {@code this} builder for chained invocation
     */
    public final Builder port(int port) {
      this.port = port;
      initializedBitset |= INITIALIZED_BIT_PORT;
      return this;
    }
  
    /**
     * Builds new {@link com.orbitz.consul.model.health.ImmutableService}.
     * @return immutable instance of Service
     */
    public ImmutableService build() {
      checkRequiredAttributes();
      return new ImmutableService(id, service, tagsBuilder.build(), address, port);
    }
  
    private boolean idIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ID) != 0;
    }
  
    private boolean serviceIsSet() {
      return (initializedBitset & INITIALIZED_BIT_SERVICE) != 0;
    }
  
    private boolean addressIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ADDRESS) != 0;
    }
  
    private boolean portIsSet() {
      return (initializedBitset & INITIALIZED_BIT_PORT) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!idIsSet()) {
        attributes.add("id");
      }
      if (!serviceIsSet()) {
        attributes.add("service");
      }
      if (!addressIsSet()) {
        attributes.add("address");
      }
      if (!portIsSet()) {
        attributes.add("port");
      }
      return "Cannot build Service, some of required attributes are not set " + attributes;
    }
  }
}
