package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link Registration.RegCheck}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableRegCheck.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "Registration.RegCheck"})
public final class ImmutableRegCheck extends Registration.RegCheck {
  private final Optional<String> script;
  private final Optional<String> interval;
  private final Optional<String> ttl;
  private final Optional<String> http;

  private ImmutableRegCheck(
      Optional<String> script,
      Optional<String> interval,
      Optional<String> ttl,
      Optional<String> http) {
    this.script = script;
    this.interval = interval;
    this.ttl = ttl;
    this.http = http;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code script} attribute
   */
  @JsonProperty("Script")
  @Override
  public Optional<String> getScript() {
    return script;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code interval} attribute
   */
  @JsonProperty("Interval")
  @Override
  public Optional<String> getInterval() {
    return interval;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code ttl} attribute
   */
  @JsonProperty("TTL")
  @Override
  public Optional<String> getTtl() {
    return ttl;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code http} attribute
   */
  @JsonProperty("HTTP")
  @Override
  public Optional<String> getHttp() {
    return http;
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link Registration.RegCheck#getScript() script}.
   * @param value value for script
   * @return modified copy of {@code this} object
   */
  public final ImmutableRegCheck withScript(String value) {
    Optional<String> newValue = Optional.of(value);
    return validate(new ImmutableRegCheck(newValue, this.interval, this.ttl, this.http));
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link Registration.RegCheck#getScript() script}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for script
   * @return modified copy of {@code this} object
   */
  public final ImmutableRegCheck withScript(Optional<String> optional) {
    if (this.script == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return validate(new ImmutableRegCheck(newValue, this.interval, this.ttl, this.http));
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link Registration.RegCheck#getInterval() interval}.
   * @param value value for interval
   * @return modified copy of {@code this} object
   */
  public final ImmutableRegCheck withInterval(String value) {
    Optional<String> newValue = Optional.of(value);
    return validate(new ImmutableRegCheck(this.script, newValue, this.ttl, this.http));
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link Registration.RegCheck#getInterval() interval}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for interval
   * @return modified copy of {@code this} object
   */
  public final ImmutableRegCheck withInterval(Optional<String> optional) {
    if (this.interval == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return validate(new ImmutableRegCheck(this.script, newValue, this.ttl, this.http));
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link Registration.RegCheck#getTtl() ttl}.
   * @param value value for ttl
   * @return modified copy of {@code this} object
   */
  public final ImmutableRegCheck withTtl(String value) {
    Optional<String> newValue = Optional.of(value);
    return validate(new ImmutableRegCheck(this.script, this.interval, newValue, this.http));
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link Registration.RegCheck#getTtl() ttl}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for ttl
   * @return modified copy of {@code this} object
   */
  public final ImmutableRegCheck withTtl(Optional<String> optional) {
    if (this.ttl == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return validate(new ImmutableRegCheck(this.script, this.interval, newValue, this.http));
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link Registration.RegCheck#getHttp() http}.
   * @param value value for http
   * @return modified copy of {@code this} object
   */
  public final ImmutableRegCheck withHttp(String value) {
    Optional<String> newValue = Optional.of(value);
    return validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, newValue));
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link Registration.RegCheck#getHttp() http}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for http
   * @return modified copy of {@code this} object
   */
  public final ImmutableRegCheck withHttp(Optional<String> optional) {
    if (this.http == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, newValue));
  }
  
  /**
   * This instance is equal to instances of {@code ImmutableRegCheck} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    return this == another
        || (another instanceof ImmutableRegCheck && equalTo((ImmutableRegCheck) another));
  }
  
  private boolean equalTo(ImmutableRegCheck another) {
    return script.equals(another.script)
        && interval.equals(another.interval)
        && ttl.equals(another.ttl)
        && http.equals(another.http);
  }
  
  /**
   * Computes hash code from attributes: {@code script}, {@code interval}, {@code ttl}, {@code http}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + script.hashCode();
    h = h * 17 + interval.hashCode();
    h = h * 17 + ttl.hashCode();
    h = h * 17 + http.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code RegCheck{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RegCheck")
        .add("script", script)
        .add("interval", interval)
        .add("ttl", ttl)
        .add("http", http)
        .toString();
  }
  
  @JsonCreator
  public static ImmutableRegCheck fromAllAttributes(
      @JsonProperty("Script") Optional<String> script,
      @JsonProperty("Interval") Optional<String> interval,
      @JsonProperty("TTL") Optional<String> ttl,
      @JsonProperty("HTTP") Optional<String> http) {
    ImmutableRegCheck.Builder builder = ImmutableRegCheck.builder();
    if (script != null) {
      builder.script(script);
    }
    if (interval != null) {
      builder.interval(interval);
    }
    if (ttl != null) {
      builder.ttl(ttl);
    }
    if (http != null) {
      builder.http(http);
    }
    return builder.build();
  }

  private static ImmutableRegCheck validate(ImmutableRegCheck instance) {
    instance.validate();
    return instance;
  }
  
  /**
   * Creates immutable copy of {@link Registration.RegCheck}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable RegCheck instance
   */
  public static ImmutableRegCheck copyOf(Registration.RegCheck instance) {
    if (instance instanceof ImmutableRegCheck) {
      return (ImmutableRegCheck) instance;
    }
    return ImmutableRegCheck.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link com.orbitz.consul.model.agent.ImmutableRegCheck}.
   * @return new ImmutableRegCheck builder
   */
  public static ImmutableRegCheck.Builder builder() {
    return new ImmutableRegCheck.Builder();
  }
  
  /**
   * Builds instances of {@link com.orbitz.consul.model.agent.ImmutableRegCheck}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  public static final class Builder {
  
    private Optional<String> script = Optional.absent();
    private Optional<String> interval = Optional.absent();
    private Optional<String> ttl = Optional.absent();
    private Optional<String> http = Optional.absent();
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link Registration.RegCheck} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(Registration.RegCheck instance) {
      Preconditions.checkNotNull(instance);
      Optional<String> scriptOptional = instance.getScript();
      if (scriptOptional.isPresent()) {
        script(scriptOptional);
      }
      Optional<String> intervalOptional = instance.getInterval();
      if (intervalOptional.isPresent()) {
        interval(intervalOptional);
      }
      Optional<String> ttlOptional = instance.getTtl();
      if (ttlOptional.isPresent()) {
        ttl(ttlOptional);
      }
      Optional<String> httpOptional = instance.getHttp();
      if (httpOptional.isPresent()) {
        http(httpOptional);
      }
      return this;
    }
  
    /**
     * Initializes present value for optional {@link Registration.RegCheck#getScript() script}.
     * @param script value for script
     * @return {@code this} builder for chained invocation
     */
    public final Builder script(String script) {
      this.script = Optional.of(script);
      return this;
    }
  
    /**
     * Initializes optional value for {@link Registration.RegCheck#getScript() script}.
     * @param script value for script
     * @return {@code this} builder for chained invocation
     */
    public final Builder script(Optional<String> script) {
      this.script = Preconditions.checkNotNull(script);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link Registration.RegCheck#getInterval() interval}.
     * @param interval value for interval
     * @return {@code this} builder for chained invocation
     */
    public final Builder interval(String interval) {
      this.interval = Optional.of(interval);
      return this;
    }
  
    /**
     * Initializes optional value for {@link Registration.RegCheck#getInterval() interval}.
     * @param interval value for interval
     * @return {@code this} builder for chained invocation
     */
    public final Builder interval(Optional<String> interval) {
      this.interval = Preconditions.checkNotNull(interval);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link Registration.RegCheck#getTtl() ttl}.
     * @param ttl value for ttl
     * @return {@code this} builder for chained invocation
     */
    public final Builder ttl(String ttl) {
      this.ttl = Optional.of(ttl);
      return this;
    }
  
    /**
     * Initializes optional value for {@link Registration.RegCheck#getTtl() ttl}.
     * @param ttl value for ttl
     * @return {@code this} builder for chained invocation
     */
    public final Builder ttl(Optional<String> ttl) {
      this.ttl = Preconditions.checkNotNull(ttl);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link Registration.RegCheck#getHttp() http}.
     * @param http value for http
     * @return {@code this} builder for chained invocation
     */
    public final Builder http(String http) {
      this.http = Optional.of(http);
      return this;
    }
  
    /**
     * Initializes optional value for {@link Registration.RegCheck#getHttp() http}.
     * @param http value for http
     * @return {@code this} builder for chained invocation
     */
    public final Builder http(Optional<String> http) {
      this.http = Preconditions.checkNotNull(http);
      return this;
    }
  
    /**
     * Builds new {@link com.orbitz.consul.model.agent.ImmutableRegCheck}.
     * @return immutable instance of RegCheck
     */
    public ImmutableRegCheck build() {
      return ImmutableRegCheck.validate(new ImmutableRegCheck(script, interval, ttl, http));
    }
  }
}
