package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link CatalogOptions}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableCatalogOptions.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "CatalogOptions"})
public final class ImmutableCatalogOptions extends CatalogOptions {
  private final Optional<String> datacenter;
  private final Optional<String> tag;

  private ImmutableCatalogOptions(
      Optional<String> datacenter,
      Optional<String> tag) {
    this.datacenter = datacenter;
    this.tag = tag;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code datacenter} attribute
   */
  @Override
  public Optional<String> getDatacenter() {
    return datacenter;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code tag} attribute
   */
  @Override
  public Optional<String> getTag() {
    return tag;
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link CatalogOptions#getDatacenter() datacenter}.
   * @param value value for datacenter
   * @return modified copy of {@code this} object
   */
  public final ImmutableCatalogOptions withDatacenter(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableCatalogOptions(newValue, this.tag);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link CatalogOptions#getDatacenter() datacenter}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for datacenter
   * @return modified copy of {@code this} object
   */
  public final ImmutableCatalogOptions withDatacenter(Optional<String> optional) {
    if (this.datacenter == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableCatalogOptions(newValue, this.tag);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link CatalogOptions#getTag() tag}.
   * @param value value for tag
   * @return modified copy of {@code this} object
   */
  public final ImmutableCatalogOptions withTag(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableCatalogOptions(this.datacenter, newValue);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link CatalogOptions#getTag() tag}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for tag
   * @return modified copy of {@code this} object
   */
  public final ImmutableCatalogOptions withTag(Optional<String> optional) {
    if (this.tag == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableCatalogOptions(this.datacenter, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ImmutableCatalogOptions} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    return this == another
        || (another instanceof ImmutableCatalogOptions && equalTo((ImmutableCatalogOptions) another));
  }
  
  private boolean equalTo(ImmutableCatalogOptions another) {
    return datacenter.equals(another.datacenter)
        && tag.equals(another.tag);
  }
  
  /**
   * Computes hash code from attributes: {@code datacenter}, {@code tag}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + datacenter.hashCode();
    h = h * 17 + tag.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code CatalogOptions{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CatalogOptions")
        .add("datacenter", datacenter)
        .add("tag", tag)
        .toString();
  }
  
  /**
   * Creates immutable copy of {@link CatalogOptions}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable CatalogOptions instance
   */
  public static ImmutableCatalogOptions copyOf(CatalogOptions instance) {
    if (instance instanceof ImmutableCatalogOptions) {
      return (ImmutableCatalogOptions) instance;
    }
    return ImmutableCatalogOptions.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link com.orbitz.consul.option.ImmutableCatalogOptions}.
   * @return new ImmutableCatalogOptions builder
   */
  public static ImmutableCatalogOptions.Builder builder() {
    return new ImmutableCatalogOptions.Builder();
  }
  
  /**
   * Builds instances of {@link com.orbitz.consul.option.ImmutableCatalogOptions}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  public static final class Builder {
  
    private Optional<String> datacenter = Optional.absent();
    private Optional<String> tag = Optional.absent();
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link CatalogOptions} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(CatalogOptions instance) {
      Preconditions.checkNotNull(instance);
      Optional<String> datacenterOptional = instance.getDatacenter();
      if (datacenterOptional.isPresent()) {
        datacenter(datacenterOptional);
      }
      Optional<String> tagOptional = instance.getTag();
      if (tagOptional.isPresent()) {
        tag(tagOptional);
      }
      return this;
    }
  
    /**
     * Initializes present value for optional {@link CatalogOptions#getDatacenter() datacenter}.
     * @param datacenter value for datacenter
     * @return {@code this} builder for chained invocation
     */
    public final Builder datacenter(String datacenter) {
      this.datacenter = Optional.of(datacenter);
      return this;
    }
  
    /**
     * Initializes optional value for {@link CatalogOptions#getDatacenter() datacenter}.
     * @param datacenter value for datacenter
     * @return {@code this} builder for chained invocation
     */
    public final Builder datacenter(Optional<String> datacenter) {
      this.datacenter = Preconditions.checkNotNull(datacenter);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link CatalogOptions#getTag() tag}.
     * @param tag value for tag
     * @return {@code this} builder for chained invocation
     */
    public final Builder tag(String tag) {
      this.tag = Optional.of(tag);
      return this;
    }
  
    /**
     * Initializes optional value for {@link CatalogOptions#getTag() tag}.
     * @param tag value for tag
     * @return {@code this} builder for chained invocation
     */
    public final Builder tag(Optional<String> tag) {
      this.tag = Preconditions.checkNotNull(tag);
      return this;
    }
  
    /**
     * Builds new {@link com.orbitz.consul.option.ImmutableCatalogOptions}.
     * @return immutable instance of CatalogOptions
     */
    public ImmutableCatalogOptions build() {
      return new ImmutableCatalogOptions(datacenter, tag);
    }
  }
}
