/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.catalog.TaggedAddresses;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableTaggedAddresses
extends TaggedAddresses {
    private final String wan;

    private ImmutableTaggedAddresses(String wan) {
        this.wan = wan;
    }

    @Override
    @JsonProperty(value="wan")
    public String getWan() {
        return this.wan;
    }

    public final ImmutableTaggedAddresses withWan(String value) {
        if (this.wan.equals(value)) {
            return this;
        }
        return new ImmutableTaggedAddresses((String)Preconditions.checkNotNull((Object)value, (Object)"wan"));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTaggedAddresses && this.equalTo((ImmutableTaggedAddresses)another);
    }

    private boolean equalTo(ImmutableTaggedAddresses another) {
        return this.wan.equals(another.wan);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.wan.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TaggedAddresses").omitNullValues().add("wan", (Object)this.wan).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableTaggedAddresses fromJson(Json json) {
        Builder builder = ImmutableTaggedAddresses.builder();
        if (json.wan != null) {
            builder.wan(json.wan);
        }
        return builder.build();
    }

    public static ImmutableTaggedAddresses copyOf(TaggedAddresses instance) {
        if (instance instanceof ImmutableTaggedAddresses) {
            return (ImmutableTaggedAddresses)instance;
        }
        return ImmutableTaggedAddresses.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_WAN = 1L;
        private long initBits = 1L;
        @Nullable
        private String wan;

        private Builder() {
        }

        public final Builder from(TaggedAddresses instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.wan(instance.getWan());
            return this;
        }

        public final Builder wan(String wan) {
            this.wan = (String)Preconditions.checkNotNull((Object)wan, (Object)"wan");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableTaggedAddresses build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTaggedAddresses(this.wan);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("wan");
            }
            return "Cannot build TaggedAddresses, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends TaggedAddresses {
        @Nullable
        String wan;

        Json() {
        }

        @JsonProperty(value="wan")
        public void setWan(String wan) {
            this.wan = wan;
        }

        @Override
        public String getWan() {
            throw new UnsupportedOperationException();
        }
    }
}

