/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.async.ConsulResponseCallback;
import com.orbitz.consul.cache.ConsulCache;
import com.orbitz.consul.model.kv.Value;
import com.orbitz.consul.option.QueryOptions;
import java.math.BigInteger;
import java.util.List;

public class KVCache
extends ConsulCache<String, Value> {
    private KVCache(Function<Value, String> keyConversion, ConsulCache.CallbackConsumer<Value> callbackConsumer) {
        super(keyConversion, callbackConsumer);
    }

    @VisibleForTesting
    static Function<Value, String> getKeyExtractorFunction(final String rootPath) {
        return new Function<Value, String>(){

            public String apply(Value input) {
                Preconditions.checkNotNull((Object)input, (Object)"Input to key extractor is null");
                Preconditions.checkNotNull((Object)input.getKey(), (Object)"Input to key extractor has no key");
                if (rootPath.equals(input.getKey())) {
                    return "";
                }
                int lastSlashIndex = rootPath.lastIndexOf("/");
                if (lastSlashIndex >= 0) {
                    return input.getKey().substring(lastSlashIndex + 1);
                }
                return input.getKey();
            }
        };
    }

    public static KVCache newCache(final KeyValueClient kvClient, String rootPath, final int watchSeconds, final QueryOptions queryOptions) {
        final String keyPath = KVCache.prepareRootPath(rootPath);
        Function<Value, String> keyExtractor = KVCache.getKeyExtractorFunction(keyPath);
        ConsulCache.CallbackConsumer<Value> callbackConsumer = new ConsulCache.CallbackConsumer<Value>(){

            @Override
            public void consume(BigInteger index, ConsulResponseCallback<List<Value>> callback) {
                QueryOptions params = ConsulCache.watchParams(index, watchSeconds, queryOptions);
                kvClient.getValues(keyPath, params, callback);
            }
        };
        return new KVCache(keyExtractor, callbackConsumer);
    }

    @VisibleForTesting
    static String prepareRootPath(String rootPath) {
        return rootPath.startsWith("/") ? rootPath.substring(1) : rootPath;
    }

    public static KVCache newCache(KeyValueClient kvClient, String rootPath, int watchSeconds) {
        return KVCache.newCache(kvClient, rootPath, watchSeconds, QueryOptions.BLANK);
    }

    public static KVCache newCache(KeyValueClient kvClient, String rootPath) {
        return KVCache.newCache(kvClient, rootPath, 10);
    }
}

