/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.orbitz.consul.option.EventOptions;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableEventOptions
extends EventOptions {
    private final Optional<String> datacenter;
    private final Optional<String> nodeFilter;
    private final Optional<String> serviceFilter;
    private final Optional<String> tagFilter;

    private ImmutableEventOptions(Optional<String> datacenter, Optional<String> nodeFilter, Optional<String> serviceFilter, Optional<String> tagFilter) {
        this.datacenter = datacenter;
        this.nodeFilter = nodeFilter;
        this.serviceFilter = serviceFilter;
        this.tagFilter = tagFilter;
    }

    @Override
    public Optional<String> getDatacenter() {
        return this.datacenter;
    }

    @Override
    public Optional<String> getNodeFilter() {
        return this.nodeFilter;
    }

    @Override
    public Optional<String> getServiceFilter() {
        return this.serviceFilter;
    }

    @Override
    public Optional<String> getTagFilter() {
        return this.tagFilter;
    }

    public final ImmutableEventOptions withDatacenter(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.datacenter.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableEventOptions((Optional<String>)newValue, this.nodeFilter, this.serviceFilter, this.tagFilter);
    }

    public final ImmutableEventOptions withDatacenter(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"datacenter");
        if (this.datacenter.equals((Object)value)) {
            return this;
        }
        return new ImmutableEventOptions((Optional<String>)value, this.nodeFilter, this.serviceFilter, this.tagFilter);
    }

    public final ImmutableEventOptions withNodeFilter(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.nodeFilter.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableEventOptions(this.datacenter, (Optional<String>)newValue, this.serviceFilter, this.tagFilter);
    }

    public final ImmutableEventOptions withNodeFilter(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"nodeFilter");
        if (this.nodeFilter.equals((Object)value)) {
            return this;
        }
        return new ImmutableEventOptions(this.datacenter, (Optional<String>)value, this.serviceFilter, this.tagFilter);
    }

    public final ImmutableEventOptions withServiceFilter(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.serviceFilter.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableEventOptions(this.datacenter, this.nodeFilter, (Optional<String>)newValue, this.tagFilter);
    }

    public final ImmutableEventOptions withServiceFilter(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"serviceFilter");
        if (this.serviceFilter.equals((Object)value)) {
            return this;
        }
        return new ImmutableEventOptions(this.datacenter, this.nodeFilter, (Optional<String>)value, this.tagFilter);
    }

    public final ImmutableEventOptions withTagFilter(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.tagFilter.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableEventOptions(this.datacenter, this.nodeFilter, this.serviceFilter, (Optional<String>)newValue);
    }

    public final ImmutableEventOptions withTagFilter(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"tagFilter");
        if (this.tagFilter.equals((Object)value)) {
            return this;
        }
        return new ImmutableEventOptions(this.datacenter, this.nodeFilter, this.serviceFilter, (Optional<String>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEventOptions && this.equalTo((ImmutableEventOptions)another);
    }

    private boolean equalTo(ImmutableEventOptions another) {
        return this.datacenter.equals(another.datacenter) && this.nodeFilter.equals(another.nodeFilter) && this.serviceFilter.equals(another.serviceFilter) && this.tagFilter.equals(another.tagFilter);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.datacenter.hashCode();
        h = h * 17 + this.nodeFilter.hashCode();
        h = h * 17 + this.serviceFilter.hashCode();
        h = h * 17 + this.tagFilter.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"EventOptions").omitNullValues().add("datacenter", this.datacenter.orNull()).add("nodeFilter", this.nodeFilter.orNull()).add("serviceFilter", this.serviceFilter.orNull()).add("tagFilter", this.tagFilter.orNull()).toString();
    }

    public static ImmutableEventOptions copyOf(EventOptions instance) {
        if (instance instanceof ImmutableEventOptions) {
            return (ImmutableEventOptions)instance;
        }
        return ImmutableEventOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private Optional<String> datacenter = Optional.absent();
        private Optional<String> nodeFilter = Optional.absent();
        private Optional<String> serviceFilter = Optional.absent();
        private Optional<String> tagFilter = Optional.absent();

        private Builder() {
        }

        public final Builder from(EventOptions instance) {
            Optional<String> tagFilterOptional;
            Optional<String> serviceFilterOptional;
            Optional<String> nodeFilterOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<String> datacenterOptional = instance.getDatacenter();
            if (datacenterOptional.isPresent()) {
                this.datacenter(datacenterOptional);
            }
            if ((nodeFilterOptional = instance.getNodeFilter()).isPresent()) {
                this.nodeFilter(nodeFilterOptional);
            }
            if ((serviceFilterOptional = instance.getServiceFilter()).isPresent()) {
                this.serviceFilter(serviceFilterOptional);
            }
            if ((tagFilterOptional = instance.getTagFilter()).isPresent()) {
                this.tagFilter(tagFilterOptional);
            }
            return this;
        }

        public final Builder datacenter(String datacenter) {
            this.datacenter = Optional.of((Object)datacenter);
            return this;
        }

        public final Builder datacenter(Optional<String> datacenter) {
            this.datacenter = (Optional)Preconditions.checkNotNull(datacenter, (Object)"datacenter");
            return this;
        }

        public final Builder nodeFilter(String nodeFilter) {
            this.nodeFilter = Optional.of((Object)nodeFilter);
            return this;
        }

        public final Builder nodeFilter(Optional<String> nodeFilter) {
            this.nodeFilter = (Optional)Preconditions.checkNotNull(nodeFilter, (Object)"nodeFilter");
            return this;
        }

        public final Builder serviceFilter(String serviceFilter) {
            this.serviceFilter = Optional.of((Object)serviceFilter);
            return this;
        }

        public final Builder serviceFilter(Optional<String> serviceFilter) {
            this.serviceFilter = (Optional)Preconditions.checkNotNull(serviceFilter, (Object)"serviceFilter");
            return this;
        }

        public final Builder tagFilter(String tagFilter) {
            this.tagFilter = Optional.of((Object)tagFilter);
            return this;
        }

        public final Builder tagFilter(Optional<String> tagFilter) {
            this.tagFilter = (Optional)Preconditions.checkNotNull(tagFilter, (Object)"tagFilter");
            return this;
        }

        public ImmutableEventOptions build() {
            return new ImmutableEventOptions(this.datacenter, this.nodeFilter, this.serviceFilter, this.tagFilter);
        }
    }
}

