/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.cache;

import com.google.common.base.Function;
import com.orbitz.consul.CatalogClient;
import com.orbitz.consul.async.ConsulResponseCallback;
import com.orbitz.consul.cache.ConsulCache;
import com.orbitz.consul.model.health.Node;
import com.orbitz.consul.option.CatalogOptions;
import com.orbitz.consul.option.QueryOptions;
import java.math.BigInteger;
import java.util.List;

public class NodesCatalogCache
extends ConsulCache<String, Node> {
    private NodesCatalogCache(Function<Node, String> keyConversion, ConsulCache.CallbackConsumer<Node> callbackConsumer) {
        super(keyConversion, callbackConsumer);
    }

    public static NodesCatalogCache newCache(final CatalogClient catalogClient, final CatalogOptions catalogOptions, final QueryOptions queryOptions, final int watchSeconds) {
        Function<Node, String> keyExtractor = new Function<Node, String>(){

            public String apply(Node node) {
                return node.getNode();
            }
        };
        ConsulCache.CallbackConsumer<Node> callbackConsumer = new ConsulCache.CallbackConsumer<Node>(){

            @Override
            public void consume(BigInteger index, ConsulResponseCallback<List<Node>> callback) {
                catalogClient.getNodes(catalogOptions, ConsulCache.watchParams(index, watchSeconds, queryOptions), callback);
            }
        };
        return new NodesCatalogCache(keyExtractor, callbackConsumer);
    }

    public static NodesCatalogCache newCache(CatalogClient catalogClient) {
        return NodesCatalogCache.newCache(catalogClient, CatalogOptions.BLANK, QueryOptions.BLANK, 10);
    }
}

