/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.orbitz.consul.model.agent.Registration;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRegCheck
extends Registration.RegCheck {
    private final Optional<String> script;
    private final Optional<String> interval;
    private final Optional<String> ttl;
    private final Optional<String> http;
    private final Optional<String> tcp;
    private final Optional<String> timeout;
    private final Optional<String> notes;
    private final Optional<String> deregisterCriticalServiceAfter;
    private final Optional<Boolean> tlsSkipVerify;
    private final Optional<String> status;

    private ImmutableRegCheck(Optional<String> script, Optional<String> interval, Optional<String> ttl, Optional<String> http, Optional<String> tcp, Optional<String> timeout, Optional<String> notes, Optional<String> deregisterCriticalServiceAfter, Optional<Boolean> tlsSkipVerify, Optional<String> status) {
        this.script = script;
        this.interval = interval;
        this.ttl = ttl;
        this.http = http;
        this.tcp = tcp;
        this.timeout = timeout;
        this.notes = notes;
        this.deregisterCriticalServiceAfter = deregisterCriticalServiceAfter;
        this.tlsSkipVerify = tlsSkipVerify;
        this.status = status;
    }

    @Override
    @JsonProperty(value="Script")
    public Optional<String> getScript() {
        return this.script;
    }

    @Override
    @JsonProperty(value="Interval")
    public Optional<String> getInterval() {
        return this.interval;
    }

    @Override
    @JsonProperty(value="TTL")
    public Optional<String> getTtl() {
        return this.ttl;
    }

    @Override
    @JsonProperty(value="HTTP")
    public Optional<String> getHttp() {
        return this.http;
    }

    @Override
    @JsonProperty(value="TCP")
    public Optional<String> getTcp() {
        return this.tcp;
    }

    @Override
    @JsonProperty(value="Timeout")
    public Optional<String> getTimeout() {
        return this.timeout;
    }

    @Override
    @JsonProperty(value="Notes")
    public Optional<String> getNotes() {
        return this.notes;
    }

    @Override
    @JsonProperty(value="DeregisterCriticalServiceAfter")
    public Optional<String> getDeregisterCriticalServiceAfter() {
        return this.deregisterCriticalServiceAfter;
    }

    @Override
    @JsonProperty(value="TLSSkipVerify")
    public Optional<Boolean> getTlsSkipVerify() {
        return this.tlsSkipVerify;
    }

    @Override
    @JsonProperty(value="Status")
    public Optional<String> getStatus() {
        return this.status;
    }

    public final ImmutableRegCheck withScript(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.script.equals((Object)newValue)) {
            return this;
        }
        return ImmutableRegCheck.validate(new ImmutableRegCheck((Optional<String>)newValue, this.interval, this.ttl, this.http, this.tcp, this.timeout, this.notes, this.deregisterCriticalServiceAfter, this.tlsSkipVerify, this.status));
    }

    public final ImmutableRegCheck withScript(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"script");
        if (this.script.equals((Object)value)) {
            return this;
        }
        return ImmutableRegCheck.validate(new ImmutableRegCheck((Optional<String>)value, this.interval, this.ttl, this.http, this.tcp, this.timeout, this.notes, this.deregisterCriticalServiceAfter, this.tlsSkipVerify, this.status));
    }

    public final ImmutableRegCheck withInterval(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.interval.equals((Object)newValue)) {
            return this;
        }
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, (Optional<String>)newValue, this.ttl, this.http, this.tcp, this.timeout, this.notes, this.deregisterCriticalServiceAfter, this.tlsSkipVerify, this.status));
    }

    public final ImmutableRegCheck withInterval(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"interval");
        if (this.interval.equals((Object)value)) {
            return this;
        }
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, (Optional<String>)value, this.ttl, this.http, this.tcp, this.timeout, this.notes, this.deregisterCriticalServiceAfter, this.tlsSkipVerify, this.status));
    }

    public final ImmutableRegCheck withTtl(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.ttl.equals((Object)newValue)) {
            return this;
        }
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, this.interval, (Optional<String>)newValue, this.http, this.tcp, this.timeout, this.notes, this.deregisterCriticalServiceAfter, this.tlsSkipVerify, this.status));
    }

    public final ImmutableRegCheck withTtl(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"ttl");
        if (this.ttl.equals((Object)value)) {
            return this;
        }
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, this.interval, (Optional<String>)value, this.http, this.tcp, this.timeout, this.notes, this.deregisterCriticalServiceAfter, this.tlsSkipVerify, this.status));
    }

    public final ImmutableRegCheck withHttp(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.http.equals((Object)newValue)) {
            return this;
        }
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, (Optional<String>)newValue, this.tcp, this.timeout, this.notes, this.deregisterCriticalServiceAfter, this.tlsSkipVerify, this.status));
    }

    public final ImmutableRegCheck withHttp(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"http");
        if (this.http.equals((Object)value)) {
            return this;
        }
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, (Optional<String>)value, this.tcp, this.timeout, this.notes, this.deregisterCriticalServiceAfter, this.tlsSkipVerify, this.status));
    }

    public final ImmutableRegCheck withTcp(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.tcp.equals((Object)newValue)) {
            return this;
        }
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, this.http, (Optional<String>)newValue, this.timeout, this.notes, this.deregisterCriticalServiceAfter, this.tlsSkipVerify, this.status));
    }

    public final ImmutableRegCheck withTcp(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"tcp");
        if (this.tcp.equals((Object)value)) {
            return this;
        }
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, this.http, (Optional<String>)value, this.timeout, this.notes, this.deregisterCriticalServiceAfter, this.tlsSkipVerify, this.status));
    }

    public final ImmutableRegCheck withTimeout(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.timeout.equals((Object)newValue)) {
            return this;
        }
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, this.http, this.tcp, (Optional<String>)newValue, this.notes, this.deregisterCriticalServiceAfter, this.tlsSkipVerify, this.status));
    }

    public final ImmutableRegCheck withTimeout(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"timeout");
        if (this.timeout.equals((Object)value)) {
            return this;
        }
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, this.http, this.tcp, (Optional<String>)value, this.notes, this.deregisterCriticalServiceAfter, this.tlsSkipVerify, this.status));
    }

    public final ImmutableRegCheck withNotes(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.notes.equals((Object)newValue)) {
            return this;
        }
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, this.http, this.tcp, this.timeout, (Optional<String>)newValue, this.deregisterCriticalServiceAfter, this.tlsSkipVerify, this.status));
    }

    public final ImmutableRegCheck withNotes(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"notes");
        if (this.notes.equals((Object)value)) {
            return this;
        }
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, this.http, this.tcp, this.timeout, (Optional<String>)value, this.deregisterCriticalServiceAfter, this.tlsSkipVerify, this.status));
    }

    public final ImmutableRegCheck withDeregisterCriticalServiceAfter(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.deregisterCriticalServiceAfter.equals((Object)newValue)) {
            return this;
        }
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, this.http, this.tcp, this.timeout, this.notes, (Optional<String>)newValue, this.tlsSkipVerify, this.status));
    }

    public final ImmutableRegCheck withDeregisterCriticalServiceAfter(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"deregisterCriticalServiceAfter");
        if (this.deregisterCriticalServiceAfter.equals((Object)value)) {
            return this;
        }
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, this.http, this.tcp, this.timeout, this.notes, (Optional<String>)value, this.tlsSkipVerify, this.status));
    }

    public final ImmutableRegCheck withTlsSkipVerify(boolean value) {
        Optional newValue = Optional.of((Object)value);
        if (this.tlsSkipVerify.equals((Object)newValue)) {
            return this;
        }
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, this.http, this.tcp, this.timeout, this.notes, this.deregisterCriticalServiceAfter, (Optional<Boolean>)newValue, this.status));
    }

    public final ImmutableRegCheck withTlsSkipVerify(Optional<Boolean> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"tlsSkipVerify");
        if (this.tlsSkipVerify.equals((Object)value)) {
            return this;
        }
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, this.http, this.tcp, this.timeout, this.notes, this.deregisterCriticalServiceAfter, (Optional<Boolean>)value, this.status));
    }

    public final ImmutableRegCheck withStatus(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.status.equals((Object)newValue)) {
            return this;
        }
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, this.http, this.tcp, this.timeout, this.notes, this.deregisterCriticalServiceAfter, this.tlsSkipVerify, (Optional<String>)newValue));
    }

    public final ImmutableRegCheck withStatus(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"status");
        if (this.status.equals((Object)value)) {
            return this;
        }
        return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, this.http, this.tcp, this.timeout, this.notes, this.deregisterCriticalServiceAfter, this.tlsSkipVerify, (Optional<String>)value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRegCheck && this.equalTo((ImmutableRegCheck)another);
    }

    private boolean equalTo(ImmutableRegCheck another) {
        return this.script.equals(another.script) && this.interval.equals(another.interval) && this.ttl.equals(another.ttl) && this.http.equals(another.http) && this.tcp.equals(another.tcp) && this.timeout.equals(another.timeout) && this.notes.equals(another.notes) && this.deregisterCriticalServiceAfter.equals(another.deregisterCriticalServiceAfter) && this.tlsSkipVerify.equals(another.tlsSkipVerify) && this.status.equals(another.status);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.script.hashCode();
        h = h * 17 + this.interval.hashCode();
        h = h * 17 + this.ttl.hashCode();
        h = h * 17 + this.http.hashCode();
        h = h * 17 + this.tcp.hashCode();
        h = h * 17 + this.timeout.hashCode();
        h = h * 17 + this.notes.hashCode();
        h = h * 17 + this.deregisterCriticalServiceAfter.hashCode();
        h = h * 17 + this.tlsSkipVerify.hashCode();
        h = h * 17 + this.status.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RegCheck").omitNullValues().add("script", this.script.orNull()).add("interval", this.interval.orNull()).add("ttl", this.ttl.orNull()).add("http", this.http.orNull()).add("tcp", this.tcp.orNull()).add("timeout", this.timeout.orNull()).add("notes", this.notes.orNull()).add("deregisterCriticalServiceAfter", this.deregisterCriticalServiceAfter.orNull()).add("tlsSkipVerify", this.tlsSkipVerify.orNull()).add("status", this.status.orNull()).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableRegCheck fromJson(Json json) {
        Builder builder = ImmutableRegCheck.builder();
        if (json.script != null) {
            builder.script(json.script);
        }
        if (json.interval != null) {
            builder.interval(json.interval);
        }
        if (json.ttl != null) {
            builder.ttl(json.ttl);
        }
        if (json.http != null) {
            builder.http(json.http);
        }
        if (json.tcp != null) {
            builder.tcp(json.tcp);
        }
        if (json.timeout != null) {
            builder.timeout(json.timeout);
        }
        if (json.notes != null) {
            builder.notes(json.notes);
        }
        if (json.deregisterCriticalServiceAfter != null) {
            builder.deregisterCriticalServiceAfter(json.deregisterCriticalServiceAfter);
        }
        if (json.tlsSkipVerify != null) {
            builder.tlsSkipVerify(json.tlsSkipVerify);
        }
        if (json.status != null) {
            builder.status(json.status);
        }
        return builder.build();
    }

    private static ImmutableRegCheck validate(ImmutableRegCheck instance) {
        instance.validate();
        return instance;
    }

    public static ImmutableRegCheck copyOf(Registration.RegCheck instance) {
        if (instance instanceof ImmutableRegCheck) {
            return (ImmutableRegCheck)instance;
        }
        return ImmutableRegCheck.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private Optional<String> script = Optional.absent();
        private Optional<String> interval = Optional.absent();
        private Optional<String> ttl = Optional.absent();
        private Optional<String> http = Optional.absent();
        private Optional<String> tcp = Optional.absent();
        private Optional<String> timeout = Optional.absent();
        private Optional<String> notes = Optional.absent();
        private Optional<String> deregisterCriticalServiceAfter = Optional.absent();
        private Optional<Boolean> tlsSkipVerify = Optional.absent();
        private Optional<String> status = Optional.absent();

        private Builder() {
        }

        public final Builder from(Registration.RegCheck instance) {
            Optional<String> statusOptional;
            Optional<Boolean> tlsSkipVerifyOptional;
            Optional<String> deregisterCriticalServiceAfterOptional;
            Optional<String> notesOptional;
            Optional<String> timeoutOptional;
            Optional<String> tcpOptional;
            Optional<String> httpOptional;
            Optional<String> ttlOptional;
            Optional<String> intervalOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<String> scriptOptional = instance.getScript();
            if (scriptOptional.isPresent()) {
                this.script(scriptOptional);
            }
            if ((intervalOptional = instance.getInterval()).isPresent()) {
                this.interval(intervalOptional);
            }
            if ((ttlOptional = instance.getTtl()).isPresent()) {
                this.ttl(ttlOptional);
            }
            if ((httpOptional = instance.getHttp()).isPresent()) {
                this.http(httpOptional);
            }
            if ((tcpOptional = instance.getTcp()).isPresent()) {
                this.tcp(tcpOptional);
            }
            if ((timeoutOptional = instance.getTimeout()).isPresent()) {
                this.timeout(timeoutOptional);
            }
            if ((notesOptional = instance.getNotes()).isPresent()) {
                this.notes(notesOptional);
            }
            if ((deregisterCriticalServiceAfterOptional = instance.getDeregisterCriticalServiceAfter()).isPresent()) {
                this.deregisterCriticalServiceAfter(deregisterCriticalServiceAfterOptional);
            }
            if ((tlsSkipVerifyOptional = instance.getTlsSkipVerify()).isPresent()) {
                this.tlsSkipVerify(tlsSkipVerifyOptional);
            }
            if ((statusOptional = instance.getStatus()).isPresent()) {
                this.status(statusOptional);
            }
            return this;
        }

        public final Builder script(String script) {
            this.script = Optional.of((Object)script);
            return this;
        }

        public final Builder script(Optional<String> script) {
            this.script = (Optional)Preconditions.checkNotNull(script, (Object)"script");
            return this;
        }

        public final Builder interval(String interval) {
            this.interval = Optional.of((Object)interval);
            return this;
        }

        public final Builder interval(Optional<String> interval) {
            this.interval = (Optional)Preconditions.checkNotNull(interval, (Object)"interval");
            return this;
        }

        public final Builder ttl(String ttl) {
            this.ttl = Optional.of((Object)ttl);
            return this;
        }

        public final Builder ttl(Optional<String> ttl) {
            this.ttl = (Optional)Preconditions.checkNotNull(ttl, (Object)"ttl");
            return this;
        }

        public final Builder http(String http) {
            this.http = Optional.of((Object)http);
            return this;
        }

        public final Builder http(Optional<String> http) {
            this.http = (Optional)Preconditions.checkNotNull(http, (Object)"http");
            return this;
        }

        public final Builder tcp(String tcp) {
            this.tcp = Optional.of((Object)tcp);
            return this;
        }

        public final Builder tcp(Optional<String> tcp) {
            this.tcp = (Optional)Preconditions.checkNotNull(tcp, (Object)"tcp");
            return this;
        }

        public final Builder timeout(String timeout) {
            this.timeout = Optional.of((Object)timeout);
            return this;
        }

        public final Builder timeout(Optional<String> timeout) {
            this.timeout = (Optional)Preconditions.checkNotNull(timeout, (Object)"timeout");
            return this;
        }

        public final Builder notes(String notes) {
            this.notes = Optional.of((Object)notes);
            return this;
        }

        public final Builder notes(Optional<String> notes) {
            this.notes = (Optional)Preconditions.checkNotNull(notes, (Object)"notes");
            return this;
        }

        public final Builder deregisterCriticalServiceAfter(String deregisterCriticalServiceAfter) {
            this.deregisterCriticalServiceAfter = Optional.of((Object)deregisterCriticalServiceAfter);
            return this;
        }

        public final Builder deregisterCriticalServiceAfter(Optional<String> deregisterCriticalServiceAfter) {
            this.deregisterCriticalServiceAfter = (Optional)Preconditions.checkNotNull(deregisterCriticalServiceAfter, (Object)"deregisterCriticalServiceAfter");
            return this;
        }

        public final Builder tlsSkipVerify(boolean tlsSkipVerify) {
            this.tlsSkipVerify = Optional.of((Object)tlsSkipVerify);
            return this;
        }

        public final Builder tlsSkipVerify(Optional<Boolean> tlsSkipVerify) {
            this.tlsSkipVerify = (Optional)Preconditions.checkNotNull(tlsSkipVerify, (Object)"tlsSkipVerify");
            return this;
        }

        public final Builder status(String status) {
            this.status = Optional.of((Object)status);
            return this;
        }

        public final Builder status(Optional<String> status) {
            this.status = (Optional)Preconditions.checkNotNull(status, (Object)"status");
            return this;
        }

        public ImmutableRegCheck build() {
            return ImmutableRegCheck.validate(new ImmutableRegCheck(this.script, this.interval, this.ttl, this.http, this.tcp, this.timeout, this.notes, this.deregisterCriticalServiceAfter, this.tlsSkipVerify, this.status));
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Registration.RegCheck {
        Optional<String> script = Optional.absent();
        Optional<String> interval = Optional.absent();
        Optional<String> ttl = Optional.absent();
        Optional<String> http = Optional.absent();
        Optional<String> tcp = Optional.absent();
        Optional<String> timeout = Optional.absent();
        Optional<String> notes = Optional.absent();
        Optional<String> deregisterCriticalServiceAfter = Optional.absent();
        Optional<Boolean> tlsSkipVerify = Optional.absent();
        Optional<String> status = Optional.absent();

        Json() {
        }

        @JsonProperty(value="Script")
        public void setScript(Optional<String> script) {
            this.script = script;
        }

        @JsonProperty(value="Interval")
        public void setInterval(Optional<String> interval) {
            this.interval = interval;
        }

        @JsonProperty(value="TTL")
        public void setTtl(Optional<String> ttl) {
            this.ttl = ttl;
        }

        @JsonProperty(value="HTTP")
        public void setHttp(Optional<String> http) {
            this.http = http;
        }

        @JsonProperty(value="TCP")
        public void setTcp(Optional<String> tcp) {
            this.tcp = tcp;
        }

        @JsonProperty(value="Timeout")
        public void setTimeout(Optional<String> timeout) {
            this.timeout = timeout;
        }

        @JsonProperty(value="Notes")
        public void setNotes(Optional<String> notes) {
            this.notes = notes;
        }

        @JsonProperty(value="DeregisterCriticalServiceAfter")
        public void setDeregisterCriticalServiceAfter(Optional<String> deregisterCriticalServiceAfter) {
            this.deregisterCriticalServiceAfter = deregisterCriticalServiceAfter;
        }

        @JsonProperty(value="TLSSkipVerify")
        public void setTlsSkipVerify(Optional<Boolean> tlsSkipVerify) {
            this.tlsSkipVerify = tlsSkipVerify;
        }

        @JsonProperty(value="Status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @Override
        public Optional<String> getScript() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getInterval() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTtl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getHttp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTcp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTimeout() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getNotes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDeregisterCriticalServiceAfter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getTlsSkipVerify() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getStatus() {
            throw new UnsupportedOperationException();
        }
    }
}

