/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.google.common.collect.ImmutableMap;
import com.orbitz.consul.model.coordinate.Coordinate;
import com.orbitz.consul.model.coordinate.Datacenter;
import com.orbitz.consul.util.Http;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.QueryMap;

public class CoordinateClient {
    private final Api api;

    CoordinateClient(Retrofit retrofit) {
        this.api = (Api)retrofit.create(Api.class);
    }

    public List<Datacenter> getDatacenters() {
        return Http.extract(this.api.getDatacenters(), new Integer[0]);
    }

    public List<Coordinate> getNodes(String dc) {
        return Http.extract(this.api.getNodes(this.dcQuery(dc)), new Integer[0]);
    }

    public List<Coordinate> getNodes() {
        return this.getNodes(null);
    }

    private Map<String, String> dcQuery(String dc) {
        ImmutableMap query = Collections.emptyMap();
        if (dc != null) {
            query = ImmutableMap.of((Object)"dc", (Object)dc);
        }
        return query;
    }

    static interface Api {
        @GET(value="coordinate/datacenters")
        public Call<List<Datacenter>> getDatacenters();

        @GET(value="coordinate/nodes")
        public Call<List<Coordinate>> getNodes(@QueryMap Map<String, String> var1);
    }
}

