/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.agent.Check;
import com.orbitz.consul.model.catalog.CatalogRegistration;
import com.orbitz.consul.model.catalog.TaggedAddresses;
import com.orbitz.consul.model.catalog.WriteRequest;
import com.orbitz.consul.model.health.Service;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableCatalogRegistration
extends CatalogRegistration {
    private final Optional<String> datacenter;
    private final String node;
    private final String address;
    private final Optional<TaggedAddresses> taggedAddresses;
    private final Optional<Service> service;
    private final Optional<Check> check;
    private final Optional<WriteRequest> writeRequest;

    private ImmutableCatalogRegistration(Optional<String> datacenter, String node, String address, Optional<TaggedAddresses> taggedAddresses, Optional<Service> service, Optional<Check> check, Optional<WriteRequest> writeRequest) {
        this.datacenter = datacenter;
        this.node = node;
        this.address = address;
        this.taggedAddresses = taggedAddresses;
        this.service = service;
        this.check = check;
        this.writeRequest = writeRequest;
    }

    @Override
    @JsonProperty(value="Datacenter")
    public Optional<String> datacenter() {
        return this.datacenter;
    }

    @Override
    @JsonProperty(value="Node")
    public String node() {
        return this.node;
    }

    @Override
    @JsonProperty(value="Address")
    public String address() {
        return this.address;
    }

    @Override
    @JsonProperty(value="TaggedAddresses")
    public Optional<TaggedAddresses> taggedAddresses() {
        return this.taggedAddresses;
    }

    @Override
    @JsonProperty(value="Service")
    public Optional<Service> service() {
        return this.service;
    }

    @Override
    @JsonProperty(value="Check")
    public Optional<Check> check() {
        return this.check;
    }

    @Override
    @JsonProperty(value="WriteRequest")
    public Optional<WriteRequest> writeRequest() {
        return this.writeRequest;
    }

    public final ImmutableCatalogRegistration withDatacenter(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.datacenter.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableCatalogRegistration((Optional<String>)newValue, this.node, this.address, this.taggedAddresses, this.service, this.check, this.writeRequest);
    }

    public final ImmutableCatalogRegistration withDatacenter(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"datacenter");
        if (this.datacenter.equals((Object)value)) {
            return this;
        }
        return new ImmutableCatalogRegistration((Optional<String>)value, this.node, this.address, this.taggedAddresses, this.service, this.check, this.writeRequest);
    }

    public final ImmutableCatalogRegistration withNode(String value) {
        if (this.node.equals(value)) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.datacenter, (String)Preconditions.checkNotNull((Object)value, (Object)"node"), this.address, this.taggedAddresses, this.service, this.check, this.writeRequest);
    }

    public final ImmutableCatalogRegistration withAddress(String value) {
        if (this.address.equals(value)) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.datacenter, this.node, (String)Preconditions.checkNotNull((Object)value, (Object)"address"), this.taggedAddresses, this.service, this.check, this.writeRequest);
    }

    public final ImmutableCatalogRegistration withTaggedAddresses(TaggedAddresses value) {
        Optional newValue = Optional.of((Object)value);
        if (this.taggedAddresses.isPresent() && this.taggedAddresses.get() == value) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.datacenter, this.node, this.address, (Optional<TaggedAddresses>)newValue, this.service, this.check, this.writeRequest);
    }

    public final ImmutableCatalogRegistration withTaggedAddresses(Optional<TaggedAddresses> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"taggedAddresses");
        if (!this.taggedAddresses.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.taggedAddresses.isPresent() && value.isPresent() && this.taggedAddresses.get() == value.get()) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.datacenter, this.node, this.address, (Optional<TaggedAddresses>)value, this.service, this.check, this.writeRequest);
    }

    public final ImmutableCatalogRegistration withService(Service value) {
        Optional newValue = Optional.of((Object)value);
        if (this.service.isPresent() && this.service.get() == value) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.datacenter, this.node, this.address, this.taggedAddresses, (Optional<Service>)newValue, this.check, this.writeRequest);
    }

    public final ImmutableCatalogRegistration withService(Optional<Service> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"service");
        if (!this.service.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.service.isPresent() && value.isPresent() && this.service.get() == value.get()) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.datacenter, this.node, this.address, this.taggedAddresses, (Optional<Service>)value, this.check, this.writeRequest);
    }

    public final ImmutableCatalogRegistration withCheck(Check value) {
        Optional newValue = Optional.of((Object)value);
        if (this.check.isPresent() && this.check.get() == value) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.datacenter, this.node, this.address, this.taggedAddresses, this.service, (Optional<Check>)newValue, this.writeRequest);
    }

    public final ImmutableCatalogRegistration withCheck(Optional<Check> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"check");
        if (!this.check.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.check.isPresent() && value.isPresent() && this.check.get() == value.get()) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.datacenter, this.node, this.address, this.taggedAddresses, this.service, (Optional<Check>)value, this.writeRequest);
    }

    public final ImmutableCatalogRegistration withWriteRequest(WriteRequest value) {
        Optional newValue = Optional.of((Object)value);
        if (this.writeRequest.isPresent() && this.writeRequest.get() == value) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.datacenter, this.node, this.address, this.taggedAddresses, this.service, this.check, (Optional<WriteRequest>)newValue);
    }

    public final ImmutableCatalogRegistration withWriteRequest(Optional<WriteRequest> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"writeRequest");
        if (!this.writeRequest.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.writeRequest.isPresent() && value.isPresent() && this.writeRequest.get() == value.get()) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.datacenter, this.node, this.address, this.taggedAddresses, this.service, this.check, (Optional<WriteRequest>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCatalogRegistration && this.equalTo((ImmutableCatalogRegistration)another);
    }

    private boolean equalTo(ImmutableCatalogRegistration another) {
        return this.datacenter.equals(another.datacenter) && this.node.equals(another.node) && this.address.equals(another.address) && this.taggedAddresses.equals(another.taggedAddresses) && this.service.equals(another.service) && this.check.equals(another.check) && this.writeRequest.equals(another.writeRequest);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.datacenter.hashCode();
        h = h * 17 + this.node.hashCode();
        h = h * 17 + this.address.hashCode();
        h = h * 17 + this.taggedAddresses.hashCode();
        h = h * 17 + this.service.hashCode();
        h = h * 17 + this.check.hashCode();
        h = h * 17 + this.writeRequest.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CatalogRegistration").omitNullValues().add("datacenter", this.datacenter.orNull()).add("node", (Object)this.node).add("address", (Object)this.address).add("taggedAddresses", this.taggedAddresses.orNull()).add("service", this.service.orNull()).add("check", this.check.orNull()).add("writeRequest", this.writeRequest.orNull()).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableCatalogRegistration fromJson(Json json) {
        Builder builder = ImmutableCatalogRegistration.builder();
        if (json.datacenter != null) {
            builder.datacenter(json.datacenter);
        }
        if (json.node != null) {
            builder.node(json.node);
        }
        if (json.address != null) {
            builder.address(json.address);
        }
        if (json.taggedAddresses != null) {
            builder.taggedAddresses(json.taggedAddresses);
        }
        if (json.service != null) {
            builder.service(json.service);
        }
        if (json.check != null) {
            builder.check(json.check);
        }
        if (json.writeRequest != null) {
            builder.writeRequest(json.writeRequest);
        }
        return builder.build();
    }

    public static ImmutableCatalogRegistration copyOf(CatalogRegistration instance) {
        if (instance instanceof ImmutableCatalogRegistration) {
            return (ImmutableCatalogRegistration)instance;
        }
        return ImmutableCatalogRegistration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NODE = 1L;
        private static final long INIT_BIT_ADDRESS = 2L;
        private long initBits = 3L;
        private Optional<String> datacenter = Optional.absent();
        @Nullable
        private String node;
        @Nullable
        private String address;
        private Optional<TaggedAddresses> taggedAddresses = Optional.absent();
        private Optional<Service> service = Optional.absent();
        private Optional<Check> check = Optional.absent();
        private Optional<WriteRequest> writeRequest = Optional.absent();

        private Builder() {
        }

        public final Builder from(CatalogRegistration instance) {
            Optional<WriteRequest> writeRequestOptional;
            Optional<Check> checkOptional;
            Optional<Service> serviceOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<String> datacenterOptional = instance.datacenter();
            if (datacenterOptional.isPresent()) {
                this.datacenter(datacenterOptional);
            }
            this.node(instance.node());
            this.address(instance.address());
            Optional<TaggedAddresses> taggedAddressesOptional = instance.taggedAddresses();
            if (taggedAddressesOptional.isPresent()) {
                this.taggedAddresses(taggedAddressesOptional);
            }
            if ((serviceOptional = instance.service()).isPresent()) {
                this.service(serviceOptional);
            }
            if ((checkOptional = instance.check()).isPresent()) {
                this.check(checkOptional);
            }
            if ((writeRequestOptional = instance.writeRequest()).isPresent()) {
                this.writeRequest(writeRequestOptional);
            }
            return this;
        }

        public final Builder datacenter(String datacenter) {
            this.datacenter = Optional.of((Object)datacenter);
            return this;
        }

        public final Builder datacenter(Optional<String> datacenter) {
            this.datacenter = (Optional)Preconditions.checkNotNull(datacenter, (Object)"datacenter");
            return this;
        }

        public final Builder node(String node) {
            this.node = (String)Preconditions.checkNotNull((Object)node, (Object)"node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder address(String address) {
            this.address = (String)Preconditions.checkNotNull((Object)address, (Object)"address");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder taggedAddresses(TaggedAddresses taggedAddresses) {
            this.taggedAddresses = Optional.of((Object)taggedAddresses);
            return this;
        }

        public final Builder taggedAddresses(Optional<TaggedAddresses> taggedAddresses) {
            this.taggedAddresses = (Optional)Preconditions.checkNotNull(taggedAddresses, (Object)"taggedAddresses");
            return this;
        }

        public final Builder service(Service service) {
            this.service = Optional.of((Object)service);
            return this;
        }

        public final Builder service(Optional<Service> service) {
            this.service = (Optional)Preconditions.checkNotNull(service, (Object)"service");
            return this;
        }

        public final Builder check(Check check) {
            this.check = Optional.of((Object)check);
            return this;
        }

        public final Builder check(Optional<Check> check) {
            this.check = (Optional)Preconditions.checkNotNull(check, (Object)"check");
            return this;
        }

        public final Builder writeRequest(WriteRequest writeRequest) {
            this.writeRequest = Optional.of((Object)writeRequest);
            return this;
        }

        public final Builder writeRequest(Optional<WriteRequest> writeRequest) {
            this.writeRequest = (Optional)Preconditions.checkNotNull(writeRequest, (Object)"writeRequest");
            return this;
        }

        public ImmutableCatalogRegistration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCatalogRegistration(this.datacenter, this.node, this.address, this.taggedAddresses, this.service, this.check, this.writeRequest);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("address");
            }
            return "Cannot build CatalogRegistration, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends CatalogRegistration {
        Optional<String> datacenter = Optional.absent();
        @Nullable
        String node;
        @Nullable
        String address;
        Optional<TaggedAddresses> taggedAddresses = Optional.absent();
        Optional<Service> service = Optional.absent();
        Optional<Check> check = Optional.absent();
        Optional<WriteRequest> writeRequest = Optional.absent();

        Json() {
        }

        @JsonProperty(value="Datacenter")
        public void setDatacenter(Optional<String> datacenter) {
            this.datacenter = datacenter;
        }

        @JsonProperty(value="Node")
        public void setNode(String node) {
            this.node = node;
        }

        @JsonProperty(value="Address")
        public void setAddress(String address) {
            this.address = address;
        }

        @JsonProperty(value="TaggedAddresses")
        public void setTaggedAddresses(Optional<TaggedAddresses> taggedAddresses) {
            this.taggedAddresses = taggedAddresses;
        }

        @JsonProperty(value="Service")
        public void setService(Optional<Service> service) {
            this.service = service;
        }

        @JsonProperty(value="Check")
        public void setCheck(Optional<Check> check) {
            this.check = check;
        }

        @JsonProperty(value="WriteRequest")
        public void setWriteRequest(Optional<WriteRequest> writeRequest) {
            this.writeRequest = writeRequest;
        }

        @Override
        public Optional<String> datacenter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String node() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String address() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<TaggedAddresses> taggedAddresses() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Service> service() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Check> check() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<WriteRequest> writeRequest() {
            throw new UnsupportedOperationException();
        }
    }
}

