/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model;

import com.google.common.base.Objects;
import java.math.BigInteger;

public class ConsulResponse<T> {
    private final T response;
    private final long lastContact;
    private final boolean knownLeader;
    private final BigInteger index;

    public ConsulResponse(T response, long lastContact, boolean knownLeader, BigInteger index) {
        this.response = response;
        this.lastContact = lastContact;
        this.knownLeader = knownLeader;
        this.index = index;
    }

    public T getResponse() {
        return this.response;
    }

    public long getLastContact() {
        return this.lastContact;
    }

    public boolean isKnownLeader() {
        return this.knownLeader;
    }

    public BigInteger getIndex() {
        return this.index;
    }

    public String toString() {
        return "ConsulResponse{response=" + this.response + ", lastContact=" + this.lastContact + ", knownLeader=" + this.knownLeader + ", index=" + this.index + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsulResponse that = (ConsulResponse)o;
        return Objects.equal(this.response, that.response) && Objects.equal((Object)this.lastContact, (Object)that.lastContact) && Objects.equal((Object)this.knownLeader, (Object)that.knownLeader) && Objects.equal((Object)this.index, (Object)that.index);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.response, this.lastContact, this.knownLeader, this.index});
    }
}

