/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.session;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orbitz.consul.model.session.Session;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableSession
extends Session {
    private final Optional<String> lockDelay;
    private final Optional<String> name;
    private final Optional<String> node;
    private final ImmutableList<String> checks;
    private final Optional<String> behavior;
    private final Optional<String> ttl;

    private ImmutableSession(Optional<String> lockDelay, Optional<String> name, Optional<String> node, ImmutableList<String> checks, Optional<String> behavior, Optional<String> ttl) {
        this.lockDelay = lockDelay;
        this.name = name;
        this.node = node;
        this.checks = checks;
        this.behavior = behavior;
        this.ttl = ttl;
    }

    @Override
    @JsonProperty(value="LockDelay")
    public Optional<String> getLockDelay() {
        return this.lockDelay;
    }

    @Override
    @JsonProperty(value="Name")
    public Optional<String> getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Node")
    public Optional<String> getNode() {
        return this.node;
    }

    @JsonProperty(value="Checks")
    public ImmutableList<String> getChecks() {
        return this.checks;
    }

    @Override
    @JsonProperty(value="Behavior")
    public Optional<String> getBehavior() {
        return this.behavior;
    }

    @Override
    @JsonProperty(value="TTL")
    public Optional<String> getTtl() {
        return this.ttl;
    }

    public final ImmutableSession withLockDelay(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.lockDelay.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableSession((Optional<String>)newValue, this.name, this.node, this.checks, this.behavior, this.ttl);
    }

    public final ImmutableSession withLockDelay(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"lockDelay");
        if (this.lockDelay.equals((Object)value)) {
            return this;
        }
        return new ImmutableSession((Optional<String>)value, this.name, this.node, this.checks, this.behavior, this.ttl);
    }

    public final ImmutableSession withName(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.name.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableSession(this.lockDelay, (Optional<String>)newValue, this.node, this.checks, this.behavior, this.ttl);
    }

    public final ImmutableSession withName(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"name");
        if (this.name.equals((Object)value)) {
            return this;
        }
        return new ImmutableSession(this.lockDelay, (Optional<String>)value, this.node, this.checks, this.behavior, this.ttl);
    }

    public final ImmutableSession withNode(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.node.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableSession(this.lockDelay, this.name, (Optional<String>)newValue, this.checks, this.behavior, this.ttl);
    }

    public final ImmutableSession withNode(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"node");
        if (this.node.equals((Object)value)) {
            return this;
        }
        return new ImmutableSession(this.lockDelay, this.name, (Optional<String>)value, this.checks, this.behavior, this.ttl);
    }

    public final ImmutableSession withChecks(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableSession(this.lockDelay, this.name, this.node, (ImmutableList<String>)newValue, this.behavior, this.ttl);
    }

    public final ImmutableSession withChecks(Iterable<String> elements) {
        if (this.checks == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSession(this.lockDelay, this.name, this.node, (ImmutableList<String>)newValue, this.behavior, this.ttl);
    }

    public final ImmutableSession withBehavior(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.behavior.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableSession(this.lockDelay, this.name, this.node, this.checks, (Optional<String>)newValue, this.ttl);
    }

    public final ImmutableSession withBehavior(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"behavior");
        if (this.behavior.equals((Object)value)) {
            return this;
        }
        return new ImmutableSession(this.lockDelay, this.name, this.node, this.checks, (Optional<String>)value, this.ttl);
    }

    public final ImmutableSession withTtl(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.ttl.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableSession(this.lockDelay, this.name, this.node, this.checks, this.behavior, (Optional<String>)newValue);
    }

    public final ImmutableSession withTtl(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"ttl");
        if (this.ttl.equals((Object)value)) {
            return this;
        }
        return new ImmutableSession(this.lockDelay, this.name, this.node, this.checks, this.behavior, (Optional<String>)value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSession && this.equalTo((ImmutableSession)another);
    }

    private boolean equalTo(ImmutableSession another) {
        return this.lockDelay.equals(another.lockDelay) && this.name.equals(another.name) && this.node.equals(another.node) && this.checks.equals(another.checks) && this.behavior.equals(another.behavior) && this.ttl.equals(another.ttl);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.lockDelay.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.node.hashCode();
        h = h * 17 + this.checks.hashCode();
        h = h * 17 + this.behavior.hashCode();
        h = h * 17 + this.ttl.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Session").omitNullValues().add("lockDelay", this.lockDelay.orNull()).add("name", this.name.orNull()).add("node", this.node.orNull()).add("checks", this.checks).add("behavior", this.behavior.orNull()).add("ttl", this.ttl.orNull()).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableSession fromJson(Json json) {
        Builder builder = ImmutableSession.builder();
        if (json.lockDelay != null) {
            builder.lockDelay(json.lockDelay);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.node != null) {
            builder.node(json.node);
        }
        if (json.checks != null) {
            builder.addAllChecks(json.checks);
        }
        if (json.behavior != null) {
            builder.behavior(json.behavior);
        }
        if (json.ttl != null) {
            builder.ttl(json.ttl);
        }
        return builder.build();
    }

    public static ImmutableSession copyOf(Session instance) {
        if (instance instanceof ImmutableSession) {
            return (ImmutableSession)instance;
        }
        return ImmutableSession.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Optional<String> lockDelay = Optional.absent();
        private Optional<String> name = Optional.absent();
        private Optional<String> node = Optional.absent();
        private ImmutableList.Builder<String> checksBuilder = ImmutableList.builder();
        private Optional<String> behavior = Optional.absent();
        private Optional<String> ttl = Optional.absent();

        private Builder() {
        }

        public final Builder from(Session instance) {
            Optional<String> ttlOptional;
            Optional<String> nodeOptional;
            Optional<String> nameOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<String> lockDelayOptional = instance.getLockDelay();
            if (lockDelayOptional.isPresent()) {
                this.lockDelay(lockDelayOptional);
            }
            if ((nameOptional = instance.getName()).isPresent()) {
                this.name(nameOptional);
            }
            if ((nodeOptional = instance.getNode()).isPresent()) {
                this.node(nodeOptional);
            }
            this.addAllChecks(instance.getChecks());
            Optional<String> behaviorOptional = instance.getBehavior();
            if (behaviorOptional.isPresent()) {
                this.behavior(behaviorOptional);
            }
            if ((ttlOptional = instance.getTtl()).isPresent()) {
                this.ttl(ttlOptional);
            }
            return this;
        }

        public final Builder lockDelay(String lockDelay) {
            this.lockDelay = Optional.of((Object)lockDelay);
            return this;
        }

        public final Builder lockDelay(Optional<String> lockDelay) {
            this.lockDelay = (Optional)Preconditions.checkNotNull(lockDelay, (Object)"lockDelay");
            return this;
        }

        public final Builder name(String name) {
            this.name = Optional.of((Object)name);
            return this;
        }

        public final Builder name(Optional<String> name) {
            this.name = (Optional)Preconditions.checkNotNull(name, (Object)"name");
            return this;
        }

        public final Builder node(String node) {
            this.node = Optional.of((Object)node);
            return this;
        }

        public final Builder node(Optional<String> node) {
            this.node = (Optional)Preconditions.checkNotNull(node, (Object)"node");
            return this;
        }

        public final Builder addChecks(String element) {
            this.checksBuilder.add((Object)element);
            return this;
        }

        public final Builder addChecks(String ... elements) {
            this.checksBuilder.add((Object[])elements);
            return this;
        }

        public final Builder checks(Iterable<String> elements) {
            this.checksBuilder = ImmutableList.builder();
            return this.addAllChecks(elements);
        }

        public final Builder addAllChecks(Iterable<String> elements) {
            this.checksBuilder.addAll(elements);
            return this;
        }

        public final Builder behavior(String behavior) {
            this.behavior = Optional.of((Object)behavior);
            return this;
        }

        public final Builder behavior(Optional<String> behavior) {
            this.behavior = (Optional)Preconditions.checkNotNull(behavior, (Object)"behavior");
            return this;
        }

        public final Builder ttl(String ttl) {
            this.ttl = Optional.of((Object)ttl);
            return this;
        }

        public final Builder ttl(Optional<String> ttl) {
            this.ttl = (Optional)Preconditions.checkNotNull(ttl, (Object)"ttl");
            return this;
        }

        public ImmutableSession build() {
            return new ImmutableSession(this.lockDelay, this.name, this.node, this.checksBuilder.build(), this.behavior, this.ttl);
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Session {
        Optional<String> lockDelay = Optional.absent();
        Optional<String> name = Optional.absent();
        Optional<String> node = Optional.absent();
        List<String> checks = ImmutableList.of();
        Optional<String> behavior = Optional.absent();
        Optional<String> ttl = Optional.absent();

        Json() {
        }

        @JsonProperty(value="LockDelay")
        public void setLockDelay(Optional<String> lockDelay) {
            this.lockDelay = lockDelay;
        }

        @JsonProperty(value="Name")
        public void setName(Optional<String> name) {
            this.name = name;
        }

        @JsonProperty(value="Node")
        public void setNode(Optional<String> node) {
            this.node = node;
        }

        @JsonProperty(value="Checks")
        public void setChecks(List<String> checks) {
            this.checks = checks;
        }

        @JsonProperty(value="Behavior")
        public void setBehavior(Optional<String> behavior) {
            this.behavior = behavior;
        }

        @JsonProperty(value="TTL")
        public void setTtl(Optional<String> ttl) {
            this.ttl = ttl;
        }

        @Override
        public Optional<String> getLockDelay() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getChecks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getBehavior() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTtl() {
            throw new UnsupportedOperationException();
        }
    }
}

