/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.query.Template;
import java.util.ArrayList;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableTemplate
extends Template {
    private final String type;
    private final Optional<String> regExp;

    private ImmutableTemplate(String type, Optional<String> regExp) {
        this.type = type;
        this.regExp = regExp;
    }

    @Override
    @JsonProperty(value="Type")
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="RegExp")
    public Optional<String> getRegExp() {
        return this.regExp;
    }

    public final ImmutableTemplate withType(String value) {
        if (this.type.equals(value)) {
            return this;
        }
        return new ImmutableTemplate((String)Preconditions.checkNotNull((Object)value, (Object)"type"), this.regExp);
    }

    public final ImmutableTemplate withRegExp(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.regExp.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableTemplate(this.type, (Optional<String>)newValue);
    }

    public final ImmutableTemplate withRegExp(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"regExp");
        if (this.regExp.equals((Object)value)) {
            return this;
        }
        return new ImmutableTemplate(this.type, (Optional<String>)value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTemplate && this.equalTo((ImmutableTemplate)another);
    }

    private boolean equalTo(ImmutableTemplate another) {
        return this.type.equals(another.type) && this.regExp.equals(another.regExp);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.regExp.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Template").omitNullValues().add("type", (Object)this.type).add("regExp", this.regExp.orNull()).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableTemplate fromJson(Json json) {
        Builder builder = ImmutableTemplate.builder();
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.regExp != null) {
            builder.regExp(json.regExp);
        }
        return builder.build();
    }

    public static ImmutableTemplate copyOf(Template instance) {
        if (instance instanceof ImmutableTemplate) {
            return (ImmutableTemplate)instance;
        }
        return ImmutableTemplate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        private String type;
        private Optional<String> regExp = Optional.absent();

        private Builder() {
        }

        public final Builder from(Template instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.type(instance.getType());
            Optional<String> regExpOptional = instance.getRegExp();
            if (regExpOptional.isPresent()) {
                this.regExp(regExpOptional);
            }
            return this;
        }

        public final Builder type(String type) {
            this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder regExp(String regExp) {
            this.regExp = Optional.of((Object)regExp);
            return this;
        }

        public final Builder regExp(Optional<String> regExp) {
            this.regExp = (Optional)Preconditions.checkNotNull(regExp, (Object)"regExp");
            return this;
        }

        public ImmutableTemplate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTemplate(this.type, this.regExp);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build Template, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Template {
        String type;
        Optional<String> regExp = Optional.absent();

        Json() {
        }

        @JsonProperty(value="Type")
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="RegExp")
        public void setRegExp(Optional<String> regExp) {
            this.regExp = regExp;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getRegExp() {
            throw new UnsupportedOperationException();
        }
    }
}

